/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.function.Supplier;
import luckytntlib.block.LTNTBlock;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public class CompactTNTEffect
extends PrimedTNTEffect {
    private final double chance;
    private final int size;
    private final Supplier<RegistryObject<LTNTBlock>> place;

    public CompactTNTEffect(double chance, int size, Supplier<RegistryObject<LTNTBlock>> place) {
        this.chance = chance;
        this.size = size;
        this.place = place;
    }

    public void serverExplosion(IExplosiveEntity entity) {
        final ImprovedExplosion explosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), this.size);
        explosion.doBlockExplosion(new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if (Math.random() < CompactTNTEffect.this.chance && !state.m_60795_() && state.getExplosionResistance((BlockGetter)level, pos, (Explosion)explosion) < 100.0f) {
                    state.onBlockExploded(level, pos, (Explosion)explosion);
                    level.m_46597_(pos, ((LTNTBlock)CompactTNTEffect.this.place.get().get()).m_49966_());
                }
            }
        });
    }
}

