/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import luckytnt.registry.BlockRegistry;
import luckytnt.registry.EntityRegistry;
import luckytntlib.entity.LExplosiveProjectile;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ChemicalTNTEffect
extends PrimedTNTEffect {
    public void baseTick(IExplosiveEntity entity) {
        if (entity instanceof LExplosiveProjectile) {
            if (!entity.getLevel().f_46443_) {
                this.explosionTick(entity);
            } else {
                this.spawnParticles(entity);
            }
            entity.setTNTFuse(entity.getTNTFuse() - 1);
            if (entity.getTNTFuse() <= 0) {
                entity.destroy();
            }
        } else {
            super.baseTick(entity);
        }
    }

    public void explosionTick(IExplosiveEntity entity) {
        if (entity instanceof LExplosiveProjectile) {
            final ImprovedExplosion dummyExplosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), 4);
            ExplosionHelper.doSphericalExplosion((Level)entity.getLevel(), (Vec3)entity.getPos(), (int)4, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

                public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                    if (distance + Math.random() < 4.0 && state.getExplosionResistance((BlockGetter)level, pos, (Explosion)dummyExplosion) < 100.0f) {
                        state.onBlockExploded(level, pos, (Explosion)dummyExplosion);
                    }
                }
            });
        }
    }

    public void serverExplosion(IExplosiveEntity entity) {
        for (int count = 0; count < 30; ++count) {
            LExplosiveProjectile projectile = (LExplosiveProjectile)((EntityType)EntityRegistry.CHEMICAL_PROJECTILE.get()).m_20615_(entity.getLevel());
            projectile.m_146884_(entity.getPos());
            projectile.setOwner(entity.owner());
            projectile.m_20334_(Math.random() * 1.5 - Math.random() * 1.5, (double)0.2f, Math.random() * 1.5 - Math.random() * 1.5);
            entity.getLevel().m_7967_((Entity)projectile);
        }
    }

    public void spawnParticles(IExplosiveEntity entity) {
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.1f, 1.0f, 0.6f), 1.0f), entity.x() + (double)0.2f, entity.y() + 1.0, entity.z(), 0.0, 0.0, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.6f, 0.8f, 0.4f), 1.0f), entity.x() - (double)0.2f, entity.y() + 1.0, entity.z(), 0.0, 0.0, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.8f, 1.0f, 0.8f), 1.0f), entity.x(), entity.y() + 1.0, entity.z() + (double)0.2f, 0.0, 0.0, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.1f, 1.0f, 0.2f), 1.0f), entity.x(), entity.y() + 1.0, entity.z() - (double)0.2f, 0.0, 0.0, 0.0);
    }

    public Block getBlock() {
        return (Block)BlockRegistry.CHEMICAL_TNT.get();
    }
}

