/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import com.google.common.base.Predicate;
import luckytnt.registry.BlockRegistry;
import luckytnt.tnteffects.JungleTNTEffect;
import luckytnt.util.Materials;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class AtlantisEffect
extends PrimedTNTEffect {
    Predicate<Holder<Biome>> predicate = holder -> true;

    public void explosionTick(IExplosiveEntity ent) {
        if (ent.getTNTFuse() == 240) {
            Level level = ent.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel s_Level = (ServerLevel)level;
                s_Level.m_8606_(0, 10000, true, true);
            }
            ent.getLevel().m_6263_(null, ent.x(), ent.y(), ent.z(), SoundEvents.f_12090_, SoundSource.WEATHER, 1000.0f, 1.0f);
        }
    }

    public void serverExplosion(final IExplosiveEntity ent) {
        Registry registry = ent.getLevel().m_9598_().m_175515_(Registries.f_256952_);
        Holder biome = registry.m_263177_((Object)((Biome)registry.m_6246_(Biomes.f_48166_)));
        for (double offX = -100.0; offX < 100.0; offX += 1.0) {
            for (double offZ = -100.0; offZ < 100.0; offZ += 1.0) {
                boolean foundBlock = false;
                double distance = Math.sqrt(offX * offX + offZ * offZ);
                Level level = ent.getLevel();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel sLevel = (ServerLevel)level;
                if (distance < 100.0 && offX % 16.0 == 0.0 && offZ % 16.0 == 0.0) {
                    for (LevelChunkSection section : ent.getLevel().m_46865_(this.toBlockPos(new Vec3(ent.x() + offX, 0.0, ent.z() + offZ))).m_7103_()) {
                        PalettedContainerRO biomesRO = section.m_187996_();
                        for (int i = 0; i < 4; ++i) {
                            for (int j = 0; j < 4; ++j) {
                                for (int k = 0; k < 4; ++k) {
                                    PalettedContainer biomes;
                                    if (!(biomesRO instanceof PalettedContainer) || (biomes = (PalettedContainer)biomesRO).m_63087_(i, j, k) == biome) continue;
                                    biomes.m_63127_(i, j, k, (Object)biome);
                                }
                            }
                        }
                    }
                }
                for (ServerPlayer player : sLevel.m_6907_()) {
                    player.f_8906_.m_9829_((Packet)new ClientboundLevelChunkWithLightPacket(ent.getLevel().m_46745_(this.toBlockPos(new Vec3(ent.x() + offX, 0.0, ent.z() + offZ))), ent.getLevel().m_5518_(), null, null));
                }
                if (!(distance < 50.0)) continue;
                Registry structures = ent.getLevel().m_9598_().m_175515_(Registries.f_256944_);
                Structure ocean_ruin = (Structure)structures.m_6246_(BuiltinStructures.f_209858_);
                for (double offY = (double)ent.getLevel().m_151558_(); offY > (double)ent.getLevel().m_141937_(); offY -= 1.0) {
                    BlockPos pos = this.toBlockPos(new Vec3(ent.x() + offX, offY, ent.z() + offZ));
                    BlockState state = ent.getLevel().m_8055_(pos);
                    if (foundBlock || !state.m_60838_((BlockGetter)ent.getLevel(), pos) || state.m_60795_()) continue;
                    if (Math.random() < (double)5.0E-4f) {
                        StructureStart start = ocean_ruin.m_226596_(sLevel.m_9598_(), sLevel.m_7726_().m_8481_(), sLevel.m_7726_().m_8481_().m_62218_(), sLevel.m_7726_().m_214994_(), sLevel.m_215082_(), sLevel.m_7328_(), new ChunkPos(pos), 20, (LevelHeightAccessor)ent.getLevel(), this.predicate);
                        start.m_226850_((WorldGenLevel)sLevel, sLevel.m_215010_(), sLevel.m_7726_().m_8481_(), RandomSource.m_216327_(), new BoundingBox((int)ent.x() - 150, (int)ent.y() - 150, (int)ent.z() - 150, (int)ent.x() + 150, (int)ent.y() + 150, (int)ent.z() + 150), new ChunkPos(pos));
                    }
                    foundBlock = true;
                }
            }
        }
        JungleTNTEffect.replaceNonSolidBlockOrVegetationWithAir(ent, 100.0, 100.0f, true);
        ExplosionHelper.doSphericalExplosion((Level)ent.getLevel(), (Vec3)ent.getPos().m_82520_(0.0, 8.0, 0.0), (int)100, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                BlockPos posTop = pos.m_7918_(0, 1, 0);
                BlockState stateTop = level.m_8055_(posTop);
                if (ent.y() + 8.0 - (double)pos.m_123342_() >= 0.0 && ent.y() + 8.0 - (double)pos.m_123342_() <= 50.0) {
                    if ((state.getExplosionResistance((BlockGetter)level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)ent.getLevel())) < 0.0f || state.m_60734_() instanceof LiquidBlock || state.m_60795_()) && !Materials.isStone(state)) {
                        state.m_60734_().onBlockExploded(state, level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)ent.getLevel()));
                        level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
                    }
                    if (!(!stateTop.m_60819_().m_192917_((Fluid)Fluids.f_76193_) && !stateTop.m_60819_().m_192917_((Fluid)Fluids.f_76192_) || state.m_60795_() || state.m_60734_() != Blocks.f_50440_ && state.m_60734_() != Blocks.f_50069_ && state.m_60734_() != Blocks.f_152550_ && state.m_60734_() != Blocks.f_50493_ && state.m_60734_() != Blocks.f_49994_ || level.m_8055_(pos.m_7494_()).m_60734_() == Blocks.f_49992_)) {
                        state.m_60734_().onBlockExploded(state, level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)ent.getLevel()));
                        level.m_7731_(pos, Blocks.f_49992_.m_49966_(), 3);
                    }
                }
            }
        });
        for (int count = 0; count < 40; ++count) {
            Squid squid = new Squid(EntityType.f_20480_, ent.getLevel());
            squid.m_6034_(ent.x() + 50.0 * Math.random() - 50.0 * Math.random(), ent.y() + 8.0, ent.z() + 50.0 * Math.random() - 50.0 * Math.random());
            ent.getLevel().m_7967_((Entity)squid);
        }
    }

    public void spawnParticles(IExplosiveEntity ent) {
        ent.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123769_, ent.x(), ent.y() + 1.5, ent.z(), 0.0, 0.0, 0.0);
    }

    public Block getBlock() {
        return (Block)BlockRegistry.ATLANTIS.get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return 240;
    }
}

