/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.List;
import luckytnt.registry.BlockRegistry;
import luckytnt.registry.EntityRegistry;
import luckytntlib.entity.LExplosiveProjectile;
import luckytntlib.entity.PrimedLTNT;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class AcidicTNTEffect
extends PrimedTNTEffect {
    public void baseTick(IExplosiveEntity entity) {
        if (entity instanceof LExplosiveProjectile) {
            if (!entity.getLevel().m_5776_()) {
                this.explosionTick(entity);
            } else {
                this.spawnParticles(entity);
            }
            entity.setTNTFuse(entity.getTNTFuse() - 1);
            if (entity.getTNTFuse() <= 0) {
                entity.destroy();
            }
        } else {
            super.baseTick(entity);
        }
    }

    public void explosionTick(final IExplosiveEntity ent) {
        if (ent instanceof PrimedLTNT) {
            if (ent.getTNTFuse() <= 10) {
                ((Entity)ent).m_20334_(((Entity)ent).m_20184_().f_82479_, (double)0.8f, ((Entity)ent).m_20184_().f_82481_);
            }
        } else {
            if (ent.getTNTFuse() == 0) {
                ent.getLevel().m_5594_(null, this.toBlockPos(ent.getPos()), SoundEvents.f_11937_, SoundSource.MASTER, 1.0f, 1.0f);
            }
            if (!ent.getLevel().m_5776_()) {
                ExplosionHelper.doCubicalExplosion((Level)ent.getLevel(), (Vec3)ent.getPos(), (int)7, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

                    public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                        if (distance <= 5.0 + Math.random() * 2.0 && !state.m_60795_() && state.getExplosionResistance((BlockGetter)level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)ent.getLevel())) <= 200.0f) {
                            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                        }
                    }
                });
            }
            if (ent.getTNTFuse() % 20 == 0) {
                List list = ent.getLevel().m_45976_(LivingEntity.class, new AABB(this.toBlockPos(ent.getPos()).m_7918_(-3, -3, -3), this.toBlockPos(ent.getPos()).m_7918_(3, 3, 3)));
                DamageSources sources = new DamageSources(ent.getLevel().m_9598_());
                for (LivingEntity lent : list) {
                    lent.m_6469_(sources.m_269425_(), 3.0f);
                }
            }
        }
    }

    public void serverExplosion(IExplosiveEntity ent) {
        if (ent instanceof PrimedLTNT) {
            for (int count = 0; count < 70; ++count) {
                LExplosiveProjectile projectile = (LExplosiveProjectile)((EntityType)EntityRegistry.ACIDIC_PROJECTILE.get()).m_20615_(ent.getLevel());
                projectile.m_146884_(ent.getPos());
                projectile.setOwner(ent.owner());
                projectile.m_20334_(Math.random() * 2.5 - Math.random() * 2.5, Math.random() - Math.random(), Math.random() * 2.5 - Math.random() * 2.5);
                ent.getLevel().m_7967_((Entity)projectile);
            }
        }
    }

    public void spawnParticles(IExplosiveEntity ent) {
        if (ent instanceof PrimedLTNT) {
            double i;
            Vec3 vec31 = new Vec3(0.5, Math.sqrt(0.75), 0.0);
            Vec3 vec32 = new Vec3(-0.5, Math.sqrt(0.75), 0.0);
            for (int count = 0; count <= 10; ++count) {
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 0.5f), ent.x() - 0.5 + 0.1 * (double)count, ent.y() + 1.25, ent.z(), 0.0, 0.0, 0.0);
            }
            for (i = 0.0; i < 1.0; i += 0.1) {
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 0.5f), ent.x() + 0.5 + i * vec32.f_82479_, ent.y() + 1.25 + i * vec32.f_82480_, ent.z(), 0.0, 0.0, 0.0);
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 0.5f), ent.x() - 0.5 + i * vec31.f_82479_, ent.y() + 1.25 + i * vec31.f_82480_, ent.z(), 0.0, 0.0, 0.0);
            }
            for (i = 0.0; i < 0.7; i += 0.1) {
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f), ent.x() - 0.1, ent.y() + 1.35 + i * vec31.f_82480_, ent.z(), 0.0, 0.0, 0.0);
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f), ent.x() + 0.1, ent.y() + 1.35 + i * vec31.f_82480_, ent.z(), 0.0, 0.0, 0.0);
            }
            for (i = 0.0; i < 0.4; i += 0.1) {
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f), ent.x() - 0.2, ent.y() + 1.35 + i * vec31.f_82480_, ent.z(), 0.0, 0.0, 0.0);
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f), ent.x() + 0.2, ent.y() + 1.35 + i * vec31.f_82480_, ent.z(), 0.0, 0.0, 0.0);
            }
            for (i = 0.0; i < 0.2; i += 0.1) {
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f), ent.x() - 0.3, ent.y() + 1.35 + i * vec31.f_82480_, ent.z(), 0.0, 0.0, 0.0);
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f), ent.x() + 0.3, ent.y() + 1.35 + i * vec31.f_82480_, ent.z(), 0.0, 0.0, 0.0);
            }
            ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f), ent.x() - 0.4, ent.y() + 1.35, ent.z(), 0.0, 0.0, 0.0);
            ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f), ent.x() + 0.4, ent.y() + 1.35, ent.z(), 0.0, 0.0, 0.0);
            ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f), ent.x(), ent.y() + 1.35, ent.z(), 0.0, 0.0, 0.0);
            ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 0.5f), ent.x(), ent.y() + 1.45, ent.z(), 0.0, 0.0, 0.0);
            ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f), ent.x(), ent.y() + 1.55, ent.z(), 0.0, 0.0, 0.0);
            for (i = 0.0; i < 0.3; i += 0.1) {
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 0.5f), ent.x(), ent.y() + 1.65 + i * vec31.f_82480_, ent.z(), 0.0, 0.0, 0.0);
            }
            ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f), ent.x(), ent.y() + 1.95, ent.z(), 0.0, 0.0, 0.0);
            ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f), ent.x(), ent.y() + 2.05, ent.z(), 0.0, 0.0, 0.0);
        } else {
            ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 1.0f), ent.x() + (double)0.2f, ent.y() + 1.0, ent.z(), 0.0, 0.0, 0.0);
            ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 1.0f), ent.x() - (double)0.2f, ent.y() + 1.0, ent.z(), 0.0, 0.0, 0.0);
            ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 1.0f), ent.x(), ent.y() + 1.0, ent.z() + (double)0.2f, 0.0, 0.0, 0.0);
            ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 1.0f), ent.x(), ent.y() + 1.0, ent.z() - (double)0.2f, 0.0, 0.0, 0.0);
        }
    }

    public Block getBlock() {
        return (Block)BlockRegistry.ACIDIC_TNT.get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return ent instanceof PrimedLTNT ? 160 : 120;
    }
}

