/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.block;

import javax.annotation.Nullable;
import luckytnt.registry.EntityRegistry;
import luckytnt.registry.ItemRegistry;
import luckytnt.util.StructureStates;
import luckytntlib.block.LTNTBlock;
import luckytntlib.entity.PrimedLTNT;
import luckytntlib.util.IExplosiveEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class StructureTNTBlock
extends LTNTBlock {
    public static final EnumProperty<StructureStates> STRUCTURE = EnumProperty.m_61587_((String)"structure", StructureStates.class);

    public StructureTNTBlock(BlockBehaviour.Properties properties) {
        super(properties, EntityRegistry.STRUCTURE_TNT, true);
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> definition) {
        super.m_7926_(definition);
        definition.m_61104_(new Property[]{STRUCTURE});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42409_) {
            this.onCaughtFire(state, level, pos, result.m_82434_(), (LivingEntity)player);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            if (!player.m_7500_()) {
                stack.m_41622_(1, (LivingEntity)player, event -> event.m_21190_(hand));
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (stack.m_41720_() == ItemRegistry.CONFIGURATION_WAND.get()) {
            this.cycleThroughStructures(level, state, pos);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.FAIL;
    }

    public void cycleThroughStructures(Level level, BlockState state, BlockPos pos) {
        StructureStates structure = (StructureStates)((Object)state.m_61143_(STRUCTURE));
        if (structure == StructureStates.PILLAGER_OUTPOST) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.MANSION)), 3);
        } else if (structure == StructureStates.MANSION) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.JUNGLE_PYRAMID)), 3);
        } else if (structure == StructureStates.JUNGLE_PYRAMID) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.DESERT_PYRAMID)), 3);
        } else if (structure == StructureStates.DESERT_PYRAMID) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.STRONGHOLD)), 3);
        } else if (structure == StructureStates.STRONGHOLD) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.MONUMENT)), 3);
        } else if (structure == StructureStates.MONUMENT) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.FORTRESS)), 3);
        } else if (structure == StructureStates.FORTRESS) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.END_CITY)), 3);
        } else if (structure == StructureStates.END_CITY) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.BASTION)), 3);
        } else if (structure == StructureStates.BASTION) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.VILLAGE_PLAINS)), 3);
        } else if (structure == StructureStates.VILLAGE_PLAINS) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.VILLAGE_DESERT)), 3);
        } else if (structure == StructureStates.VILLAGE_DESERT) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.VILLAGE_SAVANNA)), 3);
        } else if (structure == StructureStates.VILLAGE_SAVANNA) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.VILLAGE_SNOWY)), 3);
        } else if (structure == StructureStates.VILLAGE_SNOWY) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.VILLAGE_TAIGA)), 3);
        } else if (structure == StructureStates.VILLAGE_TAIGA) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STRUCTURE, (Comparable)((Object)StructureStates.PILLAGER_OUTPOST)), 3);
        }
    }

    @Nullable
    public PrimedLTNT explode(Level level, boolean exploded, double x, double y, double z, @Nullable LivingEntity igniter) throws NullPointerException {
        if (this.TNT != null) {
            PrimedLTNT tnt = (PrimedLTNT)((EntityType)this.TNT.get()).m_20615_(level);
            tnt.m_32085_(exploded && this.randomizedFuseUponExploded() ? tnt.getEffect().getDefaultFuse((IExplosiveEntity)tnt) / 8 + this.random.nextInt(Mth.m_14045_((int)(tnt.getEffect().getDefaultFuse((IExplosiveEntity)tnt) / 4), (int)1, (int)Integer.MAX_VALUE)) : tnt.getEffect().getDefaultFuse((IExplosiveEntity)tnt));
            tnt.m_6034_(x + 0.5, y, z + 0.5);
            tnt.setOwner(igniter);
            if (level.m_8055_(new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z))).m_61138_(STRUCTURE)) {
                tnt.getPersistentData().m_128359_("structure", ((StructureStates)((Object)level.m_8055_(new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z))).m_61143_(STRUCTURE))).m_7912_());
            }
            level.m_7967_((Entity)tnt);
            level.m_5594_(null, new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z)), SoundEvents.f_12512_, SoundSource.MASTER, 1.0f, 1.0f);
            if (level.m_8055_(new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z))).m_60734_() == this) {
                level.m_7731_(new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z)), Blocks.f_50016_.m_49966_(), 3);
            }
            return tnt;
        }
        throw new NullPointerException("No TNT entity present. Make sure it is registered before the block is registered");
    }
}

