/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.block;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import luckytnt.registry.BlockRegistry;
import luckytntlib.block.LTNTBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;

public class PresentBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty TYPE = IntegerProperty.m_61631_((String)"type", (int)0, (int)4);

    public PresentBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> definition) {
        super.m_7926_(definition);
        definition.m_61104_(new Property[]{FACING});
        definition.m_61104_(new Property[]{TYPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return Collections.singletonList(ItemStack.f_41583_);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluidState) {
        if (!player.m_7500_() && super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluidState)) {
            int i;
            Random random = new Random();
            Item item = Items.f_42413_;
            int itemCount = random.nextInt(6, 24);
            int xpCount = 0;
            int rand = new Random().nextInt(128);
            if (rand > 70 && rand <= 100) {
                item = Items.f_42452_;
                itemCount = random.nextInt(8, 16);
                xpCount = random.nextInt(itemCount / 4, itemCount / 2 + 1);
            } else if (rand > 100 && rand <= 110) {
                item = ((LTNTBlock)BlockRegistry.SNOW_TNT.get()).m_5456_();
                itemCount = 1;
                xpCount = random.nextInt(8, 12);
            } else if (rand > 110 && rand <= 119) {
                item = Items.f_42415_;
                itemCount = random.nextInt(1, 4);
                xpCount = random.nextInt(8 * itemCount, 12 * itemCount);
            } else if (rand > 119 && rand <= 123) {
                item = ((LTNTBlock)BlockRegistry.CHRISTMAS_TNT.get()).m_5456_();
                itemCount = 1;
                xpCount = random.nextInt(32, 48);
            } else if (rand > 123 && rand <= 125) {
                item = ((LTNTBlock)BlockRegistry.SNOWSTORM_TNT.get()).m_5456_();
                itemCount = 1;
                xpCount = random.nextInt(48, 64);
            } else if (rand > 125 && rand <= 127) {
                item = Items.f_42747_;
                itemCount = 1;
                xpCount = random.nextInt(64, 96);
            }
            ItemEntity itemEntity = new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f), new ItemStack((ItemLike)item, itemCount));
            level.m_7967_((Entity)itemEntity);
            rand = random.nextInt(1, 6);
            for (i = 0; i < rand; ++i) {
                ExperienceOrb xp = new ExperienceOrb(level, (double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f), xpCount / rand);
                level.m_7967_((Entity)xp);
            }
            for (i = 0; i < 15; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)((float)pos.m_123341_() + 0.5f) + Math.random() * 2.0 - 1.0, (double)((float)pos.m_123342_() + 0.5f) + Math.random() * 2.0 - 1.0, (double)((float)pos.m_123343_() + 0.5f) + Math.random() * 2.0 - 1.0, 0.0, 0.0, 0.0);
            }
            return true;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluidState);
    }
}

