/*
 * Decompiled with CFR 0.152.
 */
package luckytntlib.util.tnteffects;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import luckytntlib.block.LTNTBlock;
import luckytntlib.item.LDynamiteItem;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.RegistryObject;

public class TNTXStrengthEffect
extends PrimedTNTEffect {
    @Nullable
    private final Supplier<RegistryObject<LTNTBlock>> TNT;
    @Nullable
    private final Supplier<RegistryObject<LDynamiteItem>> dynamite;
    private final int fuse;
    private final int strength;
    private final float xzStrength;
    private final float yStrength;
    private final float resistanceImpact;
    private final float randomVecLength;
    private final boolean fire;
    private final float knockbackStrength;
    private final boolean isStrongExplosion;
    private final float size;
    private final boolean airFuse;
    private final boolean explodesOnImpact;

    private TNTXStrengthEffect(@Nullable Supplier<RegistryObject<LTNTBlock>> TNT, @Nullable Supplier<RegistryObject<LDynamiteItem>> dynamite, int fuse, int strength, float xzStrength, float yStrength, float resistanceImpact, float randomVecLength, boolean fire, float knockbackStrength, boolean isStrongExplosion, float size, boolean airFuse, boolean explodesOnImpact) {
        this.TNT = TNT;
        this.dynamite = dynamite;
        this.fuse = fuse;
        this.strength = strength;
        this.xzStrength = xzStrength;
        this.yStrength = yStrength;
        this.resistanceImpact = resistanceImpact;
        this.randomVecLength = randomVecLength;
        this.fire = fire;
        this.knockbackStrength = knockbackStrength;
        this.isStrongExplosion = isStrongExplosion;
        this.size = size;
        this.airFuse = airFuse;
        this.explodesOnImpact = explodesOnImpact;
    }

    @Override
    public void serverExplosion(IExplosiveEntity entity) {
        ImprovedExplosion explosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos().f_82479_, entity.getPos().f_82480_ + 0.5, entity.getPos().f_82481_, this.strength);
        explosion.doEntityExplosion(this.knockbackStrength, true);
        explosion.doBlockExplosion(this.xzStrength, this.yStrength, this.resistanceImpact, this.randomVecLength, this.fire, this.isStrongExplosion);
    }

    @Override
    public Block getBlock() {
        return this.TNT.get().get() == null ? Blocks.f_50077_ : (Block)this.TNT.get().get();
    }

    @Override
    public Item getItem() {
        return this.dynamite.get().get() == null ? Items.f_41852_ : (Item)this.dynamite.get().get();
    }

    @Override
    public int getDefaultFuse(IExplosiveEntity entity) {
        return this.fuse;
    }

    @Override
    public float getSize(IExplosiveEntity entity) {
        return this.size;
    }

    @Override
    public boolean airFuse() {
        return this.airFuse;
    }

    @Override
    public boolean explodesOnImpact() {
        return this.explodesOnImpact;
    }

    public static class Builder {
        private int fuse = 80;
        private int strength = 4;
        private float xzStrength = 1.0f;
        private float yStrength = 1.0f;
        private float resistanceImpact = 1.0f;
        private float randomVecLength = 1.0f;
        private boolean fire = false;
        private float knockbackStrength = 1.0f;
        private boolean isStrongExplosion = false;
        private float size = 1.0f;
        private boolean airFuse = false;
        private boolean explodesOnImpact = true;

        public Builder() {
        }

        private Builder(int fuse, int strength, float xzStrength, float yStrength, float resistanceImpact, float randomVecLength, boolean fire, float knockbackStrength, boolean isStrongExplosion, float size, boolean airFuse, boolean explodesOnImpact) {
            this.fuse = fuse;
            this.strength = strength;
            this.xzStrength = xzStrength;
            this.yStrength = yStrength;
            this.resistanceImpact = resistanceImpact;
            this.randomVecLength = randomVecLength;
            this.fire = fire;
            this.knockbackStrength = knockbackStrength;
            this.isStrongExplosion = isStrongExplosion;
            this.size = size;
            this.airFuse = airFuse;
            this.explodesOnImpact = explodesOnImpact;
        }

        public Builder fuse(int fuse) {
            return new Builder(fuse, this.strength, this.xzStrength, this.yStrength, this.resistanceImpact, this.randomVecLength, this.fire, this.knockbackStrength, this.isStrongExplosion, this.size, this.airFuse, this.explodesOnImpact);
        }

        public Builder strength(int strength) {
            return new Builder(this.fuse, strength, this.xzStrength, this.yStrength, this.resistanceImpact, this.randomVecLength, this.fire, this.knockbackStrength, this.isStrongExplosion, this.size, this.airFuse, this.explodesOnImpact);
        }

        public Builder xzStrength(float xzStrength) {
            return new Builder(this.fuse, this.strength, xzStrength, this.yStrength, this.resistanceImpact, this.randomVecLength, this.fire, this.knockbackStrength, this.isStrongExplosion, this.size, this.airFuse, this.explodesOnImpact);
        }

        public Builder yStrength(float yStrength) {
            return new Builder(this.fuse, this.strength, this.xzStrength, yStrength, this.resistanceImpact, this.randomVecLength, this.fire, this.knockbackStrength, this.isStrongExplosion, this.size, this.airFuse, this.explodesOnImpact);
        }

        public Builder resistanceImpact(float resistanceImpact) {
            return new Builder(this.fuse, this.strength, this.xzStrength, this.yStrength, resistanceImpact, this.randomVecLength, this.fire, this.knockbackStrength, this.isStrongExplosion, this.size, this.airFuse, this.explodesOnImpact);
        }

        public Builder randomVecLength(float randomVecLength) {
            return new Builder(this.fuse, this.strength, this.xzStrength, this.yStrength, this.resistanceImpact, randomVecLength, this.fire, this.knockbackStrength, this.isStrongExplosion, this.size, this.airFuse, this.explodesOnImpact);
        }

        public Builder fire(boolean fire) {
            return new Builder(this.fuse, this.strength, this.xzStrength, this.yStrength, this.resistanceImpact, this.randomVecLength, fire, this.knockbackStrength, this.isStrongExplosion, this.size, this.airFuse, this.explodesOnImpact);
        }

        public Builder knockbackStrength(float knockbackStrength) {
            return new Builder(this.fuse, this.strength, this.xzStrength, this.yStrength, this.resistanceImpact, this.randomVecLength, this.fire, knockbackStrength, this.isStrongExplosion, this.size, this.airFuse, this.explodesOnImpact);
        }

        public Builder isStrongExplosion(boolean isStrongExplosion) {
            return new Builder(this.fuse, this.strength, this.xzStrength, this.yStrength, this.resistanceImpact, this.randomVecLength, this.fire, this.knockbackStrength, isStrongExplosion, this.size, this.airFuse, this.explodesOnImpact);
        }

        public Builder size(float size) {
            return new Builder(this.fuse, this.strength, this.xzStrength, this.yStrength, this.resistanceImpact, this.randomVecLength, this.fire, this.knockbackStrength, this.isStrongExplosion, size, this.airFuse, this.explodesOnImpact);
        }

        public Builder airFuse(boolean airFuse) {
            return new Builder(this.fuse, this.strength, this.xzStrength, this.yStrength, this.resistanceImpact, this.randomVecLength, this.fire, this.knockbackStrength, this.isStrongExplosion, this.size, airFuse, this.explodesOnImpact);
        }

        public Builder explodesOnImpact(boolean explodesOnImpact) {
            return new Builder(this.fuse, this.strength, this.xzStrength, this.yStrength, this.resistanceImpact, this.randomVecLength, this.fire, this.knockbackStrength, this.isStrongExplosion, this.size, this.airFuse, explodesOnImpact);
        }

        public TNTXStrengthEffect build() {
            return new TNTXStrengthEffect(null, null, this.fuse, this.strength, this.xzStrength, this.yStrength, this.resistanceImpact, this.randomVecLength, this.fire, this.knockbackStrength, this.isStrongExplosion, this.size, this.airFuse, this.explodesOnImpact);
        }

        public TNTXStrengthEffect buildTNT(Supplier<RegistryObject<LTNTBlock>> TNT) {
            return new TNTXStrengthEffect(TNT, null, this.fuse, this.strength, this.xzStrength, this.yStrength, this.resistanceImpact, this.randomVecLength, this.fire, this.knockbackStrength, this.isStrongExplosion, this.size, this.airFuse, this.explodesOnImpact);
        }

        public TNTXStrengthEffect buildDynamite(Supplier<RegistryObject<LDynamiteItem>> dynamite) {
            return new TNTXStrengthEffect(null, dynamite, this.fuse, this.strength, this.xzStrength, this.yStrength, this.resistanceImpact, this.randomVecLength, this.fire, this.knockbackStrength, this.isStrongExplosion, this.size, this.airFuse, this.explodesOnImpact);
        }
    }
}

