/*
 * Decompiled with CFR 0.152.
 */
package luckytntlib.util.tnteffects;

import luckytntlib.entity.LExplosiveProjectile;
import luckytntlib.entity.LTNTMinecart;
import luckytntlib.entity.LivingPrimedLTNT;
import luckytntlib.entity.PrimedLTNT;
import luckytntlib.util.IExplosiveEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class PrimedTNTEffect {
    public void baseTick(IExplosiveEntity entity) {
        Level level = entity.getLevel();
        if (entity instanceof PrimedLTNT || entity instanceof LivingPrimedLTNT || entity instanceof LTNTMinecart) {
            if (entity.getTNTFuse() <= 0) {
                if (entity.getLevel() instanceof ServerLevel) {
                    if (this.playsSound()) {
                        level.m_245803_((Entity)entity, new BlockPos((Vec3i)this.toBlockPos(entity.getPos())), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
                    }
                    this.serverExplosion(entity);
                }
                entity.destroy();
            }
            this.explosionTick(entity);
            entity.setTNTFuse(entity.getTNTFuse() - 1);
        } else if (entity instanceof LExplosiveProjectile) {
            LExplosiveProjectile ent = (LExplosiveProjectile)entity;
            if ((ent.inGround() || ent.hitEntity()) && entity.getLevel() instanceof ServerLevel) {
                if (this.explodesOnImpact()) {
                    ent.setTNTFuse(0);
                }
                if (ent.getTNTFuse() == 0) {
                    if (ent.m_9236_() instanceof ServerLevel) {
                        if (this.playsSound()) {
                            level.m_245803_((Entity)entity, new BlockPos((Vec3i)this.toBlockPos(entity.getPos())), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
                        }
                        this.serverExplosion(entity);
                    }
                    ent.destroy();
                }
            } else if (this.airFuse() && entity.getTNTFuse() == 0) {
                if (ent.m_9236_() instanceof ServerLevel) {
                    if (this.playsSound()) {
                        level.m_245803_((Entity)entity, new BlockPos((Vec3i)this.toBlockPos(entity.getPos())), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
                    }
                    this.serverExplosion(entity);
                }
                ent.destroy();
            }
            if (ent.getTNTFuse() > 0 && this.airFuse() || ent.hitEntity() || ent.inGround()) {
                this.explosionTick(ent);
                ent.setTNTFuse(ent.getTNTFuse() - 1);
            }
        }
        if (level.f_46443_) {
            this.spawnParticles(entity);
        }
    }

    public void spawnParticles(IExplosiveEntity entity) {
        entity.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123762_, entity.x(), entity.y() + 0.5, entity.z(), 0.0, 0.0, 0.0);
    }

    public void serverExplosion(IExplosiveEntity entity) {
    }

    public void explosionTick(IExplosiveEntity entity) {
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 80;
    }

    public float getSize(IExplosiveEntity entity) {
        return 1.0f;
    }

    public boolean playsSound() {
        return true;
    }

    public boolean explodesOnImpact() {
        return true;
    }

    public boolean airFuse() {
        return false;
    }

    public ItemStack getItemStack() {
        return new ItemStack((ItemLike)this.getItem());
    }

    public Item getItem() {
        return Items.f_41852_;
    }

    public BlockState getBlockState(IExplosiveEntity entity) {
        return this.getBlock().m_49966_();
    }

    public Block getBlock() {
        return Blocks.f_50077_;
    }

    public BlockPos toBlockPos(Vec3 vec) {
        return new BlockPos(Mth.m_14107_((double)vec.f_82479_), Mth.m_14107_((double)vec.f_82480_), Mth.m_14107_((double)vec.f_82481_));
    }
}

