/*
 * Decompiled with CFR 0.152.
 */
package luckytntlib.util.explosions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import luckytntlib.config.LuckyTNTLibConfigValues;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.IBlockExplosionCondition;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.IForEachEntityExplosionEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class ImprovedExplosion
extends Explosion {
    public final Level f_46012_;
    public final double posX;
    public final double posY;
    public final double posZ;
    public final int size;
    public final ExplosionDamageCalculator f_46019_;
    List<Integer> affectedBlocks = new ArrayList<Integer>();
    private static ImprovedExplosion dummyExplosion;

    public ImprovedExplosion(Level level, Vec3 position, int size) {
        this(level, null, null, position, size);
    }

    public ImprovedExplosion(Level level, @Nullable DamageSource source, Vec3 position, int size) {
        this(level, null, source, position, size);
    }

    public ImprovedExplosion(Level level, @Nullable Entity explodingEntity, Vec3 position, int size) {
        this(level, explodingEntity, null, position.f_82479_, position.f_82480_, position.f_82481_, size);
    }

    public ImprovedExplosion(Level level, @Nullable Entity explodingEntity, @Nullable DamageSource source, Vec3 position, int size) {
        this(level, explodingEntity, source, position.f_82479_, position.f_82480_, position.f_82481_, size);
    }

    public ImprovedExplosion(Level level, @Nullable Entity explodingEntity, double x, double y, double z, int size) {
        this(level, explodingEntity, null, x, y, z, size);
    }

    public ImprovedExplosion(Level level, @Nullable Entity explodingEntity, @Nullable DamageSource source, double x, double y, double z, int size) {
        super(level, explodingEntity, source, null, x, y, z, (float)size, false, Explosion.BlockInteraction.KEEP);
        this.f_46012_ = level;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.size = size;
        this.f_46019_ = explodingEntity == null ? new ExplosionDamageCalculator() : new EntityBasedExplosionDamageCalculator(explodingEntity);
    }

    public void doBlockExplosion(float xzStrength, float yStrength, float resistanceImpact, float randomVecLength, boolean fire, boolean isStrongExplosion) {
        int intPos;
        BlockPos posTNT = new BlockPos(Mth.m_14107_((double)this.posX), Mth.m_14107_((double)this.posY), Mth.m_14107_((double)this.posZ));
        HashSet<Integer> blocks = new HashSet<Integer>();
        for (int offX = -this.size; offX <= this.size; ++offX) {
            for (int offY = -this.size; offY <= this.size; ++offY) {
                for (int offZ = -this.size; offZ <= this.size; ++offZ) {
                    BlockPos pos;
                    double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
                    if (((int)distance != this.size || !((Boolean)LuckyTNTLibConfigValues.PERFORMANT_EXPLOSION.get()).booleanValue()) && (((Boolean)LuckyTNTLibConfigValues.PERFORMANT_EXPLOSION.get()).booleanValue() || offX != -this.size && offX != this.size && offY != -this.size && offY != this.size && offZ != -this.size && offZ != this.size)) continue;
                    double xStep = (double)offX / distance;
                    double yStep = (double)offY / distance;
                    double zStep = (double)offZ / distance;
                    float vecLength = (float)this.size * (0.7f + (float)Math.random() * 0.6f * randomVecLength);
                    double blockX = this.posX;
                    double blockY = this.posY;
                    double blockZ = this.posZ;
                    float vecStep = 0.0f;
                    while (vecStep < vecLength && this.f_46012_.m_46739_(pos = new BlockPos((int)(blockX += xStep * (Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * (double)xzStrength), (int)(blockY += yStep * (Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * (double)yStrength), (int)(blockZ += zStep * (Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * (double)xzStrength)))) {
                        BlockState blockState = this.f_46012_.m_8055_(pos);
                        FluidState fluidState = this.f_46012_.m_6425_(pos);
                        if (!isStrongExplosion || fluidState.m_76178_()) {
                            Optional explosionResistance = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, pos, blockState, fluidState);
                            if (explosionResistance.isPresent()) {
                                vecLength -= (((Float)explosionResistance.get()).floatValue() + 0.3f) * 0.3f * resistanceImpact;
                            }
                            if (vecLength > 0.0f && this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, pos, blockState, vecLength) && !blockState.m_60795_()) {
                                blocks.add(this.encodeBlockPos(pos.m_121996_((Vec3i)posTNT).m_123341_(), pos.m_121996_((Vec3i)posTNT).m_123342_(), pos.m_121996_((Vec3i)posTNT).m_123343_()));
                            }
                        } else {
                            blocks.add(this.encodeBlockPos(pos.m_121996_((Vec3i)posTNT).m_123341_(), pos.m_121996_((Vec3i)posTNT).m_123342_(), pos.m_121996_((Vec3i)posTNT).m_123343_()));
                        }
                        vecStep = (float)((double)vecStep + ((Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * 1.5 - (double)0.225f));
                    }
                }
            }
        }
        this.affectedBlocks.addAll(blocks);
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            intPos = (Integer)iterator.next();
            BlockPos pos = this.decodeBlockPos(intPos).m_121955_((Vec3i)posTNT);
            this.f_46012_.m_8055_(pos).m_60734_().onBlockExploded(this.f_46012_.m_8055_(pos), this.f_46012_, pos, (Explosion)this);
        }
        if (fire) {
            iterator = blocks.iterator();
            while (iterator.hasNext()) {
                intPos = (Integer)iterator.next();
                BlockPos pos = this.decodeBlockPos(intPos).m_121955_((Vec3i)posTNT);
                if (!(Math.random() > 0.75) || !this.f_46012_.m_8055_(pos).m_60795_() || !this.f_46012_.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)this.f_46012_, pos)) continue;
                this.f_46012_.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)this.f_46012_, (BlockPos)pos));
            }
        }
    }

    public void doBlockExplosion(float xzStrength, float yStrength, float resistanceImpact, float randomVecLength, boolean isStrongExplosion, IForEachBlockExplosionEffect blockEffect) {
        double distance;
        BlockPos posTNT = new BlockPos(Mth.m_14107_((double)this.posX), Mth.m_14107_((double)this.posY), Mth.m_14107_((double)this.posZ));
        HashSet<Integer> blocks = new HashSet<Integer>();
        for (int offX = -this.size; offX <= this.size; ++offX) {
            for (int offY = -this.size; offY <= this.size; ++offY) {
                for (int offZ = -this.size; offZ <= this.size; ++offZ) {
                    BlockPos pos;
                    distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
                    if (((int)distance != this.size || !((Boolean)LuckyTNTLibConfigValues.PERFORMANT_EXPLOSION.get()).booleanValue()) && (((Boolean)LuckyTNTLibConfigValues.PERFORMANT_EXPLOSION.get()).booleanValue() || offX != -this.size && offX != this.size && offY != -this.size && offY != this.size && offZ != -this.size && offZ != this.size)) continue;
                    double xStep = (double)offX / distance;
                    double yStep = (double)offY / distance;
                    double zStep = (double)offZ / distance;
                    float vecLength = (float)this.size * (0.7f + (float)Math.random() * 0.6f * randomVecLength);
                    double blockX = this.posX;
                    double blockY = this.posY;
                    double blockZ = this.posZ;
                    float vecStep = 0.0f;
                    while (vecStep < vecLength && this.f_46012_.m_46739_(pos = new BlockPos((int)(blockX += xStep * (Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * (double)xzStrength), (int)(blockY += yStep * (Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * (double)yStrength), (int)(blockZ += zStep * (Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * (double)xzStrength)))) {
                        BlockState blockState = this.f_46012_.m_8055_(pos);
                        FluidState fluidState = this.f_46012_.m_6425_(pos);
                        if (!isStrongExplosion || fluidState.m_76178_()) {
                            Optional explosionResistance = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, pos, blockState, fluidState);
                            if (explosionResistance.isPresent()) {
                                vecLength -= (((Float)explosionResistance.get()).floatValue() + 0.3f) * 0.3f * resistanceImpact;
                            }
                            if (vecLength > 0.0f && this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, pos, blockState, vecLength) && !blockState.m_60795_()) {
                                blocks.add(this.encodeBlockPos(pos.m_121996_((Vec3i)posTNT).m_123341_(), pos.m_121996_((Vec3i)posTNT).m_123342_(), pos.m_121996_((Vec3i)posTNT).m_123343_()));
                            }
                        } else {
                            blocks.add(this.encodeBlockPos(pos.m_121996_((Vec3i)posTNT).m_123341_(), pos.m_121996_((Vec3i)posTNT).m_123342_(), pos.m_121996_((Vec3i)posTNT).m_123343_()));
                        }
                        vecStep = (float)((double)vecStep + ((Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * 1.5 - (double)0.225f));
                    }
                }
            }
        }
        this.affectedBlocks.addAll(blocks);
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            int intPos = (Integer)iterator.next();
            BlockPos pos = this.decodeBlockPos(intPos).m_121955_((Vec3i)posTNT);
            distance = Math.sqrt(pos.m_203202_(this.posX, this.posY, this.posZ));
            blockEffect.doBlockExplosion(this.f_46012_, pos, this.f_46012_.m_8055_(pos), distance);
        }
    }

    public void doBlockExplosion(float xzStrength, float yStrength, float resistanceImpact, float randomVecLength, boolean isStrongExplosion, IBlockExplosionCondition condition, IForEachBlockExplosionEffect blockEffect) {
        double distance;
        BlockPos posTNT = new BlockPos(Mth.m_14107_((double)this.posX), Mth.m_14107_((double)this.posY), Mth.m_14107_((double)this.posZ));
        HashSet<Integer> blocks = new HashSet<Integer>();
        for (int offX = -this.size; offX <= this.size; ++offX) {
            for (int offY = -this.size; offY <= this.size; ++offY) {
                for (int offZ = -this.size; offZ <= this.size; ++offZ) {
                    BlockPos pos;
                    distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
                    if (((int)distance != this.size || !((Boolean)LuckyTNTLibConfigValues.PERFORMANT_EXPLOSION.get()).booleanValue()) && (((Boolean)LuckyTNTLibConfigValues.PERFORMANT_EXPLOSION.get()).booleanValue() || offX != -this.size && offX != this.size && offY != -this.size && offY != this.size && offZ != -this.size && offZ != this.size)) continue;
                    double xStep = (double)offX / distance;
                    double yStep = (double)offY / distance;
                    double zStep = (double)offZ / distance;
                    float vecLength = (float)this.size * (0.7f + (float)Math.random() * 0.6f * randomVecLength);
                    double blockX = this.posX;
                    double blockY = this.posY;
                    double blockZ = this.posZ;
                    float vecStep = 0.0f;
                    while (vecStep < vecLength && this.f_46012_.m_46739_(pos = new BlockPos((int)(blockX += xStep * (Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * (double)xzStrength), (int)(blockY += yStep * (Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * (double)yStrength), (int)(blockZ += zStep * (Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * (double)xzStrength)))) {
                        BlockState blockState = this.f_46012_.m_8055_(pos);
                        FluidState fluidState = this.f_46012_.m_6425_(pos);
                        if (!isStrongExplosion || fluidState.m_76178_()) {
                            Optional explosionResistance = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, pos, blockState, fluidState);
                            if (explosionResistance.isPresent()) {
                                vecLength -= (((Float)explosionResistance.get()).floatValue() + 0.3f) * 0.3f * resistanceImpact;
                            }
                            if (vecLength > 0.0f && this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, pos, blockState, vecLength) && !blockState.m_60795_() && condition.conditionMet(this.f_46012_, pos, blockState, distance)) {
                                blocks.add(this.encodeBlockPos(pos.m_121996_((Vec3i)posTNT).m_123341_(), pos.m_121996_((Vec3i)posTNT).m_123342_(), pos.m_121996_((Vec3i)posTNT).m_123343_()));
                            }
                        } else if (condition.conditionMet(this.f_46012_, pos, blockState, distance)) {
                            blocks.add(this.encodeBlockPos(pos.m_121996_((Vec3i)posTNT).m_123341_(), pos.m_121996_((Vec3i)posTNT).m_123342_(), pos.m_121996_((Vec3i)posTNT).m_123343_()));
                        }
                        vecStep = (float)((double)vecStep + ((Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * 1.5 - (double)0.225f));
                    }
                }
            }
        }
        this.affectedBlocks.addAll(blocks);
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            int intPos = (Integer)iterator.next();
            BlockPos pos = this.decodeBlockPos(intPos).m_121955_((Vec3i)posTNT);
            distance = Math.sqrt(pos.m_203202_(this.posX, this.posY, this.posZ));
            blockEffect.doBlockExplosion(this.f_46012_, pos, this.f_46012_.m_8055_(pos), distance);
        }
    }

    public void doBlockExplosion(IForEachBlockExplosionEffect blockEffect) {
        this.doBlockExplosion(1.0f, 1.0f, 1.0f, 1.0f, false, blockEffect);
    }

    public void doBlockExplosion(IBlockExplosionCondition condition, IForEachBlockExplosionEffect blockEffect) {
        this.doBlockExplosion(1.0f, 1.0f, 1.0f, 1.0f, false, condition, blockEffect);
    }

    public void doBlockExplosion() {
        this.doBlockExplosion(1.0f, 1.0f, 1.0f, 1.0f, false, false);
    }

    public void doOldBlockExplosion(float xzStrength, float yStrength, float resistanceImpact, float randomVecLength, boolean fire, boolean isStrongExplosion, boolean saveBlockPos) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (int offX = -this.size; offX <= this.size; ++offX) {
            for (int offY = -this.size; offY <= this.size; ++offY) {
                for (int offZ = -this.size; offZ <= this.size; ++offZ) {
                    BlockPos pos;
                    double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
                    if (((int)distance != this.size || !((Boolean)LuckyTNTLibConfigValues.PERFORMANT_EXPLOSION.get()).booleanValue()) && (((Boolean)LuckyTNTLibConfigValues.PERFORMANT_EXPLOSION.get()).booleanValue() || offX != -this.size && offX != this.size && offY != -this.size && offY != this.size && offZ != -this.size && offZ != this.size)) continue;
                    double xStep = (double)offX / distance;
                    double yStep = (double)offY / distance;
                    double zStep = (double)offZ / distance;
                    float vecLength = (float)this.size * (0.7f + (float)Math.random() * 0.6f * randomVecLength);
                    double blockX = this.posX;
                    double blockY = this.posY;
                    double blockZ = this.posZ;
                    float vecStep = 0.0f;
                    while (vecStep < vecLength && this.f_46012_.m_46739_(pos = new BlockPos((int)(blockX += xStep * (Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * (double)xzStrength), (int)(blockY += yStep * (Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * (double)yStrength), (int)(blockZ += zStep * (Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * (double)xzStrength)))) {
                        BlockState blockState = this.f_46012_.m_8055_(pos);
                        FluidState fluidState = this.f_46012_.m_6425_(pos);
                        if (!isStrongExplosion || fluidState.m_76178_()) {
                            Optional explosionResistance = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, pos, blockState, fluidState);
                            if (explosionResistance.isPresent()) {
                                vecLength -= (((Float)explosionResistance.get()).floatValue() + 0.3f) * 0.3f * resistanceImpact;
                            }
                            if (vecLength > 0.0f && this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, pos, blockState, vecLength) && !blockState.m_60795_()) {
                                blocks.add(pos);
                            }
                        } else {
                            blocks.add(pos);
                        }
                        vecStep = (float)((double)vecStep + ((Double)LuckyTNTLibConfigValues.EXPLOSION_PERFORMANCE_FACTOR.get() * 1.5 - (double)0.225f));
                    }
                }
            }
        }
        if (saveBlockPos) {
            BlockPos posTNT = new BlockPos(Mth.m_14107_((double)this.posX), Mth.m_14107_((double)this.posY), Mth.m_14107_((double)this.posZ));
            for (BlockPos pos : blocks) {
                this.affectedBlocks.add(this.encodeBlockPos(pos.m_121996_((Vec3i)posTNT).m_123341_(), pos.m_121996_((Vec3i)posTNT).m_123342_(), pos.m_121996_((Vec3i)posTNT).m_123343_()));
            }
        }
        for (BlockPos pos : blocks) {
            this.f_46012_.m_8055_(pos).m_60734_().onBlockExploded(this.f_46012_.m_8055_(pos), this.f_46012_, pos, (Explosion)this);
        }
        if (fire) {
            for (BlockPos pos : blocks) {
                if (!(Math.random() > 0.75) || !this.f_46012_.m_8055_(pos).m_60795_() || !this.f_46012_.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)this.f_46012_, pos)) continue;
                this.f_46012_.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)this.f_46012_, (BlockPos)pos));
            }
        }
    }

    protected int encodeBlockPos(int x, int y, int z) {
        int x0 = Integer.signum(x);
        x = Math.abs(x) > 511 ? 511 : Math.abs(x);
        x0 = x0 == -1 ? 512 : 0;
        x += x0;
        x <<= 20;
        int y0 = Integer.signum(y);
        y = Math.abs(y) > 511 ? 511 : Math.abs(y);
        y0 = y0 == -1 ? 512 : 0;
        y += y0;
        int z0 = Integer.signum(z);
        z = Math.abs(z) > 511 ? 511 : Math.abs(z);
        z0 = z0 == -1 ? 512 : 0;
        return x + (y <<= 10) + (z += z0);
    }

    protected BlockPos decodeBlockPos(int encodedVal) {
        int zRaw = encodedVal & 0x1FF;
        int zNeg = (encodedVal & 0x200) >> 9;
        int yRaw = (encodedVal & 0x7FC00) >> 10;
        int yNeg = (encodedVal & 0x80000) >> 19;
        int xRaw = (encodedVal & 0x1FF00000) >> 20;
        int xNeg = (encodedVal & 0x20000000) >> 29;
        int xVal = xNeg == 1 ? -xRaw : xRaw;
        int yVal = yNeg == 1 ? -yRaw : yRaw;
        int zVal = zNeg == 1 ? -zRaw : zRaw;
        return new BlockPos(xVal, yVal, zVal);
    }

    public void doEntityExplosion(float knockbackStrength, boolean damageEntities) {
        List entities = this.f_46012_.m_45933_(this.getExploder(), new AABB(this.posX - (double)(this.size * 2), this.posY - (double)(this.size * 2), this.posZ - (double)(this.size * 2), this.posX + (double)(this.size * 2), this.posY + (double)(this.size * 2), this.posZ + (double)(this.size * 2)));
        ForgeEventFactory.onExplosionDetonate((Level)this.f_46012_, (Explosion)this, (List)entities, (double)(this.size * 2));
        for (Entity entity : entities) {
            double distance;
            if (entity.m_6128_() || !((distance = Math.sqrt(entity.m_20238_(this.getPosition())) / (double)(this.size * 2)) <= 1.0)) continue;
            double offX = entity.m_20185_() - this.posX;
            double offY = entity.m_20188_() - this.posY;
            double offZ = entity.m_20189_() - this.posZ;
            double distance2 = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
            offX /= distance2;
            offY /= distance2;
            offZ /= distance2;
            double seenPercent = ImprovedExplosion.m_46064_((Vec3)this.getPosition(), (Entity)entity);
            float damage = (1.0f - (float)distance) * (float)seenPercent;
            if (damageEntities) {
                entity.m_6469_(this.m_46077_(), (damage * damage + damage) / 2.0f * 7.0f * (float)this.size + 1.0f);
            }
            double knockback = damage;
            if (entity instanceof LivingEntity) {
                LivingEntity lEnt = (LivingEntity)entity;
                knockback = ProtectionEnchantment.m_45135_((LivingEntity)lEnt, (double)damage);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(offX * knockback * (double)knockbackStrength, offY * knockback * (double)knockbackStrength, offZ * knockback * (double)knockbackStrength));
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            player.f_19864_ = true;
            if (player.m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            this.m_46078_().put(player, new Vec3(offX * (double)damage, offY * (double)damage, offZ * (double)damage));
        }
    }

    public void doEntityExplosion(IForEachEntityExplosionEffect entityEffect) {
        List entities = this.f_46012_.m_45933_(this.getExploder(), new AABB(this.posX - (double)(this.size * 2), this.posY - (double)(this.size * 2), this.posZ - (double)(this.size * 2), this.posX + (double)(this.size * 2), this.posY + (double)(this.size * 2), this.posZ + (double)(this.size * 2)));
        ForgeEventFactory.onExplosionDetonate((Level)this.f_46012_, (Explosion)this, (List)entities, (double)(this.size * 2));
        for (Entity entity : entities) {
            double distance;
            if (entity.m_6128_() || !((distance = Math.sqrt(entity.m_20238_(this.getPosition())) / (double)(this.size * 2)) < 1.0) || distance == 0.0) continue;
            entityEffect.doEntityExplosion(entity, distance);
        }
    }

    @Nullable
    public LivingEntity m_252906_() {
        Entity entity = this.getExploder();
        if (entity instanceof IExplosiveEntity) {
            IExplosiveEntity ent = (IExplosiveEntity)entity;
            return ent.owner();
        }
        return super.m_252906_();
    }

    public static ImprovedExplosion dummyExplosion(Level level) {
        return dummyExplosion == null ? (dummyExplosion = new ImprovedExplosion(level, new Vec3(0.0, 0.0, 0.0), 0)) : dummyExplosion;
    }

    @Deprecated
    public void m_46061_() {
    }

    @Deprecated
    public void m_46075_(boolean spawnParticles) {
    }

    @Nullable
    public List<BlockPos> m_46081_() {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (int intPos : this.affectedBlocks) {
            blocks.add(this.decodeBlockPos(intPos).m_7918_(Mth.m_14107_((double)this.posX), Mth.m_14107_((double)this.posY), Mth.m_14107_((double)this.posZ)));
        }
        return blocks;
    }
}

