/*
 * Decompiled with CFR 0.152.
 */
package luckytntlib.util.explosions;

import java.util.HashMap;
import luckytntlib.util.explosions.IBlockExplosionCondition;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ExplosionHelper {
    public static HashMap<BlockPos, BlockState> getBlocksInSphere(Level level, Vec3 position, int radius) {
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        for (int offX = -radius; offX <= radius; ++offX) {
            for (int offY = radius; offY >= -radius; --offY) {
                for (int offZ = -radius; offZ <= radius; ++offZ) {
                    double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
                    if (!(distance <= (double)radius)) continue;
                    BlockPos pos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_).m_7918_(offX, offY, offZ);
                    BlockState state = level.m_8055_(pos);
                    blocks.put(pos, state);
                }
            }
        }
        return blocks;
    }

    public static HashMap<BlockPos, BlockState> getBlocksInCuboid(Level level, Vec3 position, Vec3 radii) {
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        for (int offX = (int)(-radii.f_82479_); offX <= (int)radii.f_82479_; ++offX) {
            for (int offY = (int)radii.f_82480_; offY >= (int)(-radii.f_82480_); --offY) {
                for (int offZ = (int)(-radii.f_82481_); offZ <= (int)radii.f_82481_; ++offZ) {
                    BlockPos pos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_).m_7918_(offX, offY, offZ);
                    BlockState state = level.m_8055_(pos);
                    blocks.put(pos, state);
                }
            }
        }
        return blocks;
    }

    public static HashMap<BlockPos, BlockState> getBlocksInCylinder(Level level, Vec3 position, int radius, int radiusY) {
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        for (int offX = -radius; offX <= radius; ++offX) {
            for (int offY = radiusY; offY >= -radiusY; --offY) {
                for (int offZ = -radius; offZ <= radius; ++offZ) {
                    double distance = Math.sqrt(offX * offX + offZ * offZ);
                    if (!(distance <= (double)radius)) continue;
                    BlockPos pos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_).m_7918_(offX, offY, offZ);
                    BlockState state = level.m_8055_(pos);
                    blocks.put(pos, state);
                }
            }
        }
        return blocks;
    }

    public static void doSphericalExplosion(Level level, Vec3 position, int radius, IForEachBlockExplosionEffect blockEffect) {
        for (int offX = -radius; offX <= radius; ++offX) {
            for (int offY = radius; offY >= -radius; --offY) {
                for (int offZ = -radius; offZ <= radius; ++offZ) {
                    double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
                    if (!(distance <= (double)radius)) continue;
                    BlockPos pos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_).m_7918_(offX, offY, offZ);
                    BlockState state = level.m_8055_(pos);
                    blockEffect.doBlockExplosion(level, pos, state, distance);
                }
            }
        }
    }

    public static void doModifiedSphericalExplosion(Level level, Vec3 position, int radius, Vec3 scaling, IForEachBlockExplosionEffect blockEffect) {
        for (double offX = (double)(-radius) * scaling.f_82479_; offX <= (double)radius * scaling.f_82479_; offX += 1.0) {
            for (double offY = (double)radius * scaling.f_82480_; offY >= (double)(-radius) * scaling.f_82480_; offY -= 1.0) {
                for (double offZ = (double)(-radius) * scaling.f_82481_; offZ <= (double)radius * scaling.f_82481_; offZ += 1.0) {
                    double distance = Math.sqrt(offX * offX / scaling.f_82479_ + offY * offY / scaling.f_82480_ + offZ * offZ / scaling.f_82481_);
                    if (!(distance <= (double)radius)) continue;
                    BlockPos pos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_).m_7918_((int)offX, (int)offY, (int)offZ);
                    BlockState state = level.m_8055_(pos);
                    blockEffect.doBlockExplosion(level, pos, state, distance);
                }
            }
        }
    }

    public static void doCubicalExplosion(Level level, Vec3 position, int radius, IForEachBlockExplosionEffect blockEffect) {
        for (int offX = -radius; offX <= radius; ++offX) {
            for (int offY = -radius; offY <= radius; ++offY) {
                for (int offZ = -radius; offZ <= radius; ++offZ) {
                    double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
                    BlockPos pos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_).m_7918_(offX, offY, offZ);
                    BlockState state = level.m_8055_(pos);
                    blockEffect.doBlockExplosion(level, pos, state, distance);
                }
            }
        }
    }

    public static void doCuboidExplosion(Level level, Vec3 position, Vec3 radii, IForEachBlockExplosionEffect blockEffect) {
        for (int offX = (int)(-radii.f_82479_); offX <= (int)radii.f_82479_; ++offX) {
            for (int offY = (int)(-radii.f_82480_); offY <= (int)radii.f_82480_; ++offY) {
                for (int offZ = (int)(-radii.f_82481_); offZ <= (int)radii.f_82481_; ++offZ) {
                    double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
                    BlockPos pos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_).m_7918_(offX, offY, offZ);
                    BlockState state = level.m_8055_(pos);
                    blockEffect.doBlockExplosion(level, pos, state, distance);
                }
            }
        }
    }

    public static void doCylindricalExplosion(Level level, Vec3 position, int radius, int radiusY, IForEachBlockExplosionEffect blockEffect) {
        for (int offX = -radius; offX <= radius; ++offX) {
            for (int offY = -radiusY; offY <= radiusY; ++offY) {
                for (int offZ = -radius; offZ <= radius; ++offZ) {
                    double distance = Math.sqrt(offX * offX + offZ * offZ);
                    if (!(distance <= (double)radius)) continue;
                    BlockPos pos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_).m_7918_(offX, offY, offZ);
                    BlockState state = level.m_8055_(pos);
                    blockEffect.doBlockExplosion(level, pos, state, distance);
                }
            }
        }
    }

    public static void doTopBlockExplosion(Level level, Vec3 position, int radius, IForEachBlockExplosionEffect blockEffect) {
        for (int offX = -radius; offX <= radius; ++offX) {
            block1: for (int offZ = -radius; offZ <= radius; ++offZ) {
                for (int offY = radius; offY >= -radius; --offY) {
                    double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
                    if (!(distance <= (double)radius)) continue;
                    BlockPos pos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_).m_7918_(offX, offY, offZ);
                    BlockState state = level.m_8055_(pos);
                    if (!level.m_8055_(pos.m_7495_()).m_60838_((BlockGetter)level, pos.m_7495_()) && !level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP) || !state.m_60795_() && !state.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(level, pos, Direction.DOWN, ItemStack.f_41583_, Direction.UP)) && (state.m_60838_((BlockGetter)level, pos) || state.getExplosionResistance((BlockGetter)level, pos, (Explosion)ImprovedExplosion.dummyExplosion(level)) != 0.0f) && !state.m_204336_(BlockTags.f_13041_)) continue;
                    blockEffect.doBlockExplosion(level, pos, state, distance);
                    continue block1;
                }
            }
        }
    }

    public static void doTopBlockExplosion(Level level, Vec3 position, int radius, IBlockExplosionCondition condition, IForEachBlockExplosionEffect blockEffect) {
        for (int offX = -radius; offX <= radius; ++offX) {
            block1: for (int offZ = -radius; offZ <= radius; ++offZ) {
                for (int offY = radius; offY >= -radius; --offY) {
                    double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
                    if (!(distance <= (double)radius)) continue;
                    BlockPos pos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_).m_7918_(offX, offY, offZ);
                    BlockState state = level.m_8055_(pos);
                    if (level.m_8055_(pos.m_7495_()).m_60795_() || !condition.conditionMet(level, pos.m_7495_(), level.m_8055_(pos.m_7495_()), Math.sqrt(offX * offX + (offY - 1) * (offY - 1) + offZ * offZ))) continue;
                    blockEffect.doBlockExplosion(level, pos, state, distance);
                    continue block1;
                }
            }
        }
    }

    public static void doTopBlockExplosionForAll(Level level, Vec3 position, int radius, IForEachBlockExplosionEffect blockEffect) {
        for (int offX = -radius; offX <= radius; ++offX) {
            for (int offZ = -radius; offZ <= radius; ++offZ) {
                for (int offY = radius; offY >= -radius; --offY) {
                    double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
                    if (!(distance <= (double)radius)) continue;
                    BlockPos pos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_).m_7918_(offX, offY, offZ);
                    BlockState state = level.m_8055_(pos);
                    if (!level.m_8055_(pos.m_7495_()).m_60838_((BlockGetter)level, pos.m_7495_()) && !level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP) || !state.m_60795_() && !state.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(level, pos, Direction.DOWN, ItemStack.f_41583_, Direction.UP)) && (state.m_60838_((BlockGetter)level, pos) || state.getExplosionResistance((BlockGetter)level, pos, (Explosion)ImprovedExplosion.dummyExplosion(level)) != 0.0f) && !state.m_204336_(BlockTags.f_13041_)) continue;
                    blockEffect.doBlockExplosion(level, pos, state, distance);
                }
            }
        }
    }
}

