/*
 * Decompiled with CFR 0.152.
 */
package luckytntlib.registry;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.material.MapColor;

public class TNTBlockRegistryData {
    private final String registryName;
    private final boolean makeItem;
    private final boolean addDispenseBehavior;
    private final boolean randomizedFuseUponExploded;
    private final boolean addToTNTLists;
    private final MutableComponent description;
    private final String tab;
    private final MapColor color;

    private TNTBlockRegistryData(String registryName, boolean makeItem, boolean addDispenseBehavior, boolean randomizedFuseUponExploded, boolean addToTNTLists, MutableComponent description, String tab, MapColor color) {
        this.registryName = registryName;
        this.makeItem = makeItem;
        this.addDispenseBehavior = addDispenseBehavior;
        this.randomizedFuseUponExploded = randomizedFuseUponExploded;
        this.addToTNTLists = addToTNTLists;
        this.description = description;
        this.tab = tab;
        this.color = color;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public boolean makeItem() {
        return this.makeItem;
    }

    public boolean addDispenseBehavior() {
        return this.addDispenseBehavior;
    }

    public boolean randomizedFuseUponExploded() {
        return this.randomizedFuseUponExploded;
    }

    public boolean addToTNTLists() {
        return this.addToTNTLists;
    }

    public MutableComponent getDescription() {
        return this.description;
    }

    public String getTab() {
        return this.tab;
    }

    public MapColor getColor() {
        return this.color;
    }

    public static class Builder {
        private final String registryName;
        private boolean makeItem = true;
        private boolean addDispenseBehavior = true;
        private boolean randomizedFuseUponExploded = true;
        private boolean addToTNTLists = true;
        private MutableComponent description = Component.m_237115_((String)"");
        private String tab = "none";
        private MapColor color = MapColor.f_283913_;

        public Builder(String registryName) {
            this.registryName = registryName;
        }

        public Builder makeItem(boolean makeItem) {
            this.makeItem = makeItem;
            return this;
        }

        public Builder addDispenseBehavior(boolean addDispenseBehavior) {
            this.addDispenseBehavior = addDispenseBehavior;
            return this;
        }

        public Builder randomizedFuseUponExploded(boolean randomizedFuseUponExploded) {
            this.randomizedFuseUponExploded = randomizedFuseUponExploded;
            return this;
        }

        public Builder addToTNTLists(boolean addToTNTLists) {
            this.addToTNTLists = addToTNTLists;
            return this;
        }

        public Builder description(MutableComponent description) {
            this.description = description;
            return this;
        }

        public Builder tab(String tab) {
            this.tab = tab;
            return this;
        }

        public Builder color(MapColor color) {
            this.color = color;
            return this;
        }

        public TNTBlockRegistryData build() {
            return new TNTBlockRegistryData(this.registryName, this.makeItem, this.addDispenseBehavior, this.randomizedFuseUponExploded, this.addToTNTLists, this.description, this.tab, this.color);
        }
    }
}

