/*
 * Decompiled with CFR 0.152.
 */
package luckytntlib.registry;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import luckytntlib.block.LTNTBlock;
import luckytntlib.block.LivingLTNTBlock;
import luckytntlib.entity.LExplosiveProjectile;
import luckytntlib.entity.LTNTMinecart;
import luckytntlib.entity.LivingPrimedLTNT;
import luckytntlib.entity.PrimedLTNT;
import luckytntlib.item.LDynamiteItem;
import luckytntlib.item.LTNTMinecartItem;
import luckytntlib.registry.TNTBlockRegistryData;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class RegistryHelper {
    private final DeferredRegister<Block> blockRegistry;
    private final DeferredRegister<Item> itemRegistry;
    private final DeferredRegister<EntityType<?>> entityRegistry;
    public final HashMap<String, List<RegistryObject<LTNTBlock>>> TNTLists = new HashMap();
    public final HashMap<String, List<RegistryObject<LDynamiteItem>>> dynamiteLists = new HashMap();
    public final HashMap<String, List<RegistryObject<LTNTMinecartItem>>> minecartLists = new HashMap();
    public final HashMap<String, List<RegistryObject<? extends Item>>> creativeTabItemLists = new HashMap();
    public static final List<Pair<RegistryObject<LTNTBlock>, RegistryObject<Item>>> TNT_DISPENSER_REGISTRY_LIST = new ArrayList<Pair<RegistryObject<LTNTBlock>, RegistryObject<Item>>>();
    public static final List<RegistryObject<LDynamiteItem>> DYNAMITE_DISPENSER_REGISTRY_LIST = new ArrayList<RegistryObject<LDynamiteItem>>();
    public static final List<RegistryObject<LTNTMinecartItem>> MINECART_DISPENSER_REGISTRY_LIST = new ArrayList<RegistryObject<LTNTMinecartItem>>();

    public RegistryHelper(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry, DeferredRegister<EntityType<?>> entityRegistry) {
        this.blockRegistry = blockRegistry;
        this.itemRegistry = itemRegistry;
        this.entityRegistry = entityRegistry;
    }

    public RegistryObject<LTNTBlock> registerTNTBlock(String registryName, RegistryObject<EntityType<PrimedLTNT>> TNT, String tab) {
        return this.registerTNTBlock(registryName, TNT, tab, MapColor.f_283913_, true);
    }

    public RegistryObject<LTNTBlock> registerTNTBlock(String registryName, RegistryObject<EntityType<PrimedLTNT>> TNT, String tab, boolean randomizedFuseUponExploded) {
        return this.registerTNTBlock(registryName, TNT, tab, MapColor.f_283913_, randomizedFuseUponExploded);
    }

    public RegistryObject<LTNTBlock> registerTNTBlock(String registryName, RegistryObject<EntityType<PrimedLTNT>> TNT, String tab, MapColor color, boolean randomizedFuseUponExploded) {
        return this.registerTNTBlock(TNT, new TNTBlockRegistryData.Builder(registryName).tab(tab).color(color).randomizedFuseUponExploded(randomizedFuseUponExploded).build());
    }

    public RegistryObject<LTNTBlock> registerTNTBlock(RegistryObject<EntityType<PrimedLTNT>> TNT, TNTBlockRegistryData blockData) {
        return this.registerTNTBlock(this.blockRegistry, this.itemRegistry, () -> new LTNTBlock(BlockBehaviour.Properties.m_284310_().m_284180_(blockData.getColor()).m_60918_(SoundType.f_56740_), TNT, blockData.randomizedFuseUponExploded()), blockData);
    }

    public RegistryObject<LTNTBlock> registerTNTBlock(DeferredRegister<Block> blockRegistry, @Nullable DeferredRegister<Item> itemRegistry, Supplier<LTNTBlock> TNTBlock, final TNTBlockRegistryData blockData) {
        RegistryObject block = blockRegistry.register(blockData.getRegistryName(), TNTBlock);
        if (itemRegistry != null && blockData.makeItem()) {
            RegistryObject item = itemRegistry.register(blockData.getRegistryName(), () -> new BlockItem((Block)block.get(), new Item.Properties()){

                public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
                    super.m_7373_(stack, level, components, flag);
                    if (!blockData.getDescription().getString().equals("")) {
                        components.add((Component)blockData.getDescription());
                    }
                }
            });
            if (blockData.addToTNTLists()) {
                if (this.TNTLists.get(blockData.getTab()) == null) {
                    this.TNTLists.put(blockData.getTab(), new ArrayList());
                }
                this.TNTLists.get(blockData.getTab()).add((RegistryObject<LTNTBlock>)block);
            }
            if (blockData.addDispenseBehavior()) {
                TNT_DISPENSER_REGISTRY_LIST.add((Pair<RegistryObject<LTNTBlock>, RegistryObject<Item>>)new Pair((Object)block, (Object)item));
            }
            if (!blockData.getTab().equals("none")) {
                if (this.creativeTabItemLists.get(blockData.getTab()) == null) {
                    this.creativeTabItemLists.put(blockData.getTab(), new ArrayList());
                }
                this.creativeTabItemLists.get(blockData.getTab()).add((RegistryObject<? extends Item>)item);
            }
        }
        return block;
    }

    public RegistryObject<LTNTBlock> registerLivingTNTBlock(String registryName, RegistryObject<EntityType<LivingPrimedLTNT>> TNT, String tab) {
        return this.registerLivingTNTBlock(registryName, TNT, tab, MapColor.f_283913_, true);
    }

    public RegistryObject<LTNTBlock> registerLivingTNTBlock(String registryName, RegistryObject<EntityType<LivingPrimedLTNT>> TNT, String tab, boolean randomizedFuseUponExploded) {
        return this.registerLivingTNTBlock(registryName, TNT, tab, MapColor.f_283913_, randomizedFuseUponExploded);
    }

    public RegistryObject<LTNTBlock> registerLivingTNTBlock(String registryName, RegistryObject<EntityType<LivingPrimedLTNT>> TNT, String tab, MapColor color, boolean randomizedFuseUponExploded) {
        return this.registerLivingTNTBlock(TNT, new TNTBlockRegistryData.Builder(registryName).tab(tab).color(color).randomizedFuseUponExploded(randomizedFuseUponExploded).build());
    }

    public RegistryObject<LTNTBlock> registerLivingTNTBlock(RegistryObject<EntityType<LivingPrimedLTNT>> TNT, TNTBlockRegistryData blockData) {
        return this.registerLivingTNTBlock(this.blockRegistry, this.itemRegistry, () -> new LivingLTNTBlock(BlockBehaviour.Properties.m_284310_().m_284180_(blockData.getColor()).m_60918_(SoundType.f_56740_), TNT, blockData.randomizedFuseUponExploded()), blockData);
    }

    public RegistryObject<LTNTBlock> registerLivingTNTBlock(DeferredRegister<Block> blockRegistry, @Nullable DeferredRegister<Item> itemRegistry, Supplier<LivingLTNTBlock> TNTBlock, final TNTBlockRegistryData blockData) {
        RegistryObject block = blockRegistry.register(blockData.getRegistryName(), () -> (LTNTBlock)((Object)((Object)TNTBlock.get())));
        if (itemRegistry != null && blockData.makeItem()) {
            RegistryObject item = itemRegistry.register(blockData.getRegistryName(), () -> new BlockItem((Block)block.get(), new Item.Properties()){

                public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
                    super.m_7373_(stack, level, components, flag);
                    if (!blockData.getDescription().getString().equals("")) {
                        components.add((Component)blockData.getDescription());
                    }
                }
            });
            if (blockData.addToTNTLists()) {
                if (this.TNTLists.get(blockData.getTab()) == null) {
                    this.TNTLists.put(blockData.getTab(), new ArrayList());
                }
                this.TNTLists.get(blockData.getTab()).add((RegistryObject<LTNTBlock>)block);
            }
            if (blockData.addDispenseBehavior()) {
                TNT_DISPENSER_REGISTRY_LIST.add((Pair<RegistryObject<LTNTBlock>, RegistryObject<Item>>)new Pair((Object)block, (Object)item));
            }
            if (!blockData.getTab().equals("none")) {
                if (this.creativeTabItemLists.get(blockData.getTab()) == null) {
                    this.creativeTabItemLists.put(blockData.getTab(), new ArrayList());
                }
                this.creativeTabItemLists.get(blockData.getTab()).add((RegistryObject<? extends Item>)item);
            }
        }
        return block;
    }

    public RegistryObject<LDynamiteItem> registerDynamiteItem(String registryName, Supplier<LDynamiteItem> dynamiteSupplier, String tab) {
        return this.registerDynamiteItem(registryName, dynamiteSupplier, tab, true, true);
    }

    public RegistryObject<LDynamiteItem> registerDynamiteItem(String registryName, Supplier<LDynamiteItem> dynamiteSupplier, String tab, boolean addToLists, boolean addDispenseBehavior) {
        return this.registerDynamiteItem(this.itemRegistry, registryName, dynamiteSupplier, tab, addToLists, addDispenseBehavior);
    }

    public RegistryObject<LDynamiteItem> registerDynamiteItem(String registryName, RegistryObject<EntityType<LExplosiveProjectile>> dynamite, String tab) {
        return this.registerDynamiteItem(registryName, () -> new LDynamiteItem(new Item.Properties(), dynamite), tab);
    }

    public RegistryObject<LDynamiteItem> registerDynamiteItem(DeferredRegister<Item> itemRegistry, String registryName, Supplier<LDynamiteItem> dynamiteSupplier, String tab, boolean addToLists, boolean addDispenseBehavior) {
        RegistryObject item = itemRegistry.register(registryName, dynamiteSupplier);
        if (addToLists) {
            if (this.dynamiteLists.get(tab) == null) {
                this.dynamiteLists.put(tab, new ArrayList());
            }
            this.dynamiteLists.get(tab).add((RegistryObject<LDynamiteItem>)item);
        }
        if (addDispenseBehavior) {
            DYNAMITE_DISPENSER_REGISTRY_LIST.add((RegistryObject<LDynamiteItem>)item);
        }
        if (!tab.equals("none")) {
            if (this.creativeTabItemLists.get(tab) == null) {
                this.creativeTabItemLists.put(tab, new ArrayList());
            }
            this.creativeTabItemLists.get(tab).add((RegistryObject<? extends Item>)item);
        }
        return item;
    }

    public RegistryObject<LTNTMinecartItem> registerTNTMinecartItem(String registryName, Supplier<RegistryObject<EntityType<LTNTMinecart>>> TNT, String tab) {
        return this.registerTNTMinecartItem(registryName, () -> new LTNTMinecartItem(new Item.Properties().m_41487_(1), TNT), tab, true, true);
    }

    public RegistryObject<LTNTMinecartItem> registerTNTMinecartItem(String registryName, Supplier<LTNTMinecartItem> minecartSupplier, String tab, boolean addToLists, boolean addDispenseBehavior) {
        return this.registerTNTMinecartItem(this.itemRegistry, registryName, minecartSupplier, tab, addToLists, addDispenseBehavior);
    }

    public RegistryObject<LTNTMinecartItem> registerTNTMinecartItem(DeferredRegister<Item> itemRegistry, String registryName, Supplier<LTNTMinecartItem> minecartSupplier, String tab, boolean addToLists, boolean addDispenseBehavior) {
        RegistryObject item = itemRegistry.register(registryName, minecartSupplier);
        if (addToLists) {
            if (this.minecartLists.get(tab) == null) {
                this.minecartLists.put(tab, new ArrayList());
            }
            this.minecartLists.get(tab).add((RegistryObject<LTNTMinecartItem>)item);
        }
        if (addDispenseBehavior) {
            MINECART_DISPENSER_REGISTRY_LIST.add((RegistryObject<LTNTMinecartItem>)item);
        }
        if (!tab.equals("none")) {
            if (this.creativeTabItemLists.get(tab) == null) {
                this.creativeTabItemLists.put(tab, new ArrayList());
            }
            this.creativeTabItemLists.get(tab).add((RegistryObject<? extends Item>)item);
        }
        return item;
    }

    public RegistryObject<EntityType<PrimedLTNT>> registerTNTEntity(String registryName, PrimedTNTEffect effect) {
        return this.registerTNTEntity(registryName, effect, 1.0f, true);
    }

    public RegistryObject<EntityType<PrimedLTNT>> registerTNTEntity(String registryName, PrimedTNTEffect effect, float size, boolean fireImmune) {
        return this.registerTNTEntity(this.entityRegistry, registryName, effect, size, fireImmune);
    }

    public RegistryObject<EntityType<PrimedLTNT>> registerTNTEntity(DeferredRegister<EntityType<?>> entityRegistry, String registryName, PrimedTNTEffect effect, float size, boolean fireImmune) {
        if (fireImmune) {
            return entityRegistry.register(registryName, () -> EntityType.Builder.m_20704_((type, level) -> new PrimedLTNT((EntityType<PrimedLTNT>)type, level, effect), (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).m_20719_().m_20699_(size, size).m_20712_(registryName));
        }
        return entityRegistry.register(registryName, () -> EntityType.Builder.m_20704_((type, level) -> new PrimedLTNT((EntityType<PrimedLTNT>)type, level, effect), (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).m_20699_(size, size).m_20712_(registryName));
    }

    public RegistryObject<EntityType<PrimedLTNT>> registerTNTEntity(DeferredRegister<EntityType<?>> entityRegistry, String registryName, Supplier<EntityType<PrimedLTNT>> TNT) {
        return entityRegistry.register(registryName, TNT);
    }

    public RegistryObject<EntityType<LTNTMinecart>> registerTNTMinecart(String registryName, RegistryObject<EntityType<PrimedLTNT>> TNT, Supplier<RegistryObject<LTNTMinecartItem>> pickItem) {
        return this.registerTNTMinecart(registryName, TNT, pickItem, true);
    }

    public RegistryObject<EntityType<LTNTMinecart>> registerTNTMinecart(String registryName, RegistryObject<EntityType<PrimedLTNT>> TNT, Supplier<RegistryObject<LTNTMinecartItem>> pickItem, boolean explodesInstantly) {
        return this.registerTNTMinecart(this.entityRegistry, registryName, TNT, pickItem, explodesInstantly);
    }

    public RegistryObject<EntityType<LTNTMinecart>> registerTNTMinecart(DeferredRegister<EntityType<?>> entityRegistry, String registryName, RegistryObject<EntityType<PrimedLTNT>> TNT, Supplier<RegistryObject<LTNTMinecartItem>> pickItem, boolean explodesInstantly) {
        return entityRegistry.register(registryName, () -> EntityType.Builder.m_20704_((arg_0, arg_1) -> RegistryHelper.lambda$registerTNTMinecart$11(TNT, (Supplier)pickItem, explodesInstantly, arg_0, arg_1), (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).m_20699_(0.98f, 0.7f).m_20712_(registryName));
    }

    public RegistryObject<EntityType<LTNTMinecart>> registerTNTMinecart(DeferredRegister<EntityType<?>> entityRegistry, String registryName, Supplier<EntityType<LTNTMinecart>> minecart) {
        return entityRegistry.register(registryName, minecart);
    }

    public RegistryObject<EntityType<LivingPrimedLTNT>> registerLivingTNTEntity(String registryName, Supplier<EntityType<LivingPrimedLTNT>> TNT) {
        return this.registerLivingTNTEntity(this.entityRegistry, registryName, TNT);
    }

    public RegistryObject<EntityType<LivingPrimedLTNT>> registerLivingTNTEntity(DeferredRegister<EntityType<?>> entityRegistry, String registryName, Supplier<EntityType<LivingPrimedLTNT>> TNT) {
        return entityRegistry.register(registryName, TNT);
    }

    public RegistryObject<EntityType<LExplosiveProjectile>> registerExplosiveProjectile(String registryName, PrimedTNTEffect effect) {
        return this.registerExplosiveProjectile(registryName, effect, 1.0f, false);
    }

    public RegistryObject<EntityType<LExplosiveProjectile>> registerExplosiveProjectile(String registryName, PrimedTNTEffect effect, float size, boolean fireImmune) {
        return this.registerExplosiveProjectile(this.entityRegistry, registryName, effect, size, fireImmune);
    }

    public RegistryObject<EntityType<LExplosiveProjectile>> registerExplosiveProjectile(DeferredRegister<EntityType<?>> entityRegistry, String registryName, PrimedTNTEffect effect, float size, boolean fireImmune) {
        if (fireImmune) {
            return entityRegistry.register(registryName, () -> EntityType.Builder.m_20704_((type, level) -> new LExplosiveProjectile((EntityType<LExplosiveProjectile>)type, level, effect), (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).m_20719_().m_20699_(size, size).m_20712_(registryName));
        }
        return entityRegistry.register(registryName, () -> EntityType.Builder.m_20704_((type, level) -> new LExplosiveProjectile((EntityType<LExplosiveProjectile>)type, level, effect), (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).m_20699_(size, size).m_20712_(registryName));
    }

    public RegistryObject<EntityType<LExplosiveProjectile>> registerExplosiveProjectile(DeferredRegister<EntityType<?>> entityRegistry, String registryName, Supplier<EntityType<LExplosiveProjectile>> projectile) {
        return entityRegistry.register(registryName, projectile);
    }

    private static /* synthetic */ LTNTMinecart lambda$registerTNTMinecart$11(RegistryObject TNT, Supplier pickItem, boolean explodesInstantly, EntityType type, Level level) {
        return new LTNTMinecart((EntityType<LTNTMinecart>)type, level, (RegistryObject<EntityType<PrimedLTNT>>)TNT, pickItem, explodesInstantly);
    }
}

