/*
 * Decompiled with CFR 0.152.
 */
package luckytntlib.entity;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import luckytntlib.entity.LuckyTNTMinecart;
import luckytntlib.entity.PrimedLTNT;
import luckytntlib.item.LTNTMinecartItem;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class LTNTMinecart
extends AbstractMinecart
implements IExplosiveEntity {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(LTNTMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean explodeInstantly;
    protected PrimedTNTEffect effect;
    protected Supplier<RegistryObject<LTNTMinecartItem>> pickItem;
    public LivingEntity placer;

    public LTNTMinecart(EntityType<LTNTMinecart> type, Level level, RegistryObject<EntityType<PrimedLTNT>> TNT, Supplier<RegistryObject<LTNTMinecartItem>> pickItem, boolean explodeInstantly) {
        super(type, level);
        if (TNT != null) {
            PrimedLTNT tnt = (PrimedLTNT)((EntityType)TNT.get()).m_20615_(level);
            this.effect = tnt.getEffect();
            tnt.m_146870_();
        } else if (!(this instanceof LuckyTNTMinecart)) {
            this.m_146870_();
        }
        this.explodeInstantly = explodeInstantly;
        this.pickItem = pickItem;
        this.setTNTFuse(-1);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getTNTFuse() >= 0) {
            this.getEffect().baseTick(this);
        }
        if (this.f_19862_ && this.m_20184_().m_165925_() >= (double)0.01f && this.getTNTFuse() < 0) {
            if (this.explodesInstantly()) {
                this.fuse();
                this.setTNTFuse(0);
            } else {
                this.fuse();
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        AbstractArrow abstractarrow;
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractArrow && (abstractarrow = (AbstractArrow)entity).m_6060_() && this.getTNTFuse() < 0) {
            this.fuse();
        }
        if (source.m_276093_(DamageTypes.f_268450_) && this.getTNTFuse() >= 0) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7617_(DamageSource source) {
        double speed = this.m_20184_().m_165925_();
        if (!(source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268565_) || speed >= (double)0.01f)) {
            super.m_7617_(source);
        } else if (this.getTNTFuse() < 0) {
            if (this.explodesInstantly()) {
                this.fuse();
                Level level = this.m_9236_();
                this.setTNTFuse(this.getEffect().getDefaultFuse(this) / 4 + level.f_46441_.m_188503_(this.getEffect().getDefaultFuse(this)) / 4);
            } else {
                this.fuse();
            }
        }
    }

    public boolean m_142535_(float ditance, float damage, DamageSource source) {
        if (ditance >= 3.0f && this.getTNTFuse() < 0) {
            if (this.explodesInstantly()) {
                this.fuse();
                this.setTNTFuse(0);
            } else {
                this.fuse();
            }
        }
        return super.m_142535_(ditance, damage, source);
    }

    public void m_6025_(int x, int y, int z, boolean active) {
        if (active && this.getTNTFuse() < 0) {
            this.fuse();
        }
    }

    public void fuse() {
        this.setTNTFuse(this.getEffect().getDefaultFuse(this));
        this.m_9236_().m_5594_(null, new BlockPos((int)this.m_20318_((float)1.0f).f_82479_, (int)this.m_20318_((float)1.0f).f_82480_, (int)this.m_20318_((float)1.0f).f_82481_), SoundEvents.f_12512_, this.m_5720_(), 1.0f, 1.0f);
    }

    public void m_8097_() {
        this.f_19804_.m_135372_(DATA_FUSE_ID, (Object)-1);
        super.m_8097_();
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.placer;
    }

    public void setOwner(LivingEntity owner) {
        this.placer = owner;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.pickItem.get().get());
    }

    protected Item m_213728_() {
        return (Item)this.pickItem.get().get();
    }

    public BlockState m_38178_() {
        return this.getEffect().getBlock().m_49966_();
    }

    public void m_7380_(CompoundTag tag) {
        if (this.placer != null) {
            tag.m_128405_("placerID", this.placer.m_19879_());
        }
        tag.m_128376_("Fuse", (short)this.getTNTFuse());
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        Entity entity = this.m_9236_().m_6815_(tag.m_128451_("placerID"));
        if (entity instanceof LivingEntity) {
            LivingEntity lEnt;
            this.placer = lEnt = (LivingEntity)entity;
        }
        this.setTNTFuse(tag.m_128448_("Fuse"));
        super.m_7378_(tag);
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.TNT;
    }

    public boolean explodesInstantly() {
        return this.explodeInstantly;
    }

    @Override
    public PrimedTNTEffect getEffect() {
        return this.effect;
    }

    @Override
    public int getTNTFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }

    @Override
    public void setTNTFuse(int fuse) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)fuse);
    }

    @Override
    public Vec3 getPos() {
        return this.m_20318_(1.0f);
    }

    @Override
    public void destroy() {
        this.m_146870_();
    }

    @Override
    public Level getLevel() {
        return this.m_9236_();
    }

    @Override
    public double x() {
        return this.m_20185_();
    }

    @Override
    public double y() {
        return this.m_20186_();
    }

    @Override
    public double z() {
        return this.m_20189_();
    }

    @Override
    public LivingEntity owner() {
        return this.getOwner();
    }
}

