/*
 * Decompiled with CFR 0.152.
 */
package luckytntlib.entity;

import javax.annotation.Nullable;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class LExplosiveProjectile
extends AbstractArrow
implements IExplosiveEntity,
ItemSupplier {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(LExplosiveProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private LivingEntity thrower;
    private boolean hitEntity = false;
    private PrimedTNTEffect effect;

    public LExplosiveProjectile(EntityType<LExplosiveProjectile> type, Level level, PrimedTNTEffect effect) {
        super(type, level);
        this.setTNTFuse(effect.getDefaultFuse(this));
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        this.effect = effect;
    }

    public void m_8060_(BlockHitResult hitResult) {
        Vec3 pos = hitResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(pos);
        Vec3 pos2 = pos.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - pos2.f_82479_, this.m_20186_() - pos2.f_82480_, this.m_20189_() - pos2.f_82481_);
        this.f_36703_ = true;
    }

    public void m_5790_(EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_7500_() && !player.m_5833_()) {
                this.hitEntity = true;
            }
        } else {
            this.hitEntity = true;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.effect.baseTick(this);
    }

    public void m_8097_() {
        this.f_19804_.m_135372_(DATA_FUSE_ID, (Object)-1);
        super.m_8097_();
    }

    public void m_7380_(CompoundTag tag) {
        if (this.thrower != null) {
            tag.m_128405_("throwerID", this.thrower.m_19879_());
        }
        tag.m_128376_("Fuse", (short)this.getTNTFuse());
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        Entity entity = this.m_9236_().m_6815_(tag.m_128451_("throwerID"));
        if (entity instanceof LivingEntity) {
            LivingEntity lEnt;
            this.thrower = lEnt = (LivingEntity)entity;
        }
        this.setTNTFuse(tag.m_128448_("Fuse"));
        super.m_7378_(tag);
    }

    @Override
    public PrimedTNTEffect getEffect() {
        return this.effect;
    }

    public boolean inGround() {
        return this.f_36703_;
    }

    public boolean hitEntity() {
        return this.hitEntity;
    }

    @Override
    public void setTNTFuse(int fuse) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)fuse);
    }

    public void setOwner(@Nullable LivingEntity thrower) {
        this.thrower = thrower;
    }

    public void m_5602_(Entity entity) {
        this.thrower = entity instanceof LivingEntity ? (LivingEntity)entity : this.thrower;
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.thrower;
    }

    public ItemStack m_7941_() {
        return null;
    }

    @Override
    public int getTNTFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }

    @Override
    public Vec3 getPos() {
        return this.m_20318_(1.0f);
    }

    @Override
    public void destroy() {
        this.m_146870_();
    }

    @Override
    public Level getLevel() {
        return this.m_9236_();
    }

    @Override
    public double x() {
        return this.m_20185_();
    }

    @Override
    public double y() {
        return this.m_20186_();
    }

    @Override
    public double z() {
        return this.m_20189_();
    }

    public ItemStack m_7846_() {
        return this.effect.getItemStack();
    }

    @Override
    public LivingEntity owner() {
        return this.getOwner();
    }
}

