/*
 * Decompiled with CFR 0.152.
 */
package luckytntlib.block;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import luckytntlib.entity.PrimedLTNT;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraftforge.registries.RegistryObject;

public class LTNTBlock
extends TntBlock {
    @Nullable
    protected RegistryObject<EntityType<PrimedLTNT>> TNT;
    protected Random random = new Random();
    protected boolean randomizedFuseUponExploded = true;

    public LTNTBlock(BlockBehaviour.Properties properties, @Nullable RegistryObject<EntityType<PrimedLTNT>> TNT, boolean randomizedFuseUponExploded) {
        super(properties);
        this.TNT = TNT;
        this.randomizedFuseUponExploded = randomizedFuseUponExploded;
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        if (!level.f_46443_) {
            this.explode(level, false, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), igniter);
        }
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return 0.0f;
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 200;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!level.f_46443_) {
            this.explode(level, true, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), explosion.m_252906_());
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return Collections.singletonList(new ItemStack((ItemLike)this));
    }

    @Deprecated
    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
    }

    @Nullable
    public PrimedLTNT explode(Level level, boolean exploded, double x, double y, double z, @Nullable LivingEntity igniter) throws NullPointerException {
        if (this.TNT != null) {
            PrimedLTNT tnt = (PrimedLTNT)((EntityType)this.TNT.get()).m_20615_(level);
            tnt.m_32085_(exploded && this.randomizedFuseUponExploded() ? tnt.getEffect().getDefaultFuse(tnt) / 8 + this.random.nextInt(Mth.m_14045_((int)(tnt.getEffect().getDefaultFuse(tnt) / 4), (int)1, (int)Integer.MAX_VALUE)) : tnt.getEffect().getDefaultFuse(tnt));
            tnt.m_6034_(x + 0.5, y, z + 0.5);
            tnt.setOwner(igniter);
            level.m_7967_((Entity)tnt);
            level.m_5594_(null, new BlockPos((int)x, (int)y, (int)z), SoundEvents.f_12512_, SoundSource.MASTER, 1.0f, 1.0f);
            if (level.m_8055_(new BlockPos((int)x, (int)y, (int)z)).m_60734_() == this) {
                level.m_7731_(new BlockPos((int)x, (int)y, (int)z), Blocks.f_50016_.m_49966_(), 3);
            }
            return tnt;
        }
        throw new NullPointerException("TNT entity type is null");
    }

    public boolean randomizedFuseUponExploded() {
        return this.randomizedFuseUponExploded;
    }
}

