/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class AddAttributesFunction
implements LootItemFunction {
    private static final Function<ItemStack, EquipmentSlot[]> SLOTS_BY_ITEM;
    private final boolean preserveDefaultModifier;
    private final List<Modifier> modifiers;

    public AddAttributesFunction(boolean preserveDefaultModifier, List<Modifier> modifiers) {
        this.preserveDefaultModifier = preserveDefaultModifier;
        this.modifiers = modifiers;
    }

    public ItemStack apply(ItemStack itemStack, LootContext context) {
        for (Modifier modifier : this.modifiers) {
            if (!(context.m_230907_().m_188501_() < modifier.probability)) continue;
            AttributeModifier am = modifier.createAttributeModifier(context);
            for (EquipmentSlot slot : modifier.slots.apply(itemStack)) {
                if (this.preserveDefaultModifier) {
                    this.preserveDefaultAttributes(itemStack, slot);
                }
                itemStack.m_41643_(modifier.attribute, am, slot);
            }
        }
        return itemStack;
    }

    public void preserveDefaultAttributes(ItemStack itemStack, EquipmentSlot slot) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128425_("AttributeModifiers", 9)) {
            return;
        }
        Multimap defaultAttributeModifiers = itemStack.m_41720_().m_7167_(slot);
        for (Map.Entry entry : defaultAttributeModifiers.entries()) {
            itemStack.m_41643_((Attribute)entry.getKey(), (AttributeModifier)entry.getValue(), slot);
        }
    }

    public LootItemFunctionType m_7162_() {
        throw new UnsupportedOperationException("Do not call");
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class Modifier {
        protected final Attribute attribute;
        protected final float probability;
        protected final AttributeModifier.Operation operation;
        protected final NumberProvider amount;
        protected final String name;
        protected final Function<ItemStack, EquipmentSlot[]> slots;
        @Nullable
        protected UUID uuid;

        public Modifier(float probability, Attribute attribute, AttributeModifier.Operation operation, NumberProvider amount, String name, Function<ItemStack, EquipmentSlot[]> slots, @Nullable UUID uuid) {
            this.attribute = attribute;
            this.probability = probability;
            this.operation = operation;
            this.amount = amount;
            this.name = name;
            this.slots = slots;
            this.uuid = uuid;
        }

        public AttributeModifier createAttributeModifier(LootContext context) {
            return new AttributeModifier(UUID.randomUUID(), this.name, (double)this.amount.m_142688_(context), this.operation);
        }

        public static class Builder {
            protected final Attribute attribute;
            protected final NumberProvider amount;
            protected float probability;
            protected AttributeModifier.Operation operation;
            protected Function<ItemStack, EquipmentSlot[]> slots;
            @Nullable
            protected UUID uuid;
            @Nullable
            protected String name;

            public Builder(Attribute attribute, NumberProvider amount) {
                this.attribute = attribute;
                this.amount = amount;
                this.probability = 1.0f;
                this.operation = AttributeModifier.Operation.ADDITION;
                this.slots = SLOTS_BY_ITEM;
            }

            public void setProbability(float probability) {
                this.probability = probability;
            }

            public void setOperation(AttributeModifier.Operation operation) {
                this.operation = operation;
            }

            public void setSlots(EquipmentSlot[] slots) {
                this.slots = itemStack -> slots;
            }

            public void setName(@Nullable String name) {
                this.name = name;
            }

            public void setUuid(@Nullable UUID uuid) {
                this.uuid = uuid;
            }

            public Modifier build() {
                if (this.name == null) {
                    this.name = "lootjs." + this.attribute.m_22087_() + "." + this.operation.name().toLowerCase();
                }
                return new Modifier(this.probability, this.attribute, this.operation, this.amount, this.name, this.slots, this.uuid);
            }
        }
    }

    public static class Builder
    implements LootItemFunction.Builder {
        private final List<Modifier> modifiers = new ArrayList<Modifier>();
        private boolean preserveDefaults = true;

        public Builder preserveDefaults(boolean flag) {
            this.preserveDefaults = flag;
            return this;
        }

        public Builder simple(Attribute attribute, NumberProvider amount) {
            return this.simple(1.0f, attribute, amount);
        }

        public Builder simple(float probability, Attribute attribute, NumberProvider amount) {
            return this.add(attribute, amount, m -> m.setProbability(probability));
        }

        public Builder forSlots(Attribute attribute, NumberProvider amount, EquipmentSlot[] slots) {
            return this.add(attribute, amount, m -> m.setSlots(slots));
        }

        public Builder forSlots(float probability, Attribute attribute, NumberProvider amount, EquipmentSlot[] slots) {
            return this.add(attribute, amount, m -> {
                m.setProbability(probability);
                m.setSlots(slots);
            });
        }

        public Builder add(Attribute attribute, NumberProvider amount, Consumer<Modifier.Builder> action) {
            Modifier.Builder builder = new Modifier.Builder(attribute, amount);
            action.accept(builder);
            return this.add(builder.build());
        }

        public Builder add(Modifier modifier) {
            Objects.requireNonNull(modifier);
            this.modifiers.add(modifier);
            return this;
        }

        public AddAttributesFunction build() {
            return new AddAttributesFunction(this.preserveDefaults, this.modifiers);
        }
    }
}

