/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.ListUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.items.IItemHandler;

public abstract class ItemRequirement
implements Predicate<ItemStack> {
    private static ItemRequirement NULL = null;
    private int count;

    @Nonnull
    public static ItemRequirement getNull() {
        if (NULL == null) {
            NULL = new NullRequirement();
        }
        return NULL;
    }

    public int getCount() {
        return this.count;
    }

    private ItemRequirement(int count) {
        this.count = count;
    }

    @Override
    public abstract boolean test(ItemStack var1);

    public final boolean isNull() {
        return this instanceof NullRequirement || this.count <= 0;
    }

    public final boolean isValid() {
        return !this.isNull();
    }

    public boolean tryMerge(@Nonnull ItemRequirement other) {
        if (this.matches(other)) {
            this.count += other.count;
            other.count = 0;
            return true;
        }
        return false;
    }

    public static ItemRequirement of(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return ItemRequirement.getNull();
        }
        return new StackMatch(stack, stack.m_41613_());
    }

    public static ItemRequirement ofItemNoNBT(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return ItemRequirement.getNull();
        }
        return ItemRequirement.of(stack.m_41720_(), stack.m_41613_());
    }

    public static ItemRequirement of(Item item, int count) {
        if (item == null || item == Items.f_41852_) {
            return ItemRequirement.getNull();
        }
        return new ItemMatch(item, count);
    }

    public static ItemRequirement of(Ingredient ingredient, int count) {
        if (ingredient == null) {
            return ItemRequirement.getNull();
        }
        return new IngredientRequirement(ingredient, count);
    }

    public static ItemRequirement fromFilter(ItemStack filterItem, Predicate<ItemStack> filter) {
        if (filter == null) {
            return ItemRequirement.of(filterItem);
        }
        return new FilterRequirement(filterItem, filter);
    }

    public static List<ItemRequirement> combineRequirements(ItemRequirement ... requirements) {
        ArrayList<ItemRequirement> list = new ArrayList<ItemRequirement>();
        for (ItemRequirement requirement : requirements) {
            ItemRequirement r;
            if (!requirement.isValid()) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !(r = (ItemRequirement)iterator.next()).tryMerge(requirement)) {
            }
            if (!requirement.isValid()) continue;
            list.add(requirement);
        }
        return list;
    }

    public static MatchingItemsList getMatchingItems(IItemHandler container, List<ItemRequirement> requirements) {
        MatchingItemsList list = new MatchingItemsList(requirements);
        list.testContainer(container);
        return list;
    }

    @Nullable
    public static List<ItemStack> getRandomItemsMatchingRequirements(IItemHandler container, ItemRequirement requirement1, ItemRequirement requirement2, boolean creative) {
        List<ItemRequirement> requirements = ItemRequirement.combineRequirements(requirement1, requirement2);
        if (requirements.isEmpty()) {
            return null;
        }
        MatchingItemsList matchingItems = ItemRequirement.getMatchingItems(container, requirements);
        return matchingItems.getRandomItems(!creative);
    }

    private static void addToList(List<ItemStack> list, ItemStack stack) {
        for (ItemStack s : list) {
            if (!InventoryUtil.ItemMatches(s, stack)) continue;
            s.m_41769_(stack.m_41613_());
            return;
        }
        list.add(stack.m_41777_());
    }

    private static void removeFromList(List<ItemStack> list, ItemStack stack) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack s = list.get(i);
            if (!InventoryUtil.ItemMatches(s, stack)) continue;
            s.m_41774_(stack.m_41613_());
            if (s.m_41619_()) {
                list.remove(i);
            }
            return;
        }
    }

    private static int getTotalCount(List<ItemStack> list) {
        int count = 0;
        for (ItemStack s : list) {
            count += s.m_41613_();
        }
        return count;
    }

    @Nullable
    public static List<ItemStack> getRandomItems(List<ItemStack> validItems, int count, boolean creative) {
        if (validItems.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < count; ++i) {
            ItemStack removed;
            ItemStack randomStack = ListUtil.weightedRandomItemFromList(validItems, ItemStack::m_41613_);
            if (randomStack != null) {
                removed = randomStack.m_255036_(1);
                if (!creative) {
                    ItemRequirement.removeFromList(validItems, removed);
                }
            } else {
                return null;
            }
            result.add(removed);
        }
        return result;
    }

    public static List<ItemStack> getFirstItemsMatchingRequirements(Container container, ItemRequirement ... requirements) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        HashMap<Integer, Integer> consumedItems = new HashMap<Integer, Integer>();
        for (ItemRequirement requirement : requirements) {
            int leftToConsume = requirement.count;
            for (int i = 0; i < container.m_6643_() && leftToConsume > 0; ++i) {
                ItemStack stack = container.m_8020_(i);
                if (!requirement.test(stack)) continue;
                int alreadyConsumed = consumedItems.getOrDefault(i, 0);
                int consumeCount = Math.min(leftToConsume, stack.m_41613_() - alreadyConsumed);
                leftToConsume -= consumeCount;
                if (consumeCount <= 0) continue;
                consumedItems.put(i, alreadyConsumed + consumeCount);
                boolean query = true;
                for (int x = 0; x < results.size() && query; ++x) {
                    if (!InventoryUtil.ItemMatches((ItemStack)results.get(x), stack)) continue;
                    query = false;
                    ((ItemStack)results.get(x)).m_41769_(consumeCount);
                }
                if (!query) continue;
                ItemStack result = stack.m_41777_();
                result.m_41764_(consumeCount);
                results.add(result);
            }
            if (leftToConsume <= 0) continue;
            return null;
        }
        return results;
    }

    public static List<ItemStack> getFirstItemsMatchingRequirements(IItemHandler container, ItemRequirement ... requirements) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        HashMap<Integer, Integer> consumedItems = new HashMap<Integer, Integer>();
        for (ItemRequirement requirement : requirements) {
            int leftToConsume = requirement.count;
            for (int i = 0; i < container.getSlots() && leftToConsume > 0; ++i) {
                ItemStack stack = container.getStackInSlot(i);
                if (!requirement.test(stack)) continue;
                int alreadyConsumed = consumedItems.getOrDefault(i, 0);
                int consumeCount = Math.min(leftToConsume, stack.m_41613_() - alreadyConsumed);
                leftToConsume -= consumeCount;
                if (consumeCount <= 0) continue;
                consumedItems.put(i, alreadyConsumed + consumeCount);
                boolean query = true;
                for (int x = 0; x < results.size() && query; ++x) {
                    if (!InventoryUtil.ItemMatches((ItemStack)results.get(x), stack)) continue;
                    query = false;
                    ((ItemStack)results.get(x)).m_41769_(consumeCount);
                }
                if (!query) continue;
                ItemStack result = stack.m_41777_();
                result.m_41764_(consumeCount);
                results.add(result);
            }
            if (leftToConsume <= 0) continue;
            return null;
        }
        return results;
    }

    public abstract boolean matches(@Nonnull ItemRequirement var1);

    private static class NullRequirement
    extends ItemRequirement {
        private NullRequirement() {
            super(0);
        }

        @Override
        public boolean test(ItemStack stack) {
            return false;
        }

        @Override
        public boolean matches(@Nonnull ItemRequirement otherRequirement) {
            return otherRequirement instanceof NullRequirement;
        }
    }

    private static class StackMatch
    extends ItemRequirement {
        private final ItemStack stack;

        private StackMatch(@Nonnull ItemStack stack) {
            this(stack, stack.m_41613_());
        }

        private StackMatch(@Nonnull ItemStack stack, int count) {
            super(count);
            this.stack = stack;
        }

        @Override
        public boolean test(ItemStack stack) {
            return InventoryUtil.ItemMatches(this.stack, stack);
        }

        @Override
        public boolean matches(@Nonnull ItemRequirement otherRequirement) {
            if (otherRequirement instanceof StackMatch) {
                StackMatch pm = (StackMatch)otherRequirement;
                return InventoryUtil.ItemMatches(this.stack, pm.stack);
            }
            return false;
        }
    }

    private static class ItemMatch
    extends ItemRequirement {
        private final Item item;

        private ItemMatch(@Nonnull Item item, int count) {
            super(count);
            this.item = item;
        }

        @Override
        public boolean test(ItemStack stack) {
            return stack.m_41720_() == this.item;
        }

        @Override
        public boolean matches(@Nonnull ItemRequirement otherRequirement) {
            if (otherRequirement instanceof ItemMatch) {
                ItemMatch im = (ItemMatch)otherRequirement;
                return im.item == this.item;
            }
            return false;
        }
    }

    private static class IngredientRequirement
    extends ItemRequirement {
        private final Ingredient ingredient;

        private IngredientRequirement(Ingredient ingredient, int count) {
            super(count);
            this.ingredient = ingredient;
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.ingredient.test(stack);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(@Nonnull ItemRequirement otherRequirement) {
            if (!(otherRequirement instanceof IngredientRequirement)) return false;
            IngredientRequirement other = (IngredientRequirement)otherRequirement;
            if (!other.ingredient.equals(this.ingredient)) return false;
            return true;
        }
    }

    private static class FilterRequirement
    extends ItemRequirement {
        private final ItemStack filterItem;
        private final Predicate<ItemStack> filter;

        private FilterRequirement(ItemStack filterItem, Predicate<ItemStack> filter) {
            super(filterItem.m_41613_());
            this.filter = filter;
            this.filterItem = filterItem.m_41777_();
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.filter.test(stack);
        }

        @Override
        public boolean matches(@Nonnull ItemRequirement otherRequirement) {
            if (otherRequirement instanceof FilterRequirement) {
                FilterRequirement fr = (FilterRequirement)otherRequirement;
                return InventoryUtil.ItemMatches(fr.filterItem, this.filterItem);
            }
            return false;
        }
    }

    public static class MatchingItemsList {
        private final List<ItemRequirement> requirements;
        private final Map<Set<Integer>, List<ItemStack>> validItemsMap = new HashMap<Set<Integer>, List<ItemStack>>();

        public MatchingItemsList(List<ItemRequirement> requirements) {
            this.requirements = ImmutableList.copyOf(requirements);
        }

        public void testContainer(Container container) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                this.testValidItem(container.m_8020_(i));
            }
        }

        public void testContainer(IItemHandler container) {
            for (int i = 0; i < container.getSlots(); ++i) {
                this.testValidItem(container.getStackInSlot(i));
            }
        }

        public void testValidItem(ItemStack stack) {
            HashSet<Integer> matches = new HashSet<Integer>();
            for (int i = 0; i < this.requirements.size(); ++i) {
                ItemRequirement r = this.requirements.get(i);
                if (!r.test(stack)) continue;
                matches.add(i);
            }
            List list = this.validItemsMap.getOrDefault(matches, new ArrayList());
            ItemRequirement.addToList(list, stack);
            this.validItemsMap.put(matches, list);
        }

        public int getDuplicateMatches() {
            int count = 0;
            for (Set<Integer> key : this.validItemsMap.keySet()) {
                if (key.size() <= 1) continue;
                count += ItemRequirement.getTotalCount(this.validItemsMap.get(key));
            }
            return count;
        }

        public int getUniqueMatches(int requrementIndex) {
            for (Set<Integer> key : this.validItemsMap.keySet()) {
                if (!key.contains(requrementIndex) || key.size() != 1) continue;
                return ItemRequirement.getTotalCount(this.validItemsMap.get(key));
            }
            return 0;
        }

        public int getMatches(int requirementIndex) {
            int count = 0;
            for (Set<Integer> key : this.validItemsMap.keySet()) {
                if (!key.contains(requirementIndex)) continue;
                count += ItemRequirement.getTotalCount(this.validItemsMap.get(key));
            }
            return count;
        }

        @Nullable
        public List<ItemStack> getRandomItems(boolean removeFromList) {
            List<RequirementEntry> data = RequirementEntry.create(this.requirements);
            for (RequirementEntry entry : data) {
                int required = removeFromList ? entry.requirement.getCount() : 1;
                entry.totalMatches = this.getMatches(entry.index);
                if (entry.totalMatches < required) {
                    return null;
                }
                int uniqueRequired = removeFromList ? required : 0;
                entry.uniqueMatches = this.getUniqueMatches(entry.index);
                if (entry.uniqueMatches >= uniqueRequired) continue;
                entry.requiredDupes = uniqueRequired - entry.uniqueMatches;
            }
            for (RequirementEntry entry : data) {
                if (entry.requiredDupes <= 0) continue;
                int dupesInvolvingThis = 0;
                ArrayList<Set<Integer>> relevantKeys = new ArrayList<Set<Integer>>();
                for (Set<Integer> set : this.validItemsMap.keySet()) {
                    if (!set.contains(entry.index) || set.size() <= 1) continue;
                    dupesInvolvingThis += ItemRequirement.getTotalCount(this.validItemsMap.get(set));
                    relevantKeys.add(set);
                }
                if (dupesInvolvingThis < entry.requiredDupes) {
                    return null;
                }
                int flexibleDupes = dupesInvolvingThis - entry.requiredDupes;
                for (Set set : relevantKeys) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        int index = (Integer)iterator.next();
                        if (index == entry.index) continue;
                        RequirementEntry e = data.get(index);
                        e.dupeRestrictions.put(entry.index, flexibleDupes);
                        int newTotal = e.totalDupeAllotment(data.size());
                        if (newTotal >= e.requiredDupes) continue;
                        return null;
                    }
                }
            }
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            for (RequirementEntry entry : data) {
                int count = entry.requirement.getCount();
                while (count-- > 0) {
                    ArrayList<Pair> validEntries = new ArrayList<Pair>();
                    for (Set<Integer> set : this.validItemsMap.keySet()) {
                        if (!set.contains(entry.index)) continue;
                        boolean allowed = true;
                        for (int other : set) {
                            if (entry.allowedConflict(other)) continue;
                            allowed = false;
                        }
                        if (!allowed) continue;
                        validEntries.add(Pair.of(set, this.validItemsMap.get(set)));
                    }
                    Pair pair = ListUtil.weightedRandomItemFromList(validEntries, p -> ItemRequirement.getTotalCount((List)p.getSecond()));
                    if (pair != null) {
                        ItemStack itemStack = ListUtil.weightedRandomItemFromList((List)pair.getSecond(), ItemStack::m_41613_);
                        if (itemStack == null) {
                            return null;
                        }
                        ItemStack itemStack2 = itemStack.m_255036_(1);
                        ItemRequirement.addToList(results, itemStack2);
                        if (removeFromList) {
                            ItemRequirement.removeFromList((List)pair.getSecond(), itemStack2);
                            if (((List)pair.getSecond()).isEmpty()) {
                                this.validItemsMap.remove(pair.getFirst());
                            }
                        }
                        entry.afterDupeConsumption((Set)pair.getFirst());
                        continue;
                    }
                    return null;
                }
            }
            return results;
        }

        private static class RequirementEntry {
            final ItemRequirement requirement;
            final int index;
            Map<Integer, Integer> dupeRestrictions = new HashMap<Integer, Integer>();
            int requiredDupes = 0;
            int totalMatches = 0;
            int uniqueMatches = 0;

            private RequirementEntry(ItemRequirement requirement, int index) {
                this.requirement = requirement;
                this.index = index;
            }

            private boolean allowedConflict(int otherIndex) {
                return otherIndex == this.index || this.getRestriction(otherIndex) > 0;
            }

            private int getRestriction(int otherIndex) {
                return this.dupeRestrictions.getOrDefault(otherIndex, Integer.MAX_VALUE);
            }

            private void afterDupeConsumption(Set<Integer> key) {
                for (int index : key) {
                    if (index == this.index || !this.dupeRestrictions.containsKey(index)) continue;
                    this.dupeRestrictions.put(index, this.dupeRestrictions.get(index) - 1);
                }
            }

            private int totalDupeAllotment(int totalSize) {
                int count = 0;
                for (int i = 0; i < totalSize; ++i) {
                    if (i == this.index) continue;
                    if (this.dupeRestrictions.containsKey(i)) {
                        count += this.dupeRestrictions.get(i).intValue();
                        continue;
                    }
                    return Integer.MAX_VALUE;
                }
                return count;
            }

            static List<RequirementEntry> create(List<ItemRequirement> list) {
                ArrayList<RequirementEntry> result = new ArrayList<RequirementEntry>();
                for (int i = 0; i < list.size(); ++i) {
                    result.add(new RequirementEntry(list.get(i), i));
                }
                return ImmutableList.copyOf(result);
            }
        }
    }
}

