/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.reiplugin.ticket_station;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.common.crafting.MasterTicketRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.durability.DurabilityData;
import io.github.lightman314.lightmanscurrency.integration.reiplugin.ticket_station.TicketStationCategory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.Tags;

public class TicketStationDisplay
implements Display {
    protected List<EntryIngredient> inputs;
    protected List<EntryIngredient> outputs;
    protected Optional<ResourceLocation> location;
    public final boolean codeInputs;
    public final DurabilityData durabilityData;

    public TicketStationDisplay(TicketStationRecipe recipe) {
        this.inputs = Lists.newArrayList((Object[])new EntryIngredient[]{TicketStationDisplay.getModifierInput(recipe), EntryIngredients.ofIngredient((Ingredient)recipe.getIngredient())});
        this.outputs = Collections.singletonList(EntryIngredients.of((ItemStack)recipe.exampleResult()));
        this.location = Optional.of(recipe.m_6423_());
        this.codeInputs = recipe.requiredCodeInput();
        this.durabilityData = recipe.getDurabilityData();
    }

    private static EntryIngredient getModifierInput(@Nonnull TicketStationRecipe recipe) {
        if (recipe instanceof MasterTicketRecipe) {
            MasterTicketRecipe mtr = (MasterTicketRecipe)recipe;
            return EntryIngredients.ofIngredient((Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.DYES));
        }
        if (recipe instanceof TicketRecipe) {
            TicketRecipe tr = (TicketRecipe)recipe;
            return EntryIngredients.ofIngredient((Ingredient)tr.getMasterIngredient());
        }
        return EntryIngredients.ofItemStacks(recipe.jeiModifierList());
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return TicketStationCategory.ID;
    }
}

