/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.item;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.InputTraderPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.item.ItemTradeWrapper;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;

public class ItemTraderPeripheral
extends InputTraderPeripheral<ItemTraderBlockEntity, ItemTraderData> {
    public ItemTraderPeripheral(ItemTraderBlockEntity blockEntity) {
        super(blockEntity);
    }

    public ItemTraderPeripheral(ItemTraderData trader) {
        super(trader);
    }

    public String getType() {
        return "lc_trader_item";
    }

    @LuaFunction(mainThread=true)
    public int getStorageStackLimit() throws LuaException {
        return ((ItemTraderData)this.getTrader()).getStorageStackLimit();
    }

    @LuaFunction(mainThread=true)
    public LCLuaTable[] getStorageItems() throws LuaException {
        TraderItemStorage storage = ((ItemTraderData)this.getTrader()).getStorage();
        ArrayList<LCLuaTable> list = new ArrayList<LCLuaTable>();
        for (ItemStack item : new ArrayList<ItemStack>(storage.getContents())) {
            list.add(LCLuaTable.fromTag(InventoryUtil.saveItemNoLimits(item)));
        }
        return (LCLuaTable[])list.toArray(LCLuaTable[]::new);
    }

    private Supplier<ItemTradeData> tradeSource(int index) {
        return () -> {
            ItemTraderData trader = (ItemTraderData)this.safeGetTrader();
            if (trader != null && index >= 0 && index < trader.getTradeCount()) {
                return trader.getTrade(index);
            }
            return null;
        };
    }

    @Override
    @Nullable
    protected IPeripheral wrapTrade(TradeData trade) throws LuaException {
        int index = ((ItemTraderData)this.getTrader()).indexOfTrade(trade);
        return new ItemTradeWrapper(this.tradeSource(index), this::safeGetTrader);
    }

    @LuaFunction(mainThread=true)
    public ItemTradeWrapper[] getTrades() throws LuaException {
        ArrayList<ItemTradeWrapper> list = new ArrayList<ItemTradeWrapper>();
        ItemTraderData trader = (ItemTraderData)this.getTrader();
        for (int i = 0; i < trader.getTradeCount(); ++i) {
            list.add(new ItemTradeWrapper(this.tradeSource(i), this::safeGetTrader));
        }
        return (ItemTradeWrapper[])list.toArray(ItemTradeWrapper[]::new);
    }
}

