/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.AccessTrackingPeripheral;
import java.util.Set;
import java.util.function.Supplier;

public abstract class TradeWrapper<T extends TradeData>
extends AccessTrackingPeripheral {
    public static final String BASE_TYPE = "lc_trade";
    private final Supplier<T> source;
    private final Supplier<TraderData> trader;

    public TradeWrapper(Supplier<T> tradeSource, Supplier<TraderData> trader) {
        this.source = tradeSource;
        this.trader = trader;
    }

    public static TradeWrapper<TradeData> createSimple(Supplier<TradeData> tradeSource, Supplier<TraderData> trader) {
        return new Simple(tradeSource, trader);
    }

    public Set<String> getAdditionalTypes() {
        return Set.of(BASE_TYPE);
    }

    protected final T getTrade() throws LuaException {
        TradeData trade = (TradeData)this.source.get();
        if (trade == null) {
            throw new LuaException("An unexpected error occurred trying to access the trade!");
        }
        return (T)trade;
    }

    @LuaFunction(mainThread=true)
    public boolean isValid() {
        try {
            return ((TradeData)this.getTrade()).isValid();
        }
        catch (LuaException exception) {
            return false;
        }
    }

    @LuaFunction(mainThread=true)
    public LCLuaTable getPrice() throws LuaException {
        LCLuaTable table = new LCLuaTable();
        return LCLuaTable.fromMoney(((TradeData)this.getTrade()).getCost());
    }

    @LuaFunction(mainThread=true)
    public int getStock() throws LuaException {
        TraderData trader = this.trader.get();
        if (trader == null) {
            throw new LuaException("An unexpected error occurred trying to access the trader!");
        }
        T trade = this.getTrade();
        return ((TradeData)trade).getStock(TradeContext.createStorageMode(trader));
    }

    @LuaFunction(mainThread=true)
    public String getDirection() throws LuaException {
        return ((TradeData)this.getTrade()).getTradeDirection().toString();
    }

    @LuaFunction(mainThread=true)
    public boolean isSale() throws LuaException {
        return ((TradeData)this.getTrade()).getTradeDirection() == TradeDirection.SALE;
    }

    @LuaFunction(mainThread=true)
    public boolean isPurchase() throws LuaException {
        return ((TradeData)this.getTrade()).getTradeDirection() == TradeDirection.PURCHASE;
    }

    @LuaFunction(mainThread=true)
    public boolean isBarter() throws LuaException {
        return ((TradeData)this.getTrade()).getTradeDirection() == TradeDirection.BARTER;
    }

    @LuaFunction(mainThread=true)
    public boolean isOther() throws LuaException {
        return ((TradeData)this.getTrade()).getTradeDirection() == TradeDirection.OTHER;
    }

    private static final class Simple
    extends TradeWrapper<TradeData> {
        public Simple(Supplier<TradeData> tradeSource, Supplier<TraderData> trader) {
            super(tradeSource, trader);
        }

        public String getType() {
            return TradeWrapper.BASE_TYPE;
        }

        @Override
        public Set<String> getAdditionalTypes() {
            return Set.of();
        }
    }
}

