/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.AttachedComputerSet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import net.minecraftforge.common.MinecraftForge;

public abstract class LCPeripheral
implements IPeripheral {
    protected final AttachedComputerSet computers = new AttachedComputerSet();

    @LuaFunction
    public String[] getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(this.getType());
        types.addAll(this.getAdditionalTypes());
        return (String[])types.toArray(String[]::new);
    }

    protected boolean eventListener() {
        return false;
    }

    public void attach(IComputerAccess computer) {
        boolean wasEmpty = !this.computers.hasComputers();
        this.computers.add(computer);
        if (wasEmpty && this.eventListener()) {
            this.onFirstAttachment();
        }
    }

    protected void onFirstAttachment() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
        if (this.eventListener() && !this.computers.hasComputers()) {
            this.onLastDetachment();
        }
    }

    protected void onLastDetachment() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }
}

