/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant.listings;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class EnchantedBookForCoinsTrade
implements VillagerTrades.ItemListing {
    public static final ResourceLocation TYPE = VersionUtil.lcResource("enchanted_book_for_coins");
    public static final Serializer SERIALIZER = new Serializer();
    protected final Item baseCoin;
    protected final int baseCoinCount;
    protected final int maxTrades;
    protected final int xp;
    protected final float priceMult;
    private static final Item BASE_COIN = ModItems.COIN_GOLD.get();
    private static final int BASE_COIN_COUNT = 5;

    public EnchantedBookForCoinsTrade(int xp) {
        this(BASE_COIN, 5, 12, xp, 0.05f);
    }

    public EnchantedBookForCoinsTrade(Item baseCoin, int baseCoinCount, int maxTrades, int xp, float priceMult) {
        this.xp = xp;
        this.baseCoin = baseCoin;
        this.baseCoinCount = baseCoinCount;
        this.maxTrades = maxTrades;
        this.priceMult = priceMult;
    }

    public MerchantOffer m_213663_(@NotNull Entity trader, RandomSource rand) {
        MoneyValue v;
        List<Enchantment> list = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(Enchantment::m_6594_).toList();
        Enchantment enchantment = list.get(rand.m_188503_(list.size()));
        int level = 1;
        if (enchantment.m_6586_() > 0) {
            level = rand.m_188503_(enchantment.m_6586_()) + 1;
        } else {
            LightmansCurrency.LogError("Enchantment of type '" + ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment) + "' has a max enchantment level of " + enchantment.m_6586_() + ". Unable to properly randomize the enchantment level for a villager trade. Will default to a level 1 enchantment.");
        }
        ItemStack itemstack = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, level));
        ChainData chain = CoinAPI.API.ChainDataOfCoin(this.baseCoin);
        if (chain == null) {
            LightmansCurrency.LogWarning("Book for coin trade failed as '" + new ItemStack((ItemLike)this.baseCoin).m_41786_().getString() + "' is not a registered coin!");
            return null;
        }
        long baseValue = chain.getCoreValue(this.baseCoin) * (long)this.baseCoinCount;
        int valueRandom = rand.m_188503_(5 + level * 10);
        long value = baseValue + baseValue * (long)(level + valueRandom);
        if (enchantment.m_6591_()) {
            value *= 2L;
        }
        if (!((v = CoinValue.fromNumber(chain.chain, value)) instanceof CoinValue)) {
            return null;
        }
        CoinValue coinValue = (CoinValue)v;
        List<ItemStack> coins = coinValue.getAsSeperatedItemList();
        ItemStack price1 = ItemStack.f_41583_;
        ItemStack price2 = ItemStack.f_41583_;
        if (!coins.isEmpty()) {
            price1 = coins.get(0);
        }
        if (coins.size() > 1) {
            price2 = coins.get(1);
        }
        LightmansCurrency.LogDebug("EnchantedBookForCoinsTrade.getOffer() -> \nbaseValue=" + baseValue + "\ncoinValue=" + coinValue + "\nlevel=" + level + "\nvalueRandom=" + valueRandom + "\nvalue=" + value + "\nprice1=" + price1.m_41613_() + "x" + ForgeRegistries.ITEMS.getKey((Object)price1.m_41720_()) + "\nprice2=" + price2.m_41613_() + "x" + ForgeRegistries.ITEMS.getKey((Object)price2.m_41720_()));
        return new MerchantOffer(price1, price2, itemstack, this.maxTrades, this.xp, this.priceMult);
    }

    public static class Serializer
    implements ItemListingSerializer.IItemListingSerializer,
    ItemListingSerializer.IItemListingDeserializer {
        private Serializer() {
        }

        @Override
        public ResourceLocation getType() {
            return TYPE;
        }

        @Override
        public JsonObject serializeInternal(JsonObject json, VillagerTrades.ItemListing trade) {
            if (trade instanceof EnchantedBookForCoinsTrade) {
                EnchantedBookForCoinsTrade t = (EnchantedBookForCoinsTrade)trade;
                json.addProperty("Coin", ForgeRegistries.ITEMS.getKey((Object)t.baseCoin).toString());
                json.addProperty("StartCoinCount", (Number)t.baseCoinCount);
                json.addProperty("MaxTrades", (Number)t.maxTrades);
                json.addProperty("XP", (Number)t.xp);
                json.addProperty("PriceMult", (Number)Float.valueOf(t.priceMult));
                return json;
            }
            return null;
        }

        @Override
        public VillagerTrades.ItemListing deserialize(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
            Item baseCoin = (Item)ForgeRegistries.ITEMS.getValue(VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"Coin")));
            int baseCoinCount = GsonHelper.m_13927_((JsonObject)json, (String)"StartCoinCount");
            int maxTrades = GsonHelper.m_13927_((JsonObject)json, (String)"MaxTrades");
            int xp = GsonHelper.m_13927_((JsonObject)json, (String)"XP");
            float priceMult = GsonHelper.m_13915_((JsonObject)json, (String)"PriceMult");
            return new EnchantedBookForCoinsTrade(baseCoin, baseCoinCount, maxTrades, xp, priceMult);
        }
    }
}

