/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.util;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.Sprite;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class IconData {
    private static IconData NULL = null;
    private static final Map<ResourceLocation, Function<CompoundTag, IconData>> ICON_TYPES = new HashMap<ResourceLocation, Function<CompoundTag, IconData>>();
    protected final ResourceLocation type;

    @Nonnull
    public static IconData Null() {
        if (NULL == null) {
            NULL = new NullIcon();
        }
        return NULL;
    }

    public static void registerIconType(@Nonnull ResourceLocation type, @Nonnull Function<CompoundTag, IconData> deserializer) {
        if (ICON_TYPES.containsKey(type)) {
            LightmansCurrency.LogDebug("Attempted to register icon of type '" + type + "' twice!");
            return;
        }
        ICON_TYPES.put(type, deserializer);
    }

    public static void registerDefaultIcons() {
        if (ICON_TYPES.containsKey(NullIcon.TYPE)) {
            LightmansCurrency.LogWarning("Attempted to register the default icons twice!");
            return;
        }
        IconData.registerIconType(NullIcon.TYPE, c -> NULL);
        IconData.registerIconType(ItemIcon.TYPE, ItemIcon::loadItem);
        IconData.registerIconType(ImageIcon.TYPE, ImageIcon::loadImage);
        IconData.registerIconType(TextIcon.TYPE, TextIcon::loadText);
        IconData.registerIconType(NumberIcon.TYPE, NumberIcon::loadNumber);
        IconData.registerIconType(MultiIcon.TYPE, MultiIcon::loadMulti);
    }

    @Nullable
    public static IconData load(@Nonnull CompoundTag tag) {
        ResourceLocation type;
        if (tag.m_128441_("Type") && ICON_TYPES.containsKey(type = VersionUtil.parseResource(tag.m_128461_("Type")))) {
            return ICON_TYPES.get(type).apply(tag);
        }
        return null;
    }

    public final boolean isNull() {
        return this instanceof NullIcon;
    }

    protected IconData(@Nonnull ResourceLocation type) {
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void render(@Nonnull EasyGuiGraphics gui, @Nonnull ScreenPosition pos) {
        this.render(gui, pos.x, pos.y);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void render(@Nonnull EasyGuiGraphics var1, int var2, int var3);

    @Nonnull
    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        tag.m_128359_("Type", this.type.toString());
        return tag;
    }

    protected abstract void saveAdditional(@Nonnull CompoundTag var1);

    public static IconData of(@Nonnull ItemLike item) {
        return IconData.of(new ItemStack(item));
    }

    public static IconData of(@Nonnull ItemLike item, @Nullable String countTextOverride) {
        return IconData.of(new ItemStack(item), countTextOverride);
    }

    public static IconData of(@Nonnull Supplier<? extends ItemLike> item) {
        return IconData.of(new ItemStack(item.get()));
    }

    public static IconData of(@Nonnull Supplier<? extends ItemLike> item, @Nullable String countTextOverride) {
        return IconData.of(new ItemStack(item.get()), countTextOverride);
    }

    public static IconData of(@Nonnull ItemStack iconStack) {
        return IconData.of(iconStack, null);
    }

    public static IconData of(@Nonnull ItemStack iconStack, @Nullable String countTextOverride) {
        return iconStack.m_41619_() ? IconData.Null() : new ItemIcon(iconStack, countTextOverride);
    }

    public static IconData of(@Nonnull ResourceLocation iconImage, int u, int v) {
        return new ImageIcon(Sprite.SimpleSprite(iconImage, u, v, 16, 16));
    }

    public static IconData of(@Nonnull Sprite sprite) {
        return new ImageIcon(sprite);
    }

    public static IconData of(@Nonnull Component iconText) {
        return new TextIcon(iconText, 0xFFFFFF);
    }

    public static IconData of(@Nonnull Component iconText, int textColor) {
        return new TextIcon(iconText, textColor);
    }

    public static IconData of(IconData ... icons) {
        return new MultiIcon(Lists.newArrayList((Object[])icons));
    }

    private static class NullIcon
    extends IconData {
        private static final ResourceLocation TYPE = VersionUtil.lcResource("null");

        private NullIcon() {
            super(TYPE);
        }

        @Override
        public void render(@Nonnull EasyGuiGraphics gui, int x, int y) {
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag tag) {
        }
    }

    private static class ItemIcon
    extends IconData {
        private static final ResourceLocation TYPE = VersionUtil.lcResource("item");
        private final ItemStack iconStack;
        private final String countTextOverride;

        private ItemIcon(ItemStack iconStack, @Nullable String countTextOverride) {
            super(TYPE);
            this.iconStack = iconStack;
            this.countTextOverride = countTextOverride;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(@Nonnull EasyGuiGraphics gui, int x, int y) {
            gui.renderItem(this.iconStack, x, y, this.countTextOverride);
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag tag) {
            tag.m_128365_("Item", (Tag)this.iconStack.m_41739_(new CompoundTag()));
            if (this.countTextOverride != null) {
                tag.m_128359_("Text", this.countTextOverride);
            }
        }

        private static IconData loadItem(@Nonnull CompoundTag tag) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
            String countText = null;
            if (tag.m_128441_("Text")) {
                countText = tag.m_128461_("Text");
            }
            return new ItemIcon(stack, countText);
        }
    }

    private static class ImageIcon
    extends IconData {
        private static final ResourceLocation TYPE = VersionUtil.lcResource("sprite");
        private final Sprite sprite;

        private ImageIcon(Sprite sprite) {
            super(TYPE);
            this.sprite = sprite;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(@Nonnull EasyGuiGraphics gui, int x, int y) {
            gui.blitSprite(this.sprite, x, y);
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag tag) {
            tag.m_128359_("Image", this.sprite.image.toString());
            tag.m_128405_("u", this.sprite.u);
            tag.m_128405_("v", this.sprite.v);
            tag.m_128405_("w", this.sprite.width);
            tag.m_128405_("h", this.sprite.height);
            tag.m_128405_("hou", this.sprite.hoverOffsetU);
            tag.m_128405_("hov", this.sprite.hoverOffsetV);
        }

        private static IconData loadImage(@Nonnull CompoundTag tag) {
            ResourceLocation image = VersionUtil.parseResource(tag.m_128461_("Image"));
            int u = tag.m_128451_("u");
            int v = tag.m_128451_("v");
            int w = tag.m_128451_("w");
            int h = tag.m_128451_("h");
            int hou = tag.m_128451_("hou");
            int hov = tag.m_128451_("hov");
            return new ImageIcon(new Sprite(image, u, v, w, h, hou, hov));
        }
    }

    private static class TextIcon
    extends IconData {
        private static final ResourceLocation TYPE = VersionUtil.lcResource("text");
        private final Component iconText;
        private final int textColor;

        private TextIcon(Component iconText, int textColor) {
            super(TYPE);
            this.iconText = iconText;
            this.textColor = textColor;
        }

        @Override
        public void render(@Nonnull EasyGuiGraphics gui, int x, int y) {
            int xPos = x + 8 - gui.font.m_92852_((FormattedText)this.iconText) / 2;
            Objects.requireNonNull(gui.font);
            int yPos = y + (16 - 9) / 2;
            gui.drawShadowed(this.iconText, xPos, yPos, this.textColor);
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag tag) {
            tag.m_128359_("Text", Component.Serializer.m_130703_((Component)this.iconText));
            tag.m_128405_("Color", this.textColor);
        }

        private static IconData loadText(@Nonnull CompoundTag tag) {
            MutableComponent text = Component.Serializer.m_130701_((String)tag.m_128461_("Text"));
            int color = tag.m_128451_("Color");
            return new TextIcon((Component)text, color);
        }
    }

    private static class NumberIcon
    extends IconData {
        private static final ResourceLocation TYPE = VersionUtil.lcResource("number_icon");
        private final int number;

        private NumberIcon(int number) {
            super(TYPE);
            this.number = number;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(@Nonnull EasyGuiGraphics gui, int x, int y) {
            String text = String.valueOf(this.number);
            int width = gui.font.m_92895_(text);
            gui.drawShadowed(text, x + 17 - width, y + 9, 0xFFFFFF);
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag tag) {
            tag.m_128405_("Number", this.number);
        }

        private static IconData loadNumber(@Nonnull CompoundTag tag) {
            return new NumberIcon(tag.m_128451_("Number"));
        }
    }

    private static class MultiIcon
    extends IconData {
        private static final ResourceLocation TYPE = VersionUtil.lcResource("multi_icon");
        private final List<IconData> icons;

        private MultiIcon(List<IconData> icons) {
            super(TYPE);
            this.icons = icons;
        }

        @Override
        public void render(@Nonnull EasyGuiGraphics gui, int x, int y) {
            for (IconData icon : this.icons) {
                icon.render(gui, x, y);
            }
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag tag) {
            ListTag children = new ListTag();
            for (IconData icon : this.icons) {
                children.add((Object)icon.save());
            }
            tag.m_128365_("Children", (Tag)children);
        }

        private static IconData loadMulti(@Nonnull CompoundTag tag) {
            ArrayList<IconData> result = new ArrayList<IconData>();
            ListTag children = tag.m_128437_("Children", 10);
            for (int i = 0; i < children.size(); ++i) {
                IconData icon = MultiIcon.load(children.m_128728_(i));
                if (icon == null) continue;
                result.add(icon);
            }
            return new MultiIcon(result);
        }
    }
}

