/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.tradedata;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.filter.FilterAPI;
import io.github.lightman314.lightmanscurrency.api.filter.IItemTradeFilter;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.ProductComparisonResult;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.client.ItemTradeButtonRenderer;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.ItemRequirement;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTradeData
extends TradeData {
    private static final Map<ResourceLocation, Function<Boolean, ItemTradeData>> typeRegistry;
    private static final ResourceLocation DEFAULT_TYPE;
    protected final ResourceLocation type;
    ItemTradeRestriction restriction = ItemTradeRestriction.NONE;
    SimpleContainer items = new SimpleContainer(4);
    final List<Boolean> enforceNBT = Lists.newArrayList((Object[])new Boolean[]{true, true, true, true});
    TradeDirection tradeType = TradeDirection.SALE;
    String customName1 = "";
    String customName2 = "";

    public static void registerCustomItemTrade(ResourceLocation typeID, Function<Boolean, ItemTradeData> builder) {
        if (typeRegistry.containsKey(typeID)) {
            LightmansCurrency.LogWarning("Duplicate Item Trade Type '" + typeID + " was registered!");
            return;
        }
        typeRegistry.put(typeID, builder);
    }

    @Nonnull
    public static TradeDirection getNextInCycle(@Nonnull TradeDirection direction) {
        int index = direction.index + 1;
        if (index > TradeDirection.BARTER.index) {
            index = 0;
        }
        return TradeDirection.fromIndex(index);
    }

    private ItemTradeData(boolean validateRules) {
        this(DEFAULT_TYPE, validateRules);
    }

    public ItemTradeData(ResourceLocation type, boolean validateRules) {
        super(validateRules);
        this.type = type;
        this.resetNBTList();
    }

    public static ItemTradeData create(boolean validateRules) {
        return new ItemTradeData(validateRules);
    }

    private void resetNBTList() {
        for (int i = 0; i < 4; ++i) {
            this.enforceNBT.set(i, true);
        }
    }

    public ItemStack getSellItem(int index) {
        if (index >= 0 && index < 2) {
            return this.getRestriction().modifySellItem(this.items.m_8020_(index).m_41777_(), this.getCustomName(index), this, index);
        }
        return ItemStack.f_41583_;
    }

    public List<ItemStack> getRandomSellItems(ItemTraderData trader) {
        return this.getRestriction().getRandomSellItems(trader, this);
    }

    public ItemStack getBarterItem(int index) {
        if (index >= 0 && index < 2) {
            return this.items.m_8020_(index + 2).m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getItem(int index) {
        if (index >= 0 && index < 2) {
            return this.getSellItem(index);
        }
        if (index >= 2 && index < 4) {
            return this.getBarterItem(index - 2);
        }
        return ItemStack.f_41583_;
    }

    public final ItemStack getActualItem(int index) {
        if (index >= 0 && index < 4) {
            return this.items.m_8020_(index);
        }
        return ItemStack.f_41583_;
    }

    public void setItem(ItemStack itemStack, int index) {
        if (index >= 0 && index < 4) {
            if (index < 2) {
                if (FilterAPI.itemHasFilter(itemStack) && this.allowFilters()) {
                    this.items.m_6836_(index, itemStack);
                } else if (this.getRestriction().allowSellItem(itemStack) || itemStack.m_41619_()) {
                    this.items.m_6836_(index, this.getRestriction().filterSellItem(itemStack).m_41777_());
                }
            } else {
                this.items.m_6836_(index, itemStack.m_41777_());
            }
        } else {
            LightmansCurrency.LogError("Cannot define the item trades item at index " + index + ". Must be between 0-3!");
        }
    }

    public boolean isNotStrict(int slot) {
        return !this.getEnforceNBT(slot) || FilterAPI.itemHasFilter(this.getActualItem(slot));
    }

    public boolean alwaysEnforcesNBT(int slot) {
        return this.getRestriction().alwaysEnforceNBT(slot);
    }

    public boolean getEnforceNBT(int slot) {
        if (slot >= 0 && slot < 4) {
            return this.enforceNBT.get(slot) != false || this.alwaysEnforcesNBT(slot);
        }
        return true;
    }

    public void setEnforceNBT(int slot, boolean newValue) {
        if (slot >= 0 && slot < 4) {
            this.enforceNBT.set(slot, newValue || this.alwaysEnforcesNBT(slot));
        }
    }

    public ItemRequirement getItemRequirement(int slot) {
        if (slot >= 0 && slot < 4) {
            Predicate<ItemStack> predicate;
            ItemStack rawItem = this.getActualItem(slot);
            IItemTradeFilter filter = FilterAPI.tryGetFilter(rawItem);
            if (filter != null && (slot >= 2 || this.allowFilters()) && (predicate = filter.getFilter(rawItem)) != null) {
                if (slot < 2) {
                    predicate = this.getRestriction().modifyFilter(predicate);
                }
                return ItemRequirement.fromFilter(rawItem, predicate);
            }
            ItemStack item = this.getItem(slot);
            if (this.getEnforceNBT(slot)) {
                return ItemRequirement.of(item);
            }
            return ItemRequirement.ofItemNoNBT(item);
        }
        return ItemRequirement.getNull();
    }

    public boolean allowItemInStorage(ItemStack item) {
        int max = this.isBarter() ? 4 : 2;
        for (int i = 0; i < max; ++i) {
            if (!this.getItemRequirement(i).test(item)) continue;
            return true;
        }
        return this.getRestriction().allowExtraItemInStorage(item);
    }

    public boolean shouldStorageItemBeSaved(ItemStack item) {
        if ((this.isSale() || this.isBarter()) && this.isValid()) {
            for (int i = 0; i < 2; ++i) {
                if (!this.isNotStrict(i) || !this.getItemRequirement(i).test(item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasCustomName(int index) {
        return !this.getCustomName(index).isEmpty();
    }

    public String getCustomName(int index) {
        return switch (index) {
            case 0 -> this.customName1;
            case 1 -> this.customName2;
            default -> "";
        };
    }

    public void setCustomName(int index, String customName) {
        switch (index) {
            case 0: {
                this.customName1 = customName;
                break;
            }
            case 1: {
                this.customName2 = customName;
            }
        }
    }

    @Override
    public TradeDirection getTradeDirection() {
        return this.tradeType;
    }

    @Override
    public void setTradeDirection(TradeDirection direction) {
        if (direction == TradeDirection.OTHER) {
            return;
        }
        this.setTradeType(direction);
    }

    public boolean isSale() {
        return this.tradeType == TradeDirection.SALE;
    }

    public boolean isPurchase() {
        return this.tradeType == TradeDirection.PURCHASE;
    }

    public boolean isBarter() {
        return this.tradeType == TradeDirection.BARTER;
    }

    public void setTradeType(TradeDirection tradeDirection) {
        this.tradeType = tradeDirection;
        this.validateRuleStates();
    }

    @Nonnull
    public ItemTradeRestriction getRestriction() {
        return this.restriction;
    }

    public final boolean allowFilters() {
        return this.getRestriction().allowFilters();
    }

    public void setRestriction(ItemTradeRestriction restriction) {
        this.restriction = restriction;
    }

    @Override
    public boolean isValid() {
        if (this.tradeType == TradeDirection.BARTER) {
            return this.sellItemsDefined() && this.barterItemsDefined();
        }
        return super.isValid() && this.sellItemsDefined();
    }

    public boolean sellItemsDefined() {
        return this.getItemRequirement(0).isValid() || this.getItemRequirement(1).isValid();
    }

    public boolean barterItemsDefined() {
        return this.getItemRequirement(2).isValid() || this.getItemRequirement(3).isValid();
    }

    public boolean hasStock(ItemTraderData trader) {
        if (!this.sellItemsDefined()) {
            return false;
        }
        return this.stockCount(trader) > 0;
    }

    public boolean hasSpace(ItemTraderData trader, List<ItemStack> collectableItems) {
        return switch (this.tradeType) {
            case TradeDirection.PURCHASE, TradeDirection.BARTER -> trader.getStorage().canFitItems(collectableItems);
            default -> true;
        };
    }

    public int stockCount(ItemTraderData trader) {
        if (!this.sellItemsDefined()) {
            return 0;
        }
        if (trader.isCreative()) {
            return 1;
        }
        if (this.tradeType == TradeDirection.PURCHASE) {
            return this.stockCountOfCost(trader);
        }
        if (this.tradeType == TradeDirection.SALE || this.tradeType == TradeDirection.BARTER) {
            return this.getRestriction().getSaleStock(trader.getStorage(), this);
        }
        return 0;
    }

    @Override
    public int getStock(@Nonnull TradeContext context) {
        TraderData traderData;
        if (!this.sellItemsDefined()) {
            return 0;
        }
        if (!context.hasTrader() || !((traderData = context.getTrader()) instanceof ItemTraderData)) {
            return 0;
        }
        ItemTraderData trader = (ItemTraderData)traderData;
        if (trader.isCreative()) {
            return 1;
        }
        if (this.tradeType == TradeDirection.PURCHASE) {
            return this.stockCountOfCost(context);
        }
        if (this.tradeType == TradeDirection.SALE || this.tradeType == TradeDirection.BARTER) {
            return this.getRestriction().getSaleStock(trader.getStorage(), this);
        }
        return 0;
    }

    public boolean canAfford(TradeContext context) {
        if (this.isSale()) {
            return context.hasFunds(this.getCost(context));
        }
        if (this.isPurchase()) {
            return context.hasItems(this.getItemRequirement(0), this.getItemRequirement(1));
        }
        if (this.isBarter()) {
            return context.hasItems(this.getItemRequirement(2), this.getItemRequirement(3));
        }
        return false;
    }

    public void RemoveItemsFromStorage(TraderItemStorage storage, List<ItemStack> soldItems) {
        this.getRestriction().removeItemsFromStorage(storage, soldItems);
    }

    @Override
    public CompoundTag getAsNBT() {
        CompoundTag tradeNBT = super.getAsNBT();
        tradeNBT.m_128359_("Type", this.type.toString());
        InventoryUtil.saveAllItems("Items", tradeNBT, (Container)this.items);
        tradeNBT.m_128359_("TradeDirection", this.tradeType.name());
        tradeNBT.m_128359_("CustomName1", this.customName1);
        tradeNBT.m_128359_("CustomName2", this.customName2);
        ArrayList<Integer> ignoreNBTSlots = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            if (this.getEnforceNBT(i)) continue;
            ignoreNBTSlots.add(i);
        }
        if (!ignoreNBTSlots.isEmpty()) {
            tradeNBT.m_128408_("IgnoreNBT", ignoreNBTSlots);
        }
        return tradeNBT;
    }

    public void saveAdditionalSettings(SavedSettingData.MutableNodeAccess node) {
    }

    public static void saveAllData(CompoundTag nbt, List<ItemTradeData> data) {
        ItemTradeData.saveAllData(nbt, data, "Trades");
    }

    public static void saveAllData(CompoundTag nbt, List<ItemTradeData> data, String key) {
        ListTag listNBT = new ListTag();
        for (ItemTradeData datum : data) {
            listNBT.add((Object)datum.getAsNBT());
        }
        nbt.m_128365_(key, (Tag)listNBT);
    }

    public static ItemTradeData loadData(CompoundTag compound, Supplier<ItemTradeData> builder) {
        ItemTradeData trade = builder.get();
        trade.loadFromNBT(compound);
        return trade;
    }

    public static ItemTradeData loadOfUnknownType(CompoundTag compoundTag, boolean validateRules) {
        ResourceLocation type;
        Function<Boolean, ItemTradeData> temp = ItemTradeData::new;
        if (compoundTag.m_128441_("Type") && typeRegistry.containsKey(type = VersionUtil.parseResource(compoundTag.m_128461_("Type")))) {
            temp = typeRegistry.get(type);
        }
        Function<Boolean, ItemTradeData> builder = temp;
        return ItemTradeData.loadData(compoundTag, () -> (ItemTradeData)builder.apply(validateRules));
    }

    public static List<ItemTradeData> loadAllData(CompoundTag nbt, Supplier<ItemTradeData> builder) {
        return ItemTradeData.loadAllData("Trades", nbt, builder);
    }

    public static List<ItemTradeData> loadAllData(String key, CompoundTag compound, Supplier<ItemTradeData> builder) {
        ArrayList<ItemTradeData> data = new ArrayList<ItemTradeData>();
        ListTag listNBT = compound.m_128437_(key, 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            data.add(ItemTradeData.loadData(listNBT.m_128728_(i), builder));
        }
        return data;
    }

    @Override
    public void loadFromNBT(CompoundTag nbt) {
        super.loadFromNBT(nbt);
        if (nbt.m_128425_("Items", 9)) {
            this.items = InventoryUtil.loadAllItems("Items", nbt, 4);
        }
        this.tradeType = nbt.m_128425_("TradeDirection", 8) ? ItemTradeData.loadTradeType(nbt.m_128461_("TradeDirection")) : TradeDirection.SALE;
        this.customName1 = nbt.m_128441_("CustomName1") ? nbt.m_128461_("CustomName1") : (nbt.m_128441_("CustomName") ? nbt.m_128461_("CustomName") : "");
        this.customName2 = nbt.m_128441_("CustomName2") ? nbt.m_128461_("CustomName2") : "";
        this.resetNBTList();
        if (nbt.m_128441_("IgnoreNBT")) {
            for (int i : nbt.m_128465_("IgnoreNBT")) {
                if (i < 0 || i >= this.enforceNBT.size()) continue;
                this.enforceNBT.set(i, false);
            }
        }
    }

    public void loadAdditionalSettings(SavedSettingData.NodeAccess node) {
    }

    public static TradeDirection loadTradeType(String name) {
        TradeDirection value = TradeDirection.SALE;
        try {
            value = TradeDirection.valueOf(name);
        }
        catch (IllegalArgumentException exception) {
            LightmansCurrency.LogError("Could not load '" + name + "' as a TradeDirection.");
        }
        return value;
    }

    public static List<ItemTradeData> listOfSize(int tradeCount, Supplier<ItemTradeData> builder) {
        ArrayList<ItemTradeData> data = new ArrayList<ItemTradeData>();
        while (data.size() < tradeCount) {
            data.add(builder.get());
        }
        return data;
    }

    @Override
    public TradeComparisonResult compare(TradeData otherTrade) {
        TradeComparisonResult result = new TradeComparisonResult();
        if (otherTrade instanceof ItemTradeData) {
            ItemTradeData otherItemTrade = (ItemTradeData)otherTrade;
            result.setCompatible();
            result.addProductResults(ProductComparisonResult.CompareTwoItems(this.getSellItem(0), this.getSellItem(1), otherItemTrade.getSellItem(0), otherItemTrade.getSellItem(1), this.compareNBT(otherItemTrade, 0)));
            if (this.isBarter()) {
                result.addProductResults(ProductComparisonResult.CompareTwoItems(this.getBarterItem(0), this.getBarterItem(1), otherItemTrade.getBarterItem(0), otherItemTrade.getBarterItem(1), this.compareNBT(otherItemTrade, 2)));
            }
            if (!this.isBarter()) {
                result.comparePrices(this.getCost(), otherTrade.getCost());
            }
            result.setTypeResult(this.tradeType == otherItemTrade.tradeType);
        }
        return result;
    }

    private boolean compareNBT(@Nonnull ItemTradeData otherItemTrade, int startingSlot) {
        for (int i = startingSlot; i < startingSlot + 2; ++i) {
            ItemStack true1 = this.getItem(i);
            ItemStack expected1 = otherItemTrade.getItem(i);
            if (true1.m_41619_() && expected1.m_41619_() || !this.enforceNBT.get(i).booleanValue() && !otherItemTrade.enforceNBT.get(i).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean AcceptableDifferences(TradeComparisonResult result) {
        int i;
        if (!result.TypeMatches() || !result.isCompatible()) {
            return false;
        }
        if (result.getProductResultCount() < 2) {
            return false;
        }
        for (i = 0; i < 2; ++i) {
            ProductComparisonResult sellResult = result.getProductResult(i);
            if (sellResult.SameProductType() && sellResult.SameProductNBT()) {
                if (!(this.isSale() || this.isBarter() ? sellResult.ProductQuantityDifference() < 0 : this.isPurchase() && sellResult.ProductQuantityDifference() > 0)) continue;
                return false;
            }
            return false;
        }
        if (this.isBarter()) {
            if (result.getProductResultCount() < 4) {
                return false;
            }
            for (i = 0; i < 2; ++i) {
                ProductComparisonResult barterResult = result.getProductResult(i + 2);
                if (barterResult.SameProductType() && barterResult.SameProductNBT()) {
                    if (barterResult.ProductQuantityDifference() <= 0) continue;
                    return false;
                }
                return false;
            }
        }
        if (this.isSale() && result.isPriceExpensive()) {
            return false;
        }
        return !this.isPurchase() || !result.isPriceCheaper();
    }

    @Override
    public List<Component> GetDifferenceWarnings(TradeComparisonResult differences) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (!differences.PriceMatches()) {
            if (differences.PriceIncompatible()) {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_MONEY_TYPE.getWithStyle(ChatFormatting.RED));
            }
            if (this.isPurchase()) {
                if (differences.isPriceCheaper()) {
                    list.add((Component)LCText.GUI_TRADE_DIFFERENCE_PURCHASE_CHEAPER.get(differences.priceDifference().getText()).m_130940_(ChatFormatting.RED));
                } else {
                    list.add((Component)LCText.GUI_TRADE_DIFFERENCE_PURCHASE_EXPENSIVE.get(differences.priceDifference().getText()).m_130940_(ChatFormatting.GOLD));
                }
            } else if (differences.isPriceExpensive()) {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_EXPENSIVE.get(differences.priceDifference().getText()).m_130940_(ChatFormatting.RED));
            } else {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_CHEAPER.get(differences.priceDifference().getText()).m_130940_(ChatFormatting.GOLD));
            }
        }
        for (int i = 0; i < differences.getProductResultCount(); ++i) {
            int slot = this.isPurchase() ? i + 2 : i;
            ChatFormatting moreColor = slot >= 2 ? ChatFormatting.RED : ChatFormatting.GOLD;
            ChatFormatting lessColor = slot >= 2 ? ChatFormatting.GOLD : ChatFormatting.RED;
            MutableComponent slotName = slot >= 2 ? LCText.GUI_TRADE_DIFFERENCE_ITEM_PURCHASING.get(new Object[0]) : LCText.GUI_TRADE_DIFFERENCE_ITEM_SELLING.get(new Object[0]);
            ProductComparisonResult productCheck = differences.getProductResult(i);
            if (!productCheck.SameProductType()) {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_ITEM_TYPE.get(slotName).m_130940_(ChatFormatting.RED));
                continue;
            }
            if (!productCheck.SameProductNBT()) {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_ITEM_NBT.get(slotName).m_130940_(ChatFormatting.RED));
                continue;
            }
            if (productCheck.SameProductQuantity()) continue;
            int quantityDifference = productCheck.ProductQuantityDifference();
            if (quantityDifference > 0) {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_ITEM_QUANTITY_MORE.get(slotName, quantityDifference).m_130940_(moreColor));
                continue;
            }
            list.add((Component)LCText.GUI_TRADE_DIFFERENCE_ITEM_QUANTITY_LESS.get(slotName, -quantityDifference).m_130940_(lessColor));
        }
        return list;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRenderManager<?> getButtonRenderer() {
        return new ItemTradeButtonRenderer(this);
    }

    @Override
    public void OnInputDisplayInteraction(@Nonnull BasicTradeEditTab tab, int index, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData it = (ItemTraderData)traderData;
            int tradeIndex = it.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            if (this.isSale()) {
                tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", -1));
            }
            if (this.isPurchase() && index >= 0 && index < 2) {
                ItemStack sellItem = this.getSellItem(index);
                if (FilterAPI.itemHasFilter(heldItem) && this.allowFilters()) {
                    sellItem = this.getActualItem(index);
                }
                if (data.shiftHeld() || sellItem.m_41619_() && heldItem.m_41619_()) {
                    tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", index));
                } else if (InventoryUtil.ItemMatches(sellItem, heldItem) && data.mouseButton() == 1) {
                    sellItem.m_41764_(Math.min(sellItem.m_41613_() + 1, sellItem.m_41741_()));
                    this.setItem(sellItem, index);
                } else {
                    ItemStack setItem = heldItem.m_41777_();
                    if (data.mouseButton() == 1) {
                        setItem.m_41764_(1);
                    }
                    this.setItem(setItem, index);
                }
                if (tab.isClient()) {
                    tab.SendInputInteractionMessage(tradeIndex, index, data, heldItem);
                }
            } else if (this.isBarter() && index >= 0 && index < 2) {
                ItemStack barterItem = this.getBarterItem(index);
                if (data.shiftHeld() || barterItem.m_41619_() && heldItem.m_41619_()) {
                    tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", index + 2));
                } else if (InventoryUtil.ItemMatches(barterItem, heldItem) && data.mouseButton() == 1) {
                    barterItem.m_41764_(Math.min(barterItem.m_41613_() + 1, barterItem.m_41741_()));
                    this.setItem(barterItem, index + 2);
                } else {
                    ItemStack setItem = heldItem.m_41777_();
                    if (data.mouseButton() == 1) {
                        setItem.m_41764_(1);
                    }
                    this.setItem(setItem, index + 2);
                }
                if (((ITraderStorageMenu)tab.menu).isClient()) {
                    tab.SendInputInteractionMessage(tradeIndex, index, data, heldItem);
                }
            }
        }
    }

    public void onSlotInteraction(int index, ItemStack heldItem, int button) {
        ItemStack setItem;
        if (index < 2) {
            ItemStack sellItem = this.getSellItem(index);
            if (FilterAPI.itemHasFilter(heldItem) && this.allowFilters()) {
                sellItem = this.getActualItem(index);
            }
            if (sellItem.m_41619_() && heldItem.m_41619_()) {
                return;
            }
            if (InventoryUtil.ItemMatches(sellItem, heldItem) && button == 1) {
                sellItem.m_41764_(Math.min(sellItem.m_41613_() + 1, sellItem.m_41741_()));
                this.setItem(sellItem, index);
            } else {
                setItem = heldItem.m_41777_();
                if (button == 1) {
                    setItem.m_41764_(1);
                }
                this.setItem(setItem, index);
            }
        }
        if (this.isBarter() && index >= 2 && index < 4) {
            ItemStack barterItem = this.getItem(index);
            if (barterItem.m_41619_() && heldItem.m_41619_()) {
                return;
            }
            if (InventoryUtil.ItemMatches(barterItem, heldItem) && button == 1) {
                barterItem.m_41764_(Math.min(barterItem.m_41613_() + 1, barterItem.m_41741_()));
                this.setItem(barterItem, index);
            } else {
                setItem = heldItem.m_41777_();
                if (button == 1) {
                    setItem.m_41764_(1);
                }
                this.setItem(setItem, index);
            }
        }
    }

    @Override
    public void OnOutputDisplayInteraction(@Nonnull BasicTradeEditTab tab, int index, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData it = (ItemTraderData)traderData;
            int tradeIndex = it.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            if ((this.isSale() || this.isBarter()) && index >= 0 && index < 2) {
                ItemStack sellItem = this.getSellItem(index);
                if (FilterAPI.itemHasFilter(heldItem) && this.allowFilters()) {
                    sellItem = this.getActualItem(index);
                }
                if (data.shiftHeld() || sellItem.m_41619_() && heldItem.m_41619_()) {
                    tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", index));
                } else if (InventoryUtil.ItemMatches(sellItem, heldItem) && data.mouseButton() == 1) {
                    sellItem.m_41764_(Math.min(sellItem.m_41613_() + 1, sellItem.m_41741_()));
                    this.setItem(sellItem, index);
                } else {
                    ItemStack setItem = heldItem.m_41777_();
                    if (data.mouseButton() == 1) {
                        setItem.m_41764_(1);
                    }
                    this.setItem(setItem, index);
                }
                if (((ITraderStorageMenu)tab.menu).isClient()) {
                    tab.SendOutputInteractionMessage(tradeIndex, index, data, heldItem);
                }
            } else if (this.isPurchase()) {
                tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", -1));
            }
        }
    }

    @Override
    public void OnInteraction(@Nonnull BasicTradeEditTab tab, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData it = (ItemTraderData)traderData;
            int tradeIndex = it.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex));
        }
    }

    @Override
    protected void collectRelevantInventorySlots(TradeContext context, List<Slot> slots, List<Integer> results) {
        if (this.isPurchase()) {
            context.hightlightItems(Lists.newArrayList((Object[])new ItemRequirement[]{this.getItemRequirement(0), this.getItemRequirement(1)}), slots, results);
        } else if (this.isBarter()) {
            context.hightlightItems(Lists.newArrayList((Object[])new ItemRequirement[]{this.getItemRequirement(2), this.getItemRequirement(3)}), slots, results);
        }
    }

    @Override
    public boolean isMoneyRelevant() {
        return !this.isBarter();
    }

    static {
        DEFAULT_TYPE = VersionUtil.lcResource("item");
        typeRegistry = new HashMap<ResourceLocation, Function<Boolean, ItemTradeData>>();
        typeRegistry.put(DEFAULT_TYPE, ItemTradeData::new);
    }
}

