/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.settings;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;

public class ChangeAllyPermissionNotification
extends SingleLineNotification {
    public static final NotificationType<ChangeAllyPermissionNotification> TYPE = new NotificationType(VersionUtil.lcResource("change_ally_permissions"), ChangeAllyPermissionNotification::new);
    PlayerReference player;
    String permission;
    int newValue;
    int oldValue;

    private ChangeAllyPermissionNotification() {
    }

    public ChangeAllyPermissionNotification(PlayerReference player, String permission, int newValue, int oldValue) {
        this.player = player;
        this.permission = permission;
        this.newValue = newValue;
        this.oldValue = oldValue;
    }

    @Nonnull
    protected NotificationType<ChangeAllyPermissionNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        if (this.oldValue == 0) {
            return LCText.NOTIFICATION_SETTINGS_CHANGE_ALLY_PERMISSIONS_SIMPLE.get(this.player.getName(true), this.permission, this.newValue);
        }
        return LCText.NOTIFICATION_SETTINGS_CHANGE_ALLY_PERMISSIONS.get(this.player.getName(true), this.permission, this.oldValue, this.newValue);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128365_("Player", (Tag)this.player.save());
        compound.m_128359_("Permission", this.permission);
        compound.m_128405_("NewValue", this.newValue);
        compound.m_128405_("OldValue", this.oldValue);
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.player = PlayerReference.load(compound.m_128469_("Player"));
        this.permission = compound.m_128461_("Permission");
        this.newValue = compound.m_128451_("NewValue");
        this.oldValue = compound.m_128451_("OldValue");
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof ChangeAllyPermissionNotification) {
            ChangeAllyPermissionNotification n = (ChangeAllyPermissionNotification)other;
            return n.player.is(this.player) && n.permission.equals(this.permission) && n.newValue == this.newValue && n.oldValue == this.oldValue;
        }
        return false;
    }
}

