/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core;

import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.settings.data.NodeSelections;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextData;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextWriter;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.core.SettingsClipboardClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SettingsCopySlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class SettingsClipboardTab
extends TraderStorageTab {
    private final Container container = new SimpleContainer(1);
    private SettingsCopySlot slot;

    public SettingsClipboardTab(@Nonnull ITraderStorageMenu menu) {
        super(menu);
    }

    public EasySlot getSlot() {
        return this.slot;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new SettingsClipboardClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return true;
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        this.slot = new SettingsCopySlot(this.container, 0, 95, 122);
        this.slot.active = false;
        addSlot.apply(this.slot);
    }

    @Override
    public void onTabOpen() {
        this.slot.active = true;
    }

    @Override
    public void onTabClose() {
        this.slot.active = false;
        ItemStack stackInSlot = this.container.m_8020_(0);
        if (!stackInSlot.m_41619_()) {
            this.container.m_6836_(0, ItemStack.f_41583_);
            ItemHandlerHelper.giveItemToPlayer((Player)((ITraderStorageMenu)this.menu).getPlayer(), (ItemStack)stackInSlot);
        }
    }

    @Override
    public void onMenuClose() {
        ((ITraderStorageMenu)this.menu).clearContainer(this.container);
    }

    public boolean canWriteSettings() {
        return InventoryUtil.ItemHasTag(this.container.m_8020_(0), LCTags.Items.SETTINGS_WRITABLE);
    }

    public boolean canReadSettings() {
        ItemStack stack = this.container.m_8020_(0);
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("CopiedSettings") && InventoryUtil.ItemHasTag(stack, LCTags.Items.SETTINGS_READABLE);
    }

    public void copySettings(NodeSelections selections) {
        if (this.isClient()) {
            ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setCompound("CopySettings", selections.write()));
        } else {
            ItemStack writableStack;
            if (!this.canWriteSettings()) {
                return;
            }
            TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
            if (trader == null) {
                return;
            }
            ItemStack result = writableStack = this.container.m_8020_(0);
            SavedSettingData data = trader.saveSettings(((ITraderStorageMenu)this.menu).getPlayer(), selections);
            CompoundTag tag = writableStack.m_41784_();
            tag.m_128365_("CopiedSettings", (Tag)data.save());
            PrettyTextWriter writer = PrettyTextWriter.getForStack(writableStack);
            PrettyTextData lines = trader.writePrettySettings(data);
            result = writer.writeLinesToStack(((ITraderStorageMenu)this.menu).getPlayer(), result, lines);
            this.container.m_6836_(0, result);
        }
    }

    public void loadSettings(NodeSelections selections) {
        if (this.isClient()) {
            ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setCompound("ReadSettings", selections.write()));
        } else {
            if (!this.canReadSettings()) {
                return;
            }
            TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
            if (trader == null) {
                return;
            }
            ItemStack readableStack = this.container.m_8020_(0);
            CompoundTag tag = readableStack.m_41783_();
            if (tag == null || !tag.m_128441_("CopiedSettings")) {
                return;
            }
            SavedSettingData data = SavedSettingData.parse(tag.m_128469_("CopiedSettings"));
            trader.loadSettings(((ITraderStorageMenu)this.menu).getPlayer(), data, selections);
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("CopySettings")) {
            this.copySettings(NodeSelections.read(message.getNBT("CopySettings")));
        }
        if (message.contains("ReadSettings")) {
            this.loadSettings(NodeSelections.read(message.getNBT("ReadSettings")));
        }
    }
}

