/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction.AuctionStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionPlayerStorage;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AuctionStorageTab
extends TraderStorageTab {
    public AuctionStorageTab(@Nonnull ITraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new AuctionStorageClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return true;
    }

    public void clickedOnSlot(int storageSlot, boolean isShiftHeld) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)traderData;
            AuctionPlayerStorage storage = trader.getStorage(((ITraderStorageMenu)this.menu).getPlayer());
            if (storageSlot >= 0 && storageSlot < storage.getStoredItems().size()) {
                ItemStack storedItem = storage.getStoredItems().get(storageSlot);
                if (storedItem.m_41619_()) {
                    storage.getStoredItems().remove(storageSlot);
                    trader.markStorageDirty();
                } else {
                    int transferCount;
                    ItemStack heldItem = ((ITraderStorageMenu)this.menu).getHeldItem();
                    if (isShiftHeld) {
                        ((ITraderStorageMenu)this.menu).getPlayer().m_150109_().m_36054_(storedItem);
                        if (storedItem.m_41619_()) {
                            storage.getStoredItems().remove(storageSlot);
                        }
                        trader.markStorageDirty();
                    } else if (heldItem.m_41619_()) {
                        ((ITraderStorageMenu)this.menu).setHeldItem(storedItem);
                        storage.getStoredItems().remove(storageSlot);
                        trader.markStorageDirty();
                    } else if (InventoryUtil.ItemMatches(storedItem, heldItem) && (transferCount = Math.min(heldItem.m_41741_() - heldItem.m_41613_(), storedItem.m_41613_())) > 0) {
                        heldItem.m_41769_(transferCount);
                        ((ITraderStorageMenu)this.menu).setHeldItem(heldItem);
                        storedItem.m_41774_(transferCount);
                        if (storedItem.m_41619_()) {
                            storage.getStoredItems().remove(storageSlot);
                        }
                        trader.markStorageDirty();
                    }
                }
            }
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setInt("ClickedSlot", storageSlot).setBoolean("HeldShift", isShiftHeld));
            }
        }
    }

    public void quickTransfer() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)traderData;
            AuctionPlayerStorage storage = trader.getStorage(((ITraderStorageMenu)this.menu).getPlayer());
            storage.collectItems(((ITraderStorageMenu)this.menu).getPlayer());
            trader.markStorageDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setFlag("QuickTransfer"));
            }
        }
    }

    public void collectCoins() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)traderData;
            AuctionPlayerStorage storage = trader.getStorage(((ITraderStorageMenu)this.menu).getPlayer());
            storage.collectedMoney(((ITraderStorageMenu)this.menu).getPlayer());
            trader.markStorageDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setFlag("CollectMoney"));
            }
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("ClickedSlot", (byte)2)) {
            int storageSlot = message.getInt("ClickedSlot");
            boolean isShiftHeld = message.getBoolean("HeldShift");
            this.clickedOnSlot(storageSlot, isShiftHeld);
        }
        if (message.contains("QuickTransfer")) {
            this.quickTransfer();
        }
        if (message.contains("CollectMoney")) {
            this.collectCoins();
        }
    }
}

