/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.teams.tabs;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamMemberEditClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TeamManagementMenu;
import io.github.lightman314.lightmanscurrency.common.menus.teams.TeamManagementTab;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import javax.annotation.Nonnull;

public class TeamMemberEditTab
extends TeamManagementTab.Management {
    public TeamMemberEditTab(@Nonnull TeamManagementMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    public Object createClientTab(@Nonnull Object screen) {
        return new TeamMemberEditClientTab(screen, this);
    }

    @Override
    @Nonnull
    protected TeamManagementTab.Management.AccessLevel accessLevel() {
        return TeamManagementTab.Management.AccessLevel.MEMBERS;
    }

    public void PromotePlayer(@Nonnull PlayerReference player) {
        ITeam iTeam = ((TeamManagementMenu)this.menu).selectedTeam();
        if (iTeam instanceof Team) {
            Team team = (Team)iTeam;
            team.changePromoteMember(((TeamManagementMenu)this.menu).player, player);
        }
        if (this.isClient()) {
            ((TeamManagementMenu)this.menu).SendMessage(this.builder().setCompound("PromotePlayer", player.save()));
        }
    }

    public void DemotePlayer(@Nonnull PlayerReference player) {
        ITeam iTeam = ((TeamManagementMenu)this.menu).selectedTeam();
        if (iTeam instanceof Team) {
            Team team = (Team)iTeam;
            team.changeDemoteMember(((TeamManagementMenu)this.menu).player, player);
        }
        if (this.isClient()) {
            ((TeamManagementMenu)this.menu).SendMessage(this.builder().setCompound("DemotePlayer", player.save()));
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("PromotePlayer")) {
            this.PromotePlayer(PlayerReference.load(message.getNBT("PromotePlayer")));
        }
        if (message.contains("DemotePlayer")) {
            this.DemotePlayer(PlayerReference.load(message.getNBT("DemotePlayer")));
        }
    }
}

