/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.tax_collector.tabs;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.tax_collector.OwnershipClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TaxCollectorMenu;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.TaxCollectorTab;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;

public class OwnershipTab
extends TaxCollectorTab {
    public OwnershipTab(TaxCollectorMenu menu) {
        super(menu);
    }

    @Override
    public boolean canOpen(@Nonnull Player player) {
        return this.isOwner() && !this.isServerEntry();
    }

    @Override
    @Nonnull
    public Object createClientTab(@Nonnull Object screen) {
        return new OwnershipClientTab(screen, this);
    }

    public void SetOwner(@Nonnull Owner newOwner) {
        TaxEntry entry = this.getEntry();
        if (entry != null && ((TaxCollectorMenu)this.menu).isOwner()) {
            entry.getOwner().SetOwner(newOwner);
            if (this.isClient()) {
                ((TaxCollectorMenu)this.menu).SendMessageToServer(this.builder().setOwner("SetOwner", newOwner));
            }
        }
    }

    public void SetOwnerPlayer(String playerName) {
        TaxEntry entry = this.getEntry();
        if (entry != null && ((TaxCollectorMenu)this.menu).isOwner()) {
            if (this.isServer()) {
                PlayerReference newOwner = PlayerReference.of(false, playerName);
                if (newOwner != null) {
                    entry.getOwner().SetOwner(PlayerOwner.of(newOwner));
                }
            } else {
                ((TaxCollectorMenu)this.menu).SendMessageToServer(this.builder().setString("SetOwnerPlayer", playerName));
            }
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("SetOwner")) {
            this.SetOwner(message.getOwner("SetOwner"));
        }
        if (message.contains("SetOwnerPlayer")) {
            this.SetOwnerPlayer(message.getString("SetOwnerPlayer"));
        }
    }
}

