/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items.data;

import com.google.common.collect.ImmutableList;
import dev.architectury.fluid.FluidStack;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public record FilterData(List<ResourceLocation> entries, List<ResourceLocation> tags) {
    public static final FilterData EMPTY = new FilterData((List<ResourceLocation>)ImmutableList.of(), (List<ResourceLocation>)ImmutableList.of());

    public boolean isEmpty() {
        return this.entries.isEmpty() && this.tags.isEmpty();
    }

    public void write(ItemStack item) {
        if (this.isEmpty()) {
            CompoundTag itemTag = item.m_41783_();
            if (itemTag != null && itemTag.m_128441_("FilterData")) {
                itemTag.m_128473_("FilterData");
            }
            return;
        }
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (ResourceLocation e : this.entries) {
            list.add((Object)StringTag.m_129297_((String)e.toString()));
        }
        if (!list.isEmpty()) {
            tag.m_128365_("entries", (Tag)list);
        }
        list = new ListTag();
        for (ResourceLocation t : this.tags) {
            list.add((Object)StringTag.m_129297_((String)t.toString()));
        }
        if (!list.isEmpty()) {
            tag.m_128365_("tags", (Tag)list);
        }
        CompoundTag itemTag = item.m_41784_();
        itemTag.m_128365_("FilterData", (Tag)tag);
    }

    public static FilterData parse(ItemStack item) {
        int i;
        ListTag list;
        CompoundTag itemTag = item.m_41783_();
        if (itemTag == null || !itemTag.m_128441_("FilterData")) {
            return EMPTY;
        }
        CompoundTag tag = itemTag.m_128469_("FilterData");
        ArrayList<ResourceLocation> entries = new ArrayList<ResourceLocation>();
        ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>();
        if (tag.m_128441_("entries")) {
            list = tag.m_128437_("entries", 8);
            for (i = 0; i < list.size(); ++i) {
                entries.add(VersionUtil.parseResource(list.m_128778_(i)));
            }
        }
        if (tag.m_128441_("tags")) {
            list = tag.m_128437_("tags", 8);
            for (i = 0; i < list.size(); ++i) {
                tags.add(VersionUtil.parseResource(list.m_128778_(i)));
            }
        }
        return new FilterData((List<ResourceLocation>)ImmutableList.copyOf(entries), (List<ResourceLocation>)ImmutableList.copyOf(tags));
    }

    public FilterData addEntry(ResourceLocation entry) {
        if (this.entries.contains(entry)) {
            return this;
        }
        ArrayList<ResourceLocation> newEntries = new ArrayList<ResourceLocation>(this.entries);
        newEntries.add(entry);
        return new FilterData((List<ResourceLocation>)ImmutableList.copyOf(newEntries), this.tags);
    }

    public FilterData removeEntry(ResourceLocation entry) {
        if (!this.entries.contains(entry)) {
            return this;
        }
        ArrayList<ResourceLocation> newEntries = new ArrayList<ResourceLocation>(this.entries);
        newEntries.remove(entry);
        return new FilterData((List<ResourceLocation>)ImmutableList.copyOf(newEntries), this.tags);
    }

    public FilterData addTag(ResourceLocation entry) {
        if (this.tags.contains(entry)) {
            return this;
        }
        ArrayList<ResourceLocation> newTags = new ArrayList<ResourceLocation>(this.tags);
        newTags.add(entry);
        return new FilterData(this.entries, (List<ResourceLocation>)ImmutableList.copyOf(newTags));
    }

    public FilterData removeTag(ResourceLocation entry) {
        if (!this.tags.contains(entry)) {
            return this;
        }
        ArrayList<ResourceLocation> newTags = new ArrayList<ResourceLocation>(this.tags);
        newTags.remove(entry);
        return new FilterData(this.entries, (List<ResourceLocation>)ImmutableList.copyOf(newTags));
    }

    public Predicate<ItemStack> asItemPredicate() {
        return s -> {
            ResourceLocation itemKey = BuiltInRegistries.f_257033_.m_7981_((Object)s.m_41720_());
            if (this.entries.contains(itemKey)) {
                return true;
            }
            return s.m_204131_().anyMatch(tagKey -> this.tags.contains(tagKey.f_203868_()));
        };
    }

    public Predicate<FluidStack> asFluidPredicate() {
        return s -> {
            ResourceLocation fluidKey = ForgeRegistries.FLUIDS.getKey((Object)s.getFluid());
            if (this.entries.contains(fluidKey)) {
                return true;
            }
            Holder holder = ForgeRegistries.FLUIDS.getHolder((Object)s.getFluid()).orElse(null);
            return holder != null && holder.m_203616_().anyMatch(tagKey -> this.tags.contains(tagKey.f_203868_()));
        };
    }
}

