/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items.ancient_coins;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public enum AncientCoinType {
    COPPER("copper"),
    IRON("iron"),
    GOLD("gold"),
    EMERALD("emerald"),
    DIAMOND("diamond"),
    NETHERITE_H("netherite", true, 2),
    NETHERITE_E1("netherite", true, 3),
    NETHERITE_R1("netherite", true, 3),
    NETHERITE_O("netherite", true, 2),
    NETHERITE_B("netherite", true, 2),
    NETHERITE_R2("netherite", true, 3),
    NETHERITE_I("netherite", true, 2),
    NETHERITE_N("netherite", true, 2),
    NETHERITE_E2("netherite", true, 3),
    LAPIS("lapis"),
    ENDER_PEARL("ender_pearl");

    private static List<String> tags;
    public final boolean fireResistant;
    private final int ignoreChars;
    public final String tag;

    public static List<String> tags() {
        if (tags == null) {
            ArrayList<String> t = new ArrayList<String>();
            for (AncientCoinType type : AncientCoinType.values()) {
                if (t.contains(type.tag)) continue;
                t.add(type.tag);
            }
            tags = ImmutableList.copyOf(t);
        }
        return tags;
    }

    private AncientCoinType(String tag) {
        this(tag, false, 0);
    }

    private AncientCoinType(String tag, boolean fireResistant, int ignoreChars) {
        this.tag = tag;
        this.fireResistant = fireResistant;
        this.ignoreChars = ignoreChars;
    }

    public ItemStack asItem() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.COIN_ANCIENT.get());
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("CoinType", this.toString());
        return stack;
    }

    public ItemStack asItem(long count) {
        return this.asItem((int)Math.min(count, Integer.MAX_VALUE));
    }

    public ItemStack asItem(int count) {
        ItemStack item = this.asItem();
        item.m_41764_(count);
        return item;
    }

    public ResourceLocation texture() {
        return VersionUtil.lcResource("item/ancient_coin/" + this.resourceSafeName());
    }

    public String translationTag() {
        if (this.ignoreChars <= 0) {
            return this.resourceSafeName();
        }
        String safeName = this.resourceSafeName();
        return safeName.substring(0, safeName.length() - this.ignoreChars);
    }

    public String initialKey() {
        return "lightmanscurrency.money.ancient_coins.initial." + this.resourceSafeName();
    }

    public String iconKey() {
        return "lightmanscurrency.money.ancient_coins.icon." + this.resourceSafeName();
    }

    public Component initial() {
        return EasyText.translatable(this.initialKey(), new Object[0]);
    }

    public Component icon() {
        return EasyText.translatableWithFallback(this.iconKey(), "lightmanscurrency.icon.fallback").m_130940_(ChatFormatting.WHITE);
    }

    public String resourceSafeName() {
        return this.toString().toLowerCase(Locale.ENGLISH);
    }

    public AncientCoinType previous() {
        return AncientCoinType.fromOrdinal(this.ordinal() - 1, ENDER_PEARL);
    }

    public AncientCoinType next() {
        return AncientCoinType.fromOrdinal(this.ordinal() + 1, COPPER);
    }

    public static AncientCoinType fromOrdinal(int ordinal, AncientCoinType defaultValue) {
        for (AncientCoinType type : AncientCoinType.values()) {
            if (type.ordinal() != ordinal) continue;
            return type;
        }
        return defaultValue;
    }

    public static ItemStack randomizingItem() {
        return AncientCoinType.randomizingItem(1);
    }

    public static ItemStack randomizingItem(int count) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("RandomCoin", true);
        ItemStack item = new ItemStack((ItemLike)ModItems.COIN_ANCIENT.get(), count);
        item.m_41751_(tag);
        return item;
    }

    public static AncientCoinType random(RandomSource random) {
        return AncientCoinType.randomWithTags(AncientCoinType.tags().get(random.m_188503_(AncientCoinType.tags().size())), random);
    }

    private static AncientCoinType randomWithTags(String tag, RandomSource random) {
        ArrayList<AncientCoinType> coinsWithTag = new ArrayList<AncientCoinType>();
        for (AncientCoinType type : AncientCoinType.values()) {
            if (!type.tag.equals(tag)) continue;
            coinsWithTag.add(type);
        }
        if (coinsWithTag.isEmpty()) {
            return COPPER;
        }
        return (AncientCoinType)((Object)coinsWithTag.get(random.m_188503_(coinsWithTag.size())));
    }

    static {
        tags = null;
    }
}

