/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.impl;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderType;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.ITradeSearchFilter;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.ITraderSearchFilter;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.PendingSearch;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.SortTypeKey;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.TerminalSortType;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.common.data.types.TraderDataCache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class TraderAPIImpl
extends TraderAPI {
    public static final TraderAPIImpl INSTANCE = new TraderAPIImpl();
    private final Map<String, TraderType<?>> traderRegistry = new HashMap();
    private final Map<String, TradeRuleType<?>> tradeRuleRegistry = new HashMap();
    private final Map<ResourceLocation, TerminalSortType> sortTypeRegistry = new HashMap<ResourceLocation, TerminalSortType>();
    private final List<ITraderSearchFilter> traderSearchFilters = new ArrayList<ITraderSearchFilter>();
    private final List<ITradeSearchFilter> tradeSearchFilters = new ArrayList<ITradeSearchFilter>();

    private TraderAPIImpl() {
    }

    @Override
    public void RegisterTrader(@Nonnull TraderType<?> type) {
        String t = type.type.toString();
        if (this.traderRegistry.containsKey(t)) {
            LightmansCurrency.LogWarning("Attempted to register duplicate TraderType '" + t + "'!");
            return;
        }
        this.traderRegistry.put(t, type);
        LightmansCurrency.LogInfo("Registered TraderType " + type);
    }

    @Override
    @Nullable
    public TraderType<?> GetTraderType(@Nonnull ResourceLocation type) {
        return this.traderRegistry.get(type.toString());
    }

    @Override
    public void RegisterTradeRule(@Nonnull TradeRuleType<?> type) {
        String t = type.type.toString();
        if (this.tradeRuleRegistry.containsKey(t)) {
            LightmansCurrency.LogWarning("Attempted to register duplicate TradeRuleType '" + type.type + "'!");
            return;
        }
        this.tradeRuleRegistry.put(t, type);
        LightmansCurrency.LogInfo("Registered TradeRuleType " + type);
    }

    @Override
    @Nullable
    public TradeRuleType<?> GetTradeRuleType(@Nonnull ResourceLocation type) {
        return this.tradeRuleRegistry.get(type.toString());
    }

    @Override
    @Nonnull
    public List<TradeRuleType<?>> GetAllTradeRuleTypes() {
        return ImmutableList.copyOf(this.tradeRuleRegistry.values());
    }

    @Override
    public void RegisterTraderSearchFilter(@Nonnull ITraderSearchFilter filter) {
        if (this.traderSearchFilters.contains(filter)) {
            return;
        }
        this.traderSearchFilters.add(filter);
    }

    @Override
    public boolean FilterTrader(@Nonnull TraderData data, @Nonnull String search) {
        if (search.isBlank()) {
            return true;
        }
        PendingSearch results = PendingSearch.of(search);
        return this.FilterTrader(data, results);
    }

    private boolean FilterTrader(@Nonnull TraderData data, @Nonnull PendingSearch search) {
        PendingSearch results = search.copy();
        for (ITraderSearchFilter filter : this.traderSearchFilters) {
            filter.filter(data, results);
        }
        return results.hasPassed();
    }

    @Override
    @Nonnull
    public List<TraderData> FilterTraders(@Nonnull List<TraderData> data, @Nonnull String search) {
        if (search.isBlank()) {
            return data;
        }
        PendingSearch temp = PendingSearch.of(search);
        ArrayList<TraderData> results = new ArrayList<TraderData>();
        for (TraderData trader : data) {
            if (!this.FilterTrader(trader, temp)) continue;
            results.add(trader);
        }
        return results;
    }

    @Override
    public void RegisterTradeSearchFilter(@Nonnull ITradeSearchFilter filter) {
        if (this.tradeSearchFilters.contains(filter)) {
            return;
        }
        this.tradeSearchFilters.add(filter);
    }

    @Override
    public boolean FilterTrade(@Nonnull TradeData trade, @Nonnull String search) {
        if (search.isBlank()) {
            return true;
        }
        return this.FilterTrade(trade, PendingSearch.of(search));
    }

    private boolean FilterTrade(TradeData trade, PendingSearch search) {
        PendingSearch results = search.copy();
        for (ITradeSearchFilter filter : this.tradeSearchFilters) {
            filter.filterTrade(trade, results);
        }
        return results.hasPassed();
    }

    @Override
    @Nonnull
    public List<TradeData> FilterTrades(@Nonnull List<TradeData> trades, @Nonnull String search) {
        if (search.isBlank()) {
            return trades;
        }
        PendingSearch temp = PendingSearch.of(search);
        ArrayList<TradeData> result = new ArrayList<TradeData>();
        for (TradeData trade : trades) {
            if (!this.FilterTrade(trade, temp)) continue;
            result.add(trade);
        }
        return result;
    }

    @Override
    public <T extends ITraderSearchFilter & ITradeSearchFilter> void RegisterSearchFilter(@Nonnull T filter) {
        this.RegisterTraderSearchFilter(filter);
        this.RegisterTradeSearchFilter(filter);
    }

    @Override
    public void RegisterSortType(TerminalSortType sortType) {
        Objects.requireNonNull(sortType, "Terminal Sort Type cannot be null!");
        if (this.sortTypeRegistry.containsKey(sortType.getID())) {
            LightmansCurrency.LogWarning("Attempted to register duplicate TerminalSortType '" + sortType.getID() + "'!");
            return;
        }
        this.sortTypeRegistry.put(sortType.getID(), sortType);
    }

    @Override
    @Nullable
    public TerminalSortType GetSortType(ResourceLocation key) {
        return this.sortTypeRegistry.get(key);
    }

    @Override
    @Nullable
    public TerminalSortType GetSortType(SortTypeKey key) {
        TerminalSortType type = this.GetSortType(key.id());
        if (type != null && key.inverted()) {
            return type.getInverted();
        }
        return type;
    }

    @Override
    public List<TerminalSortType> GetAllSortTypes() {
        ArrayList<TerminalSortType> list = new ArrayList<TerminalSortType>(this.sortTypeRegistry.values());
        list.sort(Comparator.comparingInt(TerminalSortType::sortPriority).reversed());
        ArrayList<TerminalSortType> result = new ArrayList<TerminalSortType>();
        for (TerminalSortType type : list) {
            TerminalSortType inverted;
            result.add(type);
            if (!type.supportsInverted() || (inverted = type.getInverted()) == null) continue;
            result.add(inverted);
        }
        return result;
    }

    @Override
    public List<SortTypeKey> GetAllSortTypeKeys() {
        List<TerminalSortType> types = this.GetAllSortTypes();
        return types.stream().map(TerminalSortType::getKey).toList();
    }

    @Override
    @Nullable
    public TraderData GetTrader(boolean isClient, long traderID) {
        TraderDataCache data = TraderDataCache.TYPE.get(isClient);
        if (data == null) {
            return null;
        }
        return data.getTrader(traderID);
    }

    @Override
    @Nonnull
    public List<TraderData> GetAllTraders(boolean isClient) {
        TraderDataCache data = TraderDataCache.TYPE.get(isClient);
        if (data == null) {
            return new ArrayList<TraderData>();
        }
        return data.getAllTraders();
    }

    @Override
    public List<TraderData> GetAllNetworkTraders(boolean isClient) {
        TraderDataCache data = TraderDataCache.TYPE.get(isClient);
        if (data == null) {
            return new ArrayList<TraderData>();
        }
        return data.getAllTerminalTraders();
    }

    @Override
    public long CreateTrader(@Nonnull TraderData newTrader, @Nullable Player player) {
        TraderDataCache data = TraderDataCache.TYPE.get(false);
        if (data == null) {
            return -1L;
        }
        return data.registerTrader(newTrader, player);
    }

    @Override
    public void DeleteTrader(long traderID) {
        TraderDataCache data = TraderDataCache.TYPE.get(false);
        if (data == null) {
            return;
        }
        data.deleteTrader(traderID);
    }
}

