/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import io.github.lightman314.lightmanscurrency.api.ejection.SafeEjectionAPI;
import io.github.lightman314.lightmanscurrency.api.ejection.builtin.BasicEjectionData;
import io.github.lightman314.lightmanscurrency.api.misc.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.api.misc.world.WorldPosition;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.data.types.TaxDataCache;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TaxBlockEntity
extends EasyBlockEntity {
    private long taxEntryID = -1L;
    private boolean validBreak = false;

    public final TaxEntry getTaxEntry() {
        return TaxDataCache.TYPE.get(this).getEntry(this.taxEntryID);
    }

    public TaxBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntities.TAX_BLOCK.get(), pos, state);
    }

    protected TaxBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void initialize(Player owner) {
        this.taxEntryID = TaxDataCache.TYPE.get(this).createEntry(this, owner);
        this.m_6596_();
        BlockEntityUtil.sendUpdatePacket(this);
    }

    public void flagAsValidBreak() {
        this.validBreak = true;
    }

    public List<ItemStack> getContents(boolean dropBlock) {
        TaxEntry entry;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (dropBlock) {
            drops.add(new ItemStack((ItemLike)this.m_58900_().m_60734_()));
        }
        if ((entry = this.getTaxEntry()) != null) {
            for (MoneyValue value : entry.getStoredMoney().allValues()) {
                List<ItemStack> items = value.onBlockBroken(entry.getOwner());
                if (items == null) continue;
                drops.addAll(items);
            }
            entry.clearStoredMoney();
        }
        return drops;
    }

    public void onRemove() {
        TaxEntry entry = this.getTaxEntry();
        if (entry != null) {
            if (!this.validBreak) {
                BasicEjectionData data = new BasicEjectionData(entry.getOwner(), this.getContents(true), (Component)entry.getName());
                SafeEjectionAPI.getApi().handleEjection(this.f_58857_, this.f_58858_, data);
                this.validBreak = true;
            }
            TaxDataCache.TYPE.get(this).removeEntry(this.taxEntryID);
        }
    }

    @Override
    public void onLoad() {
        if (this.isClient()) {
            BlockEntityUtil.requestUpdatePacket(this);
        } else {
            TaxEntry entry = this.getTaxEntry();
            if (entry != null) {
                entry.moveCenter(WorldPosition.ofBE(this));
            }
        }
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag compound) {
        compound.m_128356_("EntryID", this.taxEntryID);
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("EntryID")) {
            this.taxEntryID = compound.m_128454_("EntryID");
        }
    }
}

