/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelLocation;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.SlotMachineTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.SlotMachineBlock;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.joml.Vector3f;

public class SlotMachineBlockEntityRenderer
implements BlockEntityRenderer<SlotMachineTraderBlockEntity> {
    private SlotMachineBlockEntityRenderer() {
    }

    public static SlotMachineBlockEntityRenderer create(BlockEntityRendererProvider.Context ignored) {
        return new SlotMachineBlockEntityRenderer();
    }

    public void render(@Nonnull SlotMachineTraderBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int lightLevel, int overlay) {
        Block block = blockEntity.m_58900_().m_60734_();
        if (block instanceof SlotMachineBlock) {
            SlotMachineBlock block2 = (SlotMachineBlock)block;
            Minecraft mc = Minecraft.m_91087_();
            ResourceLocation lightModel = block2.getLightModel();
            ModelVariant variant = ModelVariantDataManager.getVariant(blockEntity.getCurrentVariant());
            BakedModel model = mc.m_91304_().getModel(lightModel);
            if (variant != null && variant.getTargets().contains(block2.getBlockID()) && variant.getModels().size() == block2.requiredModels()) {
                VariantModelLocation newModel = VariantModelLocation.basic(blockEntity.getCurrentVariant(), block2.getBlockID(), block2.requiredModels() - 1);
                model = ModelVariantDataManager.getModel(newModel);
            }
            if (lightModel == null) {
                return;
            }
            poseStack.m_85836_();
            Direction facing = block2.getFacing(blockEntity.m_58900_());
            Vector3f corner = IRotatableBlock.getOffsetVect(facing);
            Vector3f right = IRotatableBlock.getRightVect(facing);
            Vector3f forward = IRotatableBlock.getForwardVect(facing);
            Vector3f offset = MathUtil.VectorAdd(corner, MathUtil.VectorMult(right, 0.5f), MathUtil.VectorMult(forward, 0.5f), new Vector3f(0.0f, 0.5f, 0.0f));
            poseStack.m_252880_(offset.x, offset.y, offset.z);
            poseStack.m_252781_(MathUtil.fromAxisAngleDegree(MathUtil.getYP(), (float)facing.m_122416_() * -90.0f));
            ItemRenderer itemRenderer = mc.m_91291_();
            itemRenderer.m_115143_(new ItemStack((ItemLike)block2), ItemDisplayContext.FIXED, false, poseStack, bufferSource, 0xF000F0, OverlayTexture.f_118083_, model);
            poseStack.m_85849_();
        }
    }
}

