/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.display;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class TextDisplayEntry
extends DisplayEntry {
    private final Component text;
    private final TextRenderUtil.TextFormatting format;
    private final boolean fullHitbox;

    private TextDisplayEntry(Component text, TextRenderUtil.TextFormatting format, List<Component> tooltip, boolean fullHitbox) {
        super(tooltip);
        this.text = text;
        this.format = format;
        this.fullHitbox = fullHitbox;
    }

    public static TextDisplayEntry of(Component text, TextRenderUtil.TextFormatting format) {
        return new TextDisplayEntry(text, format, null, false);
    }

    public static TextDisplayEntry of(Component text, TextRenderUtil.TextFormatting format, boolean fullHitbox) {
        return new TextDisplayEntry(text, format, null, fullHitbox);
    }

    public static TextDisplayEntry of(Component text, TextRenderUtil.TextFormatting format, List<Component> tooltip) {
        return new TextDisplayEntry(text, format, tooltip, false);
    }

    public static TextDisplayEntry of(Component text, TextRenderUtil.TextFormatting format, List<Component> tooltip, boolean fullHitbox) {
        return new TextDisplayEntry(text, format, tooltip, fullHitbox);
    }

    protected int getTextLeft(int x, int availableWidth) {
        if (this.format.centering().isCenter()) {
            return x + availableWidth / 2 - this.getTextWidth() / 2;
        }
        if (this.format.centering().isRight()) {
            return x + availableWidth - this.getTextWidth();
        }
        return x;
    }

    protected int getTextTop(int y, int availableHeight) {
        if (this.format.centering().isMiddle()) {
            int n = y + availableHeight / 2;
            Objects.requireNonNull(this.getFont());
            return n - 9 / 2;
        }
        if (this.format.centering().isBottom()) {
            Objects.requireNonNull(this.getFont());
            return y + availableHeight - 9;
        }
        return y;
    }

    protected int getTextWidth() {
        return this.getFont().m_92852_((FormattedText)this.text);
    }

    @Override
    public void render(EasyGuiGraphics gui, int x, int y, DisplayData area) {
        if (this.text.getString().isBlank()) {
            return;
        }
        gui.resetColor();
        int left = this.getTextLeft(x + area.xOffset(), area.width());
        int top = this.getTextTop(y + area.yOffset(), area.height());
        gui.resetColor();
        gui.drawShadowed(this.text, left, top, this.format.color());
    }

    @Override
    public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
        int n;
        int width;
        int left = this.fullHitbox ? x + area.xOffset() : this.getTextLeft(x + area.xOffset(), area.width());
        int top = this.fullHitbox ? y + area.yOffset() : this.getTextTop(y + area.yOffset(), area.height());
        int n2 = width = this.fullHitbox ? area.width() : this.getTextWidth();
        if (this.fullHitbox) {
            n = area.height();
        } else {
            Objects.requireNonNull(this.getFont());
            n = 9;
        }
        int height = n;
        return mouseX >= left && mouseX < left + width && mouseY >= top && mouseY < top + height;
    }
}

