/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.ITab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.IRotatableWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.WidgetRotation;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SmallTabButton
extends EasyButton
implements ITooltipSource,
IRotatableWidget {
    public static final ResourceLocation GUI_TEXTURE = IconAndButtonUtil.WIDGET_TEXTURE;
    public static final Pair<ResourceLocation, ScreenPosition> NORMAL = Pair.of((Object)GUI_TEXTURE, (Object)ScreenPosition.of(210, 100));
    public static final Pair<ResourceLocation, ScreenPosition> YELLOW = Pair.of((Object)GUI_TEXTURE, (Object)ScreenPosition.of(170, 0));
    public static final Pair<ResourceLocation, ScreenPosition> RED = Pair.of((Object)GUI_TEXTURE, (Object)ScreenPosition.of(130, 0));
    public static final int SIZE = 20;
    public static final int NEGATIVE_SIZE = -20;
    public boolean hideTooltip = false;
    public final ITab tab;
    private WidgetRotation rotation;

    protected SmallTabButton(Builder builder) {
        super(builder);
        this.tab = builder.tab;
        this.rotation = builder.rotation;
    }

    @Deprecated
    public void reposition(ScreenPosition pos, int rotation) {
        this.reposition(pos.x, pos.y, rotation);
    }

    @Deprecated
    public void reposition(int x, int y, int rotation) {
        this.m_264152_(x, y);
        this.rotation = WidgetRotation.fromIndex(rotation);
    }

    @Override
    public void setRotation(@Nonnull WidgetRotation rotation) {
        this.rotation = rotation;
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        gui.resetColor();
        int xOffset = this.rotation.ordinal() < 2 ? 0 : this.f_93618_;
        int yOffset = (this.rotation.ordinal() % 2 == 0 ? 0 : 2 * this.f_93619_) + (this.f_93623_ ? 0 : this.f_93619_);
        Pair<ResourceLocation, ScreenPosition> sprite = this.getSprite();
        gui.blit((ResourceLocation)sprite.getFirst(), 0, 0, ((ScreenPosition)sprite.getSecond()).x + xOffset, ((ScreenPosition)sprite.getSecond()).y + yOffset, this.f_93618_, this.f_93619_);
        float m = this.f_93623_ ? 1.0f : 0.5f;
        gui.setColor(m, m, m);
        this.tab.getIcon().render(gui, SmallTabButton.getIconOffset(this.rotation));
        gui.resetColor();
    }

    public static ScreenPosition getIconOffset(WidgetRotation rotation) {
        return switch (rotation) {
            case WidgetRotation.TOP -> ScreenPosition.of(2, 3);
            case WidgetRotation.BOTTOM -> ScreenPosition.of(2, 1);
            case WidgetRotation.LEFT -> ScreenPosition.of(3, 2);
            case WidgetRotation.RIGHT -> ScreenPosition.of(1, 2);
            default -> ScreenPosition.of(2, 2);
        };
    }

    protected Pair<ResourceLocation, ScreenPosition> getSprite() {
        Pair<ResourceLocation, ScreenPosition> result = this.tab.getSprite();
        return result == null ? NORMAL : result;
    }

    @Override
    public List<Component> getTooltipText(int mouseX, int mouseY) {
        if (this.hideTooltip || !this.isVisible()) {
            return null;
        }
        if (this.getArea().isMouseInArea(mouseX, mouseY)) {
            return ImmutableList.of((Object)this.tab.getTooltip());
        }
        return null;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    @ParametersAreNonnullByDefault
    public static class Builder
    extends EasyButton.EasyButtonBuilder<Builder> {
        @Nullable
        private ITab tab = null;
        private WidgetRotation rotation = WidgetRotation.TOP;

        protected Builder() {
            super(20, 20);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder tab(ITab tab) {
            this.tab = tab;
            return this;
        }

        public Builder rotation(WidgetRotation rotation) {
            this.rotation = rotation;
            return this;
        }

        public SmallTabButton build() {
            return new SmallTabButton(this);
        }
    }
}

