/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class BankAccountSelectButton
extends EasyButton
implements ITooltipWidget {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/buttons.png");
    public static final int HEIGHT = 20;
    private final Supplier<BankReference> selectedAccount;
    private final Supplier<BankReference> account;
    private final Supplier<Boolean> parentVisible;

    private BankAccountSelectButton(@Nonnull Builder builder) {
        super(builder);
        this.selectedAccount = builder.selectedAccount;
        this.account = builder.account;
        this.parentVisible = builder.visible;
    }

    @Nonnull
    private Component accountName() {
        IBankAccount account;
        BankReference br = this.account.get();
        IBankAccount iBankAccount = account = br != null ? br.get() : null;
        if (account == null) {
            return EasyText.empty();
        }
        return account.getName();
    }

    @Override
    public boolean renderTooltip(@Nonnull EasyGuiGraphics gui) {
        if (gui.font.m_92852_((FormattedText)this.accountName()) > this.f_93618_ - 22) {
            return ITooltipWidget.super.renderTooltip(gui);
        }
        return false;
    }

    @Override
    public List<Component> getTooltipText() {
        return Lists.newArrayList((Object[])new Component[]{this.accountName()});
    }

    @Override
    protected void renderTick() {
        BankReference reference = this.account.get();
        this.setVisible(this.parentVisible.get() != false && reference != null && reference.get() != null);
        if (this.f_93624_) {
            this.setActive(!reference.equals(this.selectedAccount.get()));
        }
    }

    @Override
    protected void renderWidget(@Nonnull EasyGuiGraphics gui) {
        BankReference reference = this.account.get();
        if (reference == null) {
            this.setVisible(false);
            return;
        }
        float color = this.m_142518_() ? 1.0f : 0.5f;
        gui.setColor(color, color, color);
        gui.blitHorizSplit(GUI_TEXTURE, 0, 0, this.f_93618_, this.f_93619_, 0, 0, 256, 5);
        IconData icon = reference.getIcon();
        if (icon != null) {
            icon.render(gui, 2, 2);
        }
        int textColor = this.m_142518_() ? -1 : -6283232;
        gui.drawScrollingString(this.accountName(), ScreenArea.of(22, 0, this.f_93618_ - 24, this.f_93619_), textColor);
        gui.resetColor();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyButton.EasyButtonBuilder<Builder> {
        Supplier<BankReference> selectedAccount = () -> null;
        Supplier<BankReference> account = () -> null;
        Supplier<Boolean> visible = () -> true;

        private Builder() {
            super(100, 20);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder width(int width) {
            this.changeWidth(width);
            return this;
        }

        public Builder currentlySelected(Supplier<BankReference> selectedAccount) {
            this.selectedAccount = selectedAccount;
            return this;
        }

        public Builder account(Supplier<BankReference> account) {
            this.account = account;
            return this;
        }

        public Builder visible(Supplier<Boolean> visible) {
            this.visible = visible;
            return this;
        }

        public BankAccountSelectButton build() {
            return new BankAccountSelectButton(this);
        }
    }
}

