/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.TeamManagementMenu;
import io.github.lightman314.lightmanscurrency.common.menus.teams.TeamManagementClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.teams.tabs.TeamSalaryInfoTab;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TeamSalaryInfoClientTab
extends TeamManagementClientTab<TeamSalaryInfoTab> {
    public TeamSalaryInfoClientTab(@Nonnull Object screen, @Nonnull TeamSalaryInfoTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of(IconUtil.ICON_TRADER_ALT);
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_TEAM_SALARY_INFO.get(new Object[0]);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        if (team == null) {
            return;
        }
        int center = ((TeamManagerScreen)this.screen).getXSize() / 2;
        if (!team.isAutoSalaryEnabled()) {
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TEAM_SALARY_INFO_DISABLED.get(new Object[0]), center, 16, (int)ChatFormatting.YELLOW.m_126665_(), true);
        }
        if (team.getSalaryDelay() > 0L) {
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TEAM_SALARY_INFO_DELAY.get(new TimeUtil.TimeData(team.getSalaryDelay()).getShortString()), center, 30, 0x404040);
            if (team.isAutoSalaryEnabled()) {
                long nextTrigger = team.getLastSalaryTime() + team.getSalaryDelay();
                long timeUntilNextTrigger = Math.max(0L, nextTrigger - TimeUtil.getCurrentTime());
                TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TEAM_SALARY_INFO_NEXT_TRIGGER.get(new TimeUtil.TimeData(timeUntilNextTrigger).getShortString(2)), center, 42, 0x404040);
            }
        }
        if (!team.getMemberSalary().isEmpty()) {
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TEAM_SALARY_INFO_SALARY_MEMBERS.get(team.getMemberSalary().getText()), center, 54, 0x404040);
        }
        if (team.isAdmin(((TeamManagementMenu)this.menu).player)) {
            int offset;
            List<MoneyValue> values;
            if (team.isAdminSalarySeperate() && !team.getAdminSalary().isEmpty()) {
                TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TEAM_SALARY_INFO_SALARY_ADMINS.get(team.getAdminSalary().getText()), center, 66, 0x404040);
            }
            if (!(values = team.getTotalSalaryCost(false)).isEmpty()) {
                gui.drawString((Component)LCText.GUI_TEAM_SALARY_INFO_REQUIRED_FUNDS.get(new Object[0]), 20, 80, 0x404040);
                offset = 10;
                for (MoneyValue value : values) {
                    gui.drawString((Component)value.getText(), 25, 80 + offset, 0x404040);
                    offset += 10;
                }
            }
            if (team.getLoginRequiredForSalary() && !(values = team.getTotalSalaryCost(true)).isEmpty()) {
                gui.drawString((Component)LCText.GUI_TEAM_SALARY_INFO_CURRENT_REQUIRED_FUNDS.get(new Object[0]), 20, 110, 0x404040);
                offset = 10;
                for (MoneyValue value : values) {
                    gui.drawString((Component)value.getText(), 25, 110 + offset, 0x404040);
                    offset += 10;
                }
            }
            MutableComponent fundsWarning = null;
            if (!team.canAffordNextSalary(true)) {
                fundsWarning = LCText.GUI_TEAM_SALARY_INFO_INSUFFICIENT_FUNDS.get(new Object[0]);
            } else if (!team.canAffordNextSalary(false)) {
                fundsWarning = LCText.GUI_TEAM_SALARY_INFO_POSSIBLE_INSUFFICIENT_FUNDS.get(new Object[0]);
            }
            if (fundsWarning != null) {
                TextRenderUtil.drawCenteredMultilineText(gui, (Component)fundsWarning, 10, ((TeamManagerScreen)this.screen).getXSize() - 20, 144, (int)ChatFormatting.YELLOW.m_126665_(), true);
            }
            if (team.failedLastSalaryAttempt()) {
                TextRenderUtil.drawCenteredMultilineText(gui, (Component)LCText.GUI_TEAM_SALARY_INFO_LAST_ATTEMPT_FAILED.get(new Object[0]), 10, ((TeamManagerScreen)this.screen).getXSize() - 20, 175, (int)ChatFormatting.YELLOW.m_126665_(), true);
            }
        }
    }
}

