/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.permissions.PermissionOption;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PermissionsTab
extends SettingsSubTab
implements IScrollable {
    public static final int PERMISSIONS_PER_PAGE = 8;
    private static final int START_HEIGHT = 20;
    public static final int ROW_HEIGHT = 14;
    List<PermissionOption> options;
    private int scroll = 0;

    public PermissionsTab(@Nonnull TraderSettingsClientTab parent) {
        super(parent);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_41997_);
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TRADER_SETTINGS_ALLY_PERMS.get(new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return this.menu.hasPermission("editPermissions");
    }

    public boolean isOptionVisible(PermissionOption option) {
        int index = this.options.indexOf(option);
        return index >= this.scroll && index < this.scroll + 8;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.options = new ArrayList<PermissionOption>();
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            this.options.addAll(trader.getPermissionOptions());
        }
        int startHeight = screenArea.y + 20;
        int xPos = screenArea.x + 20;
        for (int i = 0; i < this.options.size(); ++i) {
            int yPos = startHeight + 14 * i;
            PermissionOption option = this.options.get(i);
            option.initWidgets(this, xPos, yPos, this::addChild);
        }
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(screenArea.width - 20, 20))).height(112).scrollable(this).build());
        this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().position(screenArea.pos)).size(screenArea.width, 150)).listener(this).build());
        this.updateWidgetPositions();
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        int index;
        gui.drawString((Component)LCText.TOOLTIP_TRADER_SETTINGS_ALLY_PERMS.get(new Object[0]), 8, 6, 0x404040);
        for (int i = 0; i < 8 && (index = i + this.scroll) < this.options.size(); ++i) {
            PermissionOption option = this.options.get(index);
            int xPos = 20 + option.widgetWidth();
            int yPos = 20 + 14 * i + 3;
            gui.drawString((Component)option.widgetName(), xPos, yPos, 0x404040);
        }
    }

    private void updateWidgetPositions() {
        int index;
        int xPos = this.screen.getGuiLeft() + 20;
        int startY = this.screen.getGuiTop() + 20;
        for (int i = 0; i < 8 && (index = i + this.scroll) < this.options.size(); ++i) {
            this.options.get(index).updateWidgetPosition(xPos, startY + 14 * i);
        }
    }

    @Override
    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        int index;
        int startHeight = 20;
        for (int i = 0; i < 8 && (index = i + this.scroll) < this.options.size(); ++i) {
            int textWidth;
            int yPos;
            PermissionOption option = this.options.get(index);
            int xPos = 20 + option.widgetWidth();
            if (!ScreenArea.of(xPos, yPos = 20 + 14 * i, textWidth = 150 - option.widgetWidth(), 14).offsetPosition(this.screen.getCorner()).isMouseInArea(gui.mousePos)) continue;
            MutableComponent tooltip = option.widgetTooltip();
            if (tooltip == null) break;
            gui.renderComponentTooltip(TooltipHelper.splitTooltips((Component)tooltip, new ChatFormatting[0]));
            break;
        }
    }

    @Override
    public void tick() {
        for (PermissionOption option : this.options) {
            option.tick();
        }
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.updateWidgetPositions();
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(8, this.options.size());
    }
}

