/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.command;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionHandler;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.command.CommandEditField;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.command.CommandTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.traders.commands.tradedata.CommandTrade;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class CommandTradeEditClientTab
extends TraderStorageClientTab<CommandTradeEditTab>
implements IMouseListener,
TradeInteractionHandler {
    TradeButton tradeDisplay;
    MoneyValueWidget priceSelection;
    CommandEditField commandInput;
    PlainButton buttonToggleDetails;
    EditBox descriptionInput;
    EditBox tooltipInput;
    boolean commandEdit = true;
    static boolean displayDetails = false;

    public CommandTradeEditClientTab(Object screen, CommandTradeEditTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.Null();
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return EasyText.empty();
    }

    @Override
    public boolean shouldRenderInventoryText() {
        return false;
    }

    @Override
    public boolean tabVisible() {
        return false;
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public int getTradeRuleTradeIndex() {
        return ((CommandTradeEditTab)this.commonTab).getTradeIndex();
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        CommandTrade trade = ((CommandTradeEditTab)this.commonTab).getTrade();
        this.tradeDisplay = this.addChild(((TradeButton.Builder)TradeButton.builder().position(screenArea.pos.offset(10, 18))).context(((ITraderStorageMenu)this.menu)::getContext).trade(((CommandTradeEditTab)this.commonTab)::getTrade).build());
        this.priceSelection = this.addChild(((MoneyValueWidget.Builder)((MoneyValueWidget.Builder)MoneyValueWidget.builder().position(screenArea.pos.offset(screenArea.width / 2 - 88, 40))).oldIfNotFirst(firstOpen, this.priceSelection).startingValue(trade).valueHandler(this::onValueChanged).addon(EasyAddonHelper.visibleCheck(() -> !this.commandEdit))).build());
        this.buttonToggleDetails = this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(109, 45))).sprite(IconAndButtonUtil.SPRITE_CHECK(() -> displayDetails)).pressAction(this::toggleDetailMode)).addon(EasyAddonHelper.visibleCheck(() -> this.commandEdit))).build());
        this.commandInput = this.addChild(((CommandEditField.Builder)((CommandEditField.Builder)CommandEditField.builder().position(screenArea.pos.offset(13, 55))).width(screenArea.width - 26)).oldIfNotFirst(firstOpen, this.commandInput).handler(this::onCommandChanged).suggestions(6).showSuggestions(() -> !displayDetails).startingValue(trade != null ? trade.getCommand() : "").build());
        this.descriptionInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 13, screenArea.y + 98, screenArea.width - 26, 20, this.descriptionInput, (Component)EasyText.empty()));
        if (trade != null) {
            this.descriptionInput.m_94144_(trade.getDescription());
        }
        this.descriptionInput.m_94151_(this::onDescriptionChanged);
        this.tooltipInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 13, screenArea.y + 130, screenArea.width - 26, 20, this.tooltipInput, (Component)EasyText.empty()));
        this.tooltipInput.m_94199_(256);
        if (trade != null) {
            this.tooltipInput.m_94144_(trade.getTooltip());
        }
        this.tooltipInput.m_94151_(this::onTooltipChanged);
    }

    private void onValueChanged(MoneyValue value) {
        ((CommandTradeEditTab)this.commonTab).setPrice(value);
    }

    private void onCommandChanged(String newCommand) {
        ((CommandTradeEditTab)this.commonTab).setCommand(newCommand);
    }

    private void onDescriptionChanged(String newDescription) {
        ((CommandTradeEditTab)this.commonTab).setDescription(newDescription);
    }

    private void onTooltipChanged(String newTooltip) {
        ((CommandTradeEditTab)this.commonTab).setTooltip(newTooltip);
    }

    @Override
    public void tick() {
        this.commandInput.f_93624_ = this.commandEdit;
        this.tooltipInput.f_93624_ = this.commandEdit && displayDetails;
        this.descriptionInput.f_93624_ = this.tooltipInput.f_93624_;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        if (this.commandEdit) {
            gui.drawString((Component)LCText.GUI_TRADER_COMMAND_LABEL.get(new Object[0]), 15, 46, 0x404040);
            gui.drawString((Component)LCText.GUI_TRADER_COMMAND_LABEL_DETAILS.get(new Object[0]), 120, 46, 0x404040);
            if (displayDetails) {
                gui.drawString((Component)LCText.GUI_TRADER_COMMAND_LABEL_DESCRIPTION.get(new Object[0]), 15, 89, 0x404040);
                gui.drawString((Component)LCText.GUI_TRADER_COMMAND_LABEL_TOOLTIP.get(new Object[0]), 15, 121, 0x404040);
            }
        }
    }

    @Override
    protected void OpenMessage(@Nonnull LazyPacketData clientData) {
        if (clientData.contains("CommandEdit")) {
            this.commandEdit = clientData.getBoolean("CommandEdit");
        }
    }

    private void toggleDetailMode() {
        displayDetails = !displayDetails;
    }

    @Override
    public void HandleTradeInputInteraction(@Nonnull TraderData trader, @Nonnull TradeData trade, @Nonnull TradeInteractionData data, int inputIndex) {
        if (this.commandEdit) {
            this.commandEdit = false;
            this.tick();
        }
    }

    @Override
    public void HandleTradeOutputInteraction(@Nonnull TraderData trader, @Nonnull TradeData trade, @Nonnull TradeInteractionData data, int outputIndex) {
        if (!this.commandEdit) {
            this.commandEdit = true;
            this.tick();
        }
    }

    @Override
    public void HandleOtherTradeInteraction(@Nonnull TraderData trader, @Nonnull TradeData trade, @Nonnull TradeInteractionData data) {
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        this.tradeDisplay.HandleInteractionClick((int)mouseX, (int)mouseY, button, this);
        return false;
    }
}

