/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.TerminalSorter;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.NetworkTraderButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.base.TraderSelectTab;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TraderSelectClientTab
extends TraderInterfaceClientTab<TraderSelectTab>
implements IScrollable {
    EditBox searchField;
    ScrollBarWidget scrollBar;
    List<NetworkTraderButton> traderButtons = new ArrayList<NetworkTraderButton>();
    private int scroll;
    private List<TraderData> filteredTraderList = new ArrayList<TraderData>();

    public TraderSelectClientTab(Object screen, TraderSelectTab tab) {
        super(screen, tab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of(ModBlocks.TERMINAL);
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_INTERFACE_TRADER_SELECT.get(new Object[0]);
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    private List<TraderData> traderList() {
        List<TraderData> traderList = this.filterTraders(TraderAPI.API.GetAllNetworkTraders(true));
        traderList.sort(TerminalSorter.getDefaultSorter());
        return traderList;
    }

    private List<TraderData> filterTraders(List<TraderData> allTraders) {
        ArrayList<TraderData> traders = new ArrayList<TraderData>();
        TraderInterfaceBlockEntity be = ((TraderInterfaceMenu)this.menu).getBE();
        if (be == null) {
            return traders;
        }
        TraderInterfaceBlockEntity.InteractionType interaction = be.getInteractionType();
        for (TraderData trader : allTraders) {
            if (!be.validTraderType(trader) || (!interaction.trades() || !trader.hasValidTrade()) && (!interaction.targetsTraders() || !be.hasTraderPermissions(trader))) continue;
            traders.add(trader);
        }
        return traders;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.searchField = this.addChild(new EditBox(this.getFont(), screenArea.x + 43, screenArea.y + 6, 101, 9, firstOpen ? null : this.searchField, (Component)LCText.GUI_NETWORK_TERMINAL_SEARCH.get(new Object[0])));
        this.searchField.m_94182_(false);
        this.searchField.m_94199_(32);
        this.searchField.m_94202_(0xFFFFFF);
        this.searchField.m_94151_(this::onSearchChanged);
        this.initTraderButtons(screenArea.pos);
        this.scrollBar = this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(176, 18))).height(120).scrollable(this).build());
        this.tick();
        this.updateTraderList();
        this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().position(0, 0)).size(((TraderInterfaceScreen)this.screen).f_96543_, ((TraderInterfaceScreen)this.screen).f_96544_)).listener(this).build());
    }

    private void initTraderButtons(ScreenPosition corner) {
        this.traderButtons = new ArrayList<NetworkTraderButton>();
        for (int y = 0; y < 4; ++y) {
            int buttonIndex = y;
            NetworkTraderButton newButton = this.addChild(((NetworkTraderButton.Builder)((NetworkTraderButton.Builder)NetworkTraderButton.builder().position(corner.offset(30, 18 + y * 30))).pressAction(() -> this.ToggleTrader(buttonIndex))).build());
            this.traderButtons.add(newButton);
        }
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.resetColor();
        gui.blit(TraderInterfaceScreen.GUI_TEXTURE, 28, 4, 0, 236, 117, 12);
    }

    @Override
    public void tick() {
        List<TraderData> selectedTraders = ((TraderInterfaceMenu)this.menu).getBE().targets.getTraders();
        for (NetworkTraderButton button : this.traderButtons) {
            button.selected = button.getData() != null && selectedTraders.contains(button.getData());
        }
    }

    private void onSearchChanged(String newSearch) {
        this.updateTraderList();
    }

    private void ToggleTrader(int traderButtonIndex) {
        int index = traderButtonIndex + this.scroll;
        if (index >= 0 && index < this.filteredTraderList.size()) {
            long traderID = this.filteredTraderList.get(index).getID();
            ((TraderSelectTab)this.commonTab).toggleTrader(traderID);
        }
    }

    private int getTraderIndex(EasyButton button) {
        if (button instanceof NetworkTraderButton) {
            if (!this.traderButtons.contains((Object)button)) {
                return -1;
            }
            int index = this.traderButtons.indexOf((Object)button);
            return index += this.scroll;
        }
        return -1;
    }

    @Override
    public int getMaxScroll() {
        return Math.max(this.filteredTraderList.size() - this.traderButtons.size(), 0);
    }

    private int scrollOf(TraderData trader) {
        if (this.filteredTraderList != null) {
            int index = this.filteredTraderList.indexOf(trader);
            if (index >= 0) {
                return Math.min(index, this.getMaxScroll());
            }
            return this.scroll;
        }
        return this.scroll;
    }

    private void updateTraderList() {
        this.filteredTraderList = TraderAPI.API.FilterTraders(this.traderList(), this.searchField.m_94155_());
        this.updateTraderButtons();
        if (this.scroll > this.getMaxScroll()) {
            this.scroll = this.getMaxScroll();
        }
    }

    private void updateTraderButtons() {
        int startIndex = this.scroll;
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            if (startIndex + i < this.filteredTraderList.size()) {
                this.traderButtons.get(i).SetData(this.filteredTraderList.get(startIndex + i));
                continue;
            }
            this.traderButtons.get(i).SetData(null);
        }
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = Math.min(newScroll, this.getMaxScroll());
        this.updateTraderButtons();
    }
}

