/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.items.data.FilterData;
import io.github.lightman314.lightmanscurrency.common.menus.ItemFilterMenu;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemFilterScreen
extends EasyMenuScreen<ItemFilterMenu>
implements IScrollable {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/container/item_filter.png");
    public static final int ROWS = 5;
    private ItemStack fakeSlotItem = ItemStack.f_41583_;
    private int scroll = 0;
    private final List<FilterOption> filterOptions = new ArrayList<FilterOption>();
    private ScreenArea filterItemArea = ScreenArea.of(0, 0, 18, 18);
    private ScreenArea fakeSlotArea = ScreenArea.of(0, 0, 18, 18);

    public ItemFilterScreen(ItemFilterMenu menu, Inventory inventory, Component ignored) {
        super(menu, inventory);
        this.resize(176, 216);
        ((ItemFilterMenu)this.f_97732_).setQuickMoveConsumer(this::setFakeSlotItem);
    }

    public void setFakeSlotItem(ItemStack item) {
        if (item.m_41720_() == this.fakeSlotItem.m_41720_()) {
            this.fakeSlotItem = item.m_255036_(1);
            return;
        }
        this.fakeSlotItem = item.m_255036_(1);
        this.filterOptions.clear();
        if (this.fakeSlotItem.m_41619_()) {
            this.scroll = 0;
            return;
        }
        Item newItem = this.fakeSlotItem.m_41720_();
        this.filterOptions.add(new ItemFilterOption(BuiltInRegistries.f_257033_.m_7981_((Object)newItem), new ItemStack((ItemLike)newItem)));
        this.fakeSlotItem.m_204131_().forEach(key -> this.filterOptions.add(new TagFilterOption(key.f_203868_())));
        this.validateScroll();
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.filterItemArea = this.filterItemArea.atPosition(screenArea.pos.offset(7, 17));
        this.fakeSlotArea = this.fakeSlotArea.atPosition(screenArea.pos.offset(7, 101));
        this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().listener(this).position(screenArea.pos.offset(25, 17))).size(144, 102)).build());
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(161, 17))).height(102).scrollable(this).build());
        int i = 0;
        while (i < 5) {
            int index = i++;
            this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(140, 18 + 20 * index))).icon(() -> this.getIcon(index)).pressAction(() -> this.toggleOption(index))).addon(EasyAddonHelper.visibleCheck(() -> this.optionExists(index)))).build());
        }
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.renderNormalBackground(GUI_TEXTURE, this);
        ItemStack filterItem = ((ItemFilterMenu)this.f_97732_).getTargetedStack();
        gui.drawString(filterItem.m_41786_(), 6, 8, 0x404040);
        gui.renderItem(filterItem, 8, 18);
        gui.renderItem(this.fakeSlotItem, 8, 102);
        FilterData data = ((ItemFilterMenu)this.f_97732_).getData();
        for (int i = 0; i < 5; ++i) {
            FilterOption option = this.getOption(i);
            if (option == null) continue;
            int color = option.isActive(data) ? 65280 : 0xFFFFFF;
            Component text = TextRenderUtil.fitString(option.getText(), 112, "");
            gui.drawString(text, 28, 24 + 20 * i, color);
        }
    }

    @Override
    protected void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        int index;
        FilterOption option;
        if (this.filterItemArea.isMouseInArea(gui.mousePos)) {
            gui.renderTooltip(((ItemFilterMenu)this.f_97732_).getTargetedStack());
        } else if (this.fakeSlotArea.isMouseInArea(gui.mousePos) && !this.fakeSlotItem.m_41619_()) {
            gui.renderTooltip(this.fakeSlotItem);
        }
        ScreenPosition corner = this.getCorner();
        ScreenPosition mousePos = gui.mousePos;
        if (mousePos.x >= corner.x + 26 && mousePos.x < corner.x + 140 && mousePos.y >= corner.y + 18 && mousePos.y < corner.y + 118 && (option = this.getOption(index = (mousePos.y - corner.y - 18) / 20)) != null) {
            gui.renderComponentTooltip(TooltipHelper.splitTooltips(option.getText(), new ChatFormatting[0]));
        }
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(5, this.filterOptions.size());
    }

    private boolean optionExists(int relativeIndex) {
        return this.getOption(relativeIndex) != null;
    }

    private IconData getIcon(int relativeIndex) {
        FilterOption option = this.getOption(relativeIndex);
        if (option != null && option.isActive(((ItemFilterMenu)this.f_97732_).getData())) {
            return IconUtil.ICON_MINUS;
        }
        return IconUtil.ICON_PLUS;
    }

    @Nullable
    private FilterOption getOption(int relativeIndex) {
        int index = relativeIndex + this.scroll;
        if (index < 0 || index >= this.filterOptions.size()) {
            return null;
        }
        return this.filterOptions.get(index);
    }

    private void toggleOption(int relativeIndex) {
        FilterOption option = this.getOption(relativeIndex);
        if (option != null) {
            if (option.isActive(((ItemFilterMenu)this.f_97732_).getData())) {
                option.onRemove((ItemFilterMenu)this.f_97732_);
            } else {
                option.onAdd((ItemFilterMenu)this.f_97732_);
            }
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.fakeSlotArea.isMouseInArea(mouseX, mouseY)) {
            this.setFakeSlotItem(((ItemFilterMenu)this.f_97732_).m_142621_());
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private record ItemFilterOption(ResourceLocation itemID, ItemStack item) implements FilterOption
    {
        @Override
        public Component getText() {
            return this.item.m_41786_();
        }

        @Override
        public boolean isActive(FilterData filter) {
            return filter.entries().contains(this.itemID);
        }

        @Override
        public void onAdd(ItemFilterMenu menu) {
            menu.SendMessage(menu.builder().setResourceLocation("AddEntry", this.itemID));
        }

        @Override
        public void onRemove(ItemFilterMenu menu) {
            menu.SendMessage(menu.builder().setResourceLocation("RemoveEntry", this.itemID));
        }
    }

    private static interface FilterOption {
        public Component getText();

        public boolean isActive(FilterData var1);

        public void onAdd(ItemFilterMenu var1);

        public void onRemove(ItemFilterMenu var1);
    }

    private record TagFilterOption(ResourceLocation tag) implements FilterOption
    {
        @Override
        public Component getText() {
            return EasyText.literal("#" + this.tag.toString());
        }

        @Override
        public boolean isActive(FilterData filter) {
            return filter.tags().contains(this.tag);
        }

        @Override
        public void onAdd(ItemFilterMenu menu) {
            menu.SendMessage(menu.builder().setResourceLocation("AddTag", this.tag));
        }

        @Override
        public void onRemove(ItemFilterMenu menu) {
            menu.SendMessage(menu.builder().setResourceLocation("RemoveTag", this.tag));
        }
    }
}

