/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.ClientEvents;
import io.github.lightman314.lightmanscurrency.client.colors.ATMCardColor;
import io.github.lightman314.lightmanscurrency.client.colors.CouponColor;
import io.github.lightman314.lightmanscurrency.client.colors.GachaBallColor;
import io.github.lightman314.lightmanscurrency.client.colors.GoldenTicketColor;
import io.github.lightman314.lightmanscurrency.client.colors.SusBlockColor;
import io.github.lightman314.lightmanscurrency.client.colors.TicketColor;
import io.github.lightman314.lightmanscurrency.client.gui.overlay.WalletDisplayOverlay;
import io.github.lightman314.lightmanscurrency.client.model.VariantBlockModel;
import io.github.lightman314.lightmanscurrency.client.model.VariantItemModel;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.renderers.EnchantedBookRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.renderers.NormalBookRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.entity.layers.WalletLayer;
import io.github.lightman314.lightmanscurrency.client.renderer.item.GachaBallRenderer;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.CustomModelDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.ItemPositionBlockManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.ItemPositionManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.FreezerBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.GachaMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.SlotMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.variant.IVariantBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="lightmanscurrency", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientModEvents {
    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((ItemColor)new TicketColor(), new ItemLike[]{(ItemLike)ModItems.TICKET.get(), (ItemLike)ModItems.TICKET_PASS.get(), (ItemLike)ModItems.TICKET_MASTER.get()});
        event.register((ItemColor)new CouponColor(), new ItemLike[]{(ItemLike)ModItems.COUPON.get()});
        event.register((ItemColor)new GoldenTicketColor(), new ItemLike[]{(ItemLike)ModItems.GOLDEN_TICKET_PASS.get(), (ItemLike)ModItems.GOLDEN_TICKET_MASTER.get()});
        event.register((ItemColor)new ATMCardColor(), new ItemLike[]{(ItemLike)ModItems.ATM_CARD.get(), (ItemLike)ModItems.PREPAID_CARD.get()});
        event.register((ItemColor)SusBlockColor.INSTANCE, new ItemLike[]{(ItemLike)ModBlocks.SUS_JAR.get()});
        event.register((ItemColor)new GachaBallColor(), new ItemLike[]{(ItemLike)ModItems.GACHA_BALL.get()});
        event.register((stack, layer) -> {
            Item patt3626$temp = stack.m_41720_();
            if (patt3626$temp instanceof DyeableLeatherItem) {
                DyeableLeatherItem item = (DyeableLeatherItem)patt3626$temp;
                return item.m_41121_(stack);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModItems.WALLET_LEATHER.get()});
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((BlockColor)SusBlockColor.INSTANCE, new Block[]{(Block)ModBlocks.SUS_JAR.get()});
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        for (FreezerBlock block2 : ModBlocks.FREEZER.getAll()) {
            event.register(block2.getDoorModel());
        }
        event.register(SlotMachineBlock.LIGHT_MODEL_LOCATION);
        event.register(NormalBookRenderer.MODEL_LOCATION);
        event.register(EnchantedBookRenderer.MODEL_LOCATION);
        ForgeRegistries.ITEMS.forEach(item -> {
            if (item instanceof WalletItem) {
                WalletItem wallet = (WalletItem)((Object)item);
                event.register(wallet.model);
            }
        });
        event.register(GachaBallRenderer.MODEL);
        for (ResourceLocation model : GachaMachineBlock.BASIC_MODELS) {
            event.register(model);
        }
        ForgeRegistries.BLOCKS.forEach(block -> {
            if (block instanceof GachaMachineBlock) {
                GachaMachineBlock b = (GachaMachineBlock)block;
                for (ResourceLocation model : b.getBasicModels()) {
                    event.register(model);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onModelsBaked(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        ArrayList<ModelResourceLocation> wrappedModels = new ArrayList<ModelResourceLocation>();
        for (Block b : ForgeRegistries.BLOCKS) {
            if (!(b instanceof IVariantBlock)) continue;
            IVariantBlock block = (IVariantBlock)b;
            for (BlockState state : b.m_49965_().m_61056_()) {
                ModelResourceLocation modelID = BlockModelShaper.m_110895_((BlockState)state);
                BakedModel existingModel = (BakedModel)modelRegistry.get(modelID);
                if (existingModel != null) {
                    modelRegistry.put(modelID, new VariantBlockModel(block, existingModel));
                    wrappedModels.add(modelID);
                    continue;
                }
                LightmansCurrency.LogDebug("Missing block model:  " + modelID);
            }
            ModelResourceLocation itemModel = new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)b.m_5456_()), "inventory");
            BakedModel existingModel = (BakedModel)modelRegistry.get(itemModel);
            if (existingModel != null) {
                modelRegistry.put(itemModel, new VariantItemModel(block, existingModel));
                wrappedModels.add(itemModel);
                continue;
            }
            LightmansCurrency.LogWarning("Missing item model: " + itemModel);
        }
        LightmansCurrency.LogDebug("Wrapped " + wrappedModels.size() + " models with a custom VariantBlockModel");
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        ClientModEvents.addWalletLayer(event, "default");
        ClientModEvents.addWalletLayer(event, "slim");
    }

    private static void addWalletLayer(EntityRenderersEvent.AddLayers event, String skin) {
        LivingEntityRenderer renderer = event.getSkin(skin);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = renderer;
            livingRenderer.m_115326_(new WalletLayer(livingRenderer));
        }
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ClientEvents.KEY_WALLET);
        if (LCCurios.isLoaded()) {
            event.register(ClientEvents.KEY_PORTABLE_TERMINAL);
            event.register(ClientEvents.KEY_PORTABLE_ATM);
        }
    }

    @SubscribeEvent
    public static void registerWalletGuiOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("wallet_hud", (IGuiOverlay)WalletDisplayOverlay.INSTANCE);
    }

    @SubscribeEvent
    public static void registerResourceListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ItemPositionManager.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)ItemPositionBlockManager.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)CustomModelDataManager.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)ModelVariantDataManager.INSTANCE);
    }
}

