/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.SyncedConfigFile;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.ChestCoinCollectButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.EjectionMenuButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.NotificationButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.TeamManagerButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.wallet.VisibilityToggleButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.wallet.WalletButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.enchantments.MoneyMendingEnchantment;
import io.github.lightman314.lightmanscurrency.common.items.PortableATMItem;
import io.github.lightman314.lightmanscurrency.common.items.PortableTerminalItem;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketOpenATM;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenNetworkTerminal;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketOpenWallet;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.CPacketSetVisible;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lightmanscurrency", value={Dist.CLIENT})
public class ClientEvents {
    public static final ResourceLocation WALLET_SLOT_TEXTURE = VersionUtil.lcResource("textures/gui/container/wallet_slot.png");
    public static final KeyMapping KEY_WALLET = new KeyMapping(LCText.KEY_WALLET.getKey(), 86, "key.categories.inventory");
    public static final KeyMapping KEY_PORTABLE_TERMINAL = new KeyMapping(LCText.KEY_PORTABLE_TERMINAL.getKey(), 92, "key.categories.inventory");
    public static final KeyMapping KEY_PORTABLE_ATM = new KeyMapping(LCText.KEY_PORTABLE_ATM.getKey(), 61, "key.categories.inventory");

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ instanceof WalletScreen && minecraft.f_91074_ != null) {
            if (event.getAction() == 1 && event.getKey() == KEY_WALLET.getKey().m_84873_()) {
                minecraft.f_91074_.m_108763_();
            }
        } else if (minecraft.f_91074_ != null && minecraft.f_91080_ == null) {
            LocalPlayer player = minecraft.f_91074_;
            if (KEY_WALLET.m_90857_()) {
                new CPacketOpenWallet(-1).send();
                ItemStack wallet = CoinAPI.API.getEquippedWallet((Player)player);
                if (!wallet.m_41619_()) {
                    minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11678_, (float)(1.25f + player.m_9236_().f_46441_.m_188501_() * 0.5f), (float)0.75f));
                    if (!WalletItem.isEmpty(wallet)) {
                        minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)ModSounds.COINS_CLINKING.get(), (float)1.0f, (float)0.4f));
                    }
                }
            }
            if (LCCurios.isLoaded() && event.getAction() == 1) {
                if (event.getKey() == KEY_PORTABLE_TERMINAL.getKey().m_84873_() && LCCurios.hasPortableTerminal((LivingEntity)minecraft.f_91074_)) {
                    new CPacketOpenNetworkTerminal(true).send();
                } else if (event.getKey() == KEY_PORTABLE_ATM.getKey().m_84873_() && LCCurios.hasPortableATM((LivingEntity)minecraft.f_91074_)) {
                    CPacketOpenATM.sendToServer();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onInventoryGuiInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            event.addListener((GuiEventListener)new NotificationButton(gui));
            event.addListener((GuiEventListener)new TeamManagerButton(gui));
            event.addListener((GuiEventListener)new EjectionMenuButton(gui));
            Minecraft mc = Minecraft.m_91087_();
            if (LCCurios.isLoaded()) {
                return;
            }
            event.addListener((GuiEventListener)new WalletButton(gui, CPacketOpenWallet::sendEquippedPacket));
            event.addListener((GuiEventListener)new VisibilityToggleButton(gui, ClientEvents::toggleVisibility));
        } else if (screen instanceof ContainerScreen) {
            ContainerScreen chestScreen = (ContainerScreen)screen;
            event.addListener((GuiEventListener)ChestCoinCollectButton.chestBuilder().screen(chestScreen).build());
        }
    }

    private static void toggleVisibility() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        IWalletHandler handler = WalletCapability.lazyGetWalletHandler((Entity)player);
        if (handler != null) {
            boolean nowVisible = !handler.visible();
            handler.setVisible(nowVisible);
            new CPacketSetVisible(player.m_19879_(), nowVisible).send();
        }
    }

    @SubscribeEvent
    public static void renderInventoryScreen(ContainerScreenEvent.Render.Background event) {
        Minecraft mc = Minecraft.m_91087_();
        if (LCCurios.isLoaded()) {
            return;
        }
        AbstractContainerScreen screen = event.getContainerScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen;
            if (screen instanceof CreativeModeInventoryScreen && !(creativeScreen = (CreativeModeInventoryScreen)screen).m_258017_()) {
                return;
            }
            EasyGuiGraphics gui = EasyGuiGraphics.create((ContainerScreenEvent.Render)event);
            ScreenPosition slotPosition = ClientEvents.getWalletSlotPosition(screen instanceof CreativeModeInventoryScreen).offsetScreen(screen);
            gui.resetColor();
            gui.blit(WALLET_SLOT_TEXTURE, slotPosition.x, slotPosition.y, 0, 0, 18, 18);
        }
    }

    @SubscribeEvent
    public static void renderInventoryTooltips(ScreenEvent.Render.Post event) {
        if (event.getScreen() instanceof InventoryScreen || event.getScreen() instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen;
            AbstractContainerScreen screen = (AbstractContainerScreen)event.getScreen();
            if (!screen.m_6262_().m_142621_().m_41619_()) {
                return;
            }
            if (screen instanceof CreativeModeInventoryScreen && !(creativeScreen = (CreativeModeInventoryScreen)screen).m_258017_()) {
                return;
            }
            EasyGuiGraphics gui = EasyGuiGraphics.create((ScreenEvent.Render)event);
            NotificationButton.tryRenderTooltip(gui);
            TeamManagerButton.tryRenderTooltip(gui);
            EjectionMenuButton.tryRenderTooltip(gui);
        } else if (event.getScreen() instanceof ContainerScreen) {
            ChestCoinCollectButton.tryRenderTooltip(EasyGuiGraphics.create((ScreenEvent.Render)event), event.getMouseX(), event.getMouseY());
        }
    }

    public static ScreenPosition getWalletSlotPosition(boolean isCreative) {
        return isCreative ? (ScreenPosition)LCConfig.CLIENT.walletSlotCreative.get() : (ScreenPosition)LCConfig.CLIENT.walletSlot.get();
    }

    @SubscribeEvent
    public static void playerJoinsServer(ClientPlayerNetworkEvent.LoggingIn event) {
        ConfigFile.loadClientFiles(ConfigFile.LoadPhase.GAME_START);
    }

    @SubscribeEvent
    public static void playerLeavesServer(ClientPlayerNetworkEvent.LoggingOut event) {
        SyncedConfigFile.onClientLeavesServer();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onItemTooltip(ItemTooltipEvent event) {
        CompoundTag tag;
        BlockItem bi;
        Block b;
        Item item;
        if (event.getEntity() == null || CoinAPI.API.NoDataAvailable()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (CoinAPI.API.IsCoin(stack, true)) {
            ChainData.addCoinTooltips(event.getItemStack(), event.getToolTip(), event.getFlags(), event.getEntity());
        }
        MoneyMendingEnchantment.addEnchantmentTooltip(stack, event.getToolTip());
        if (LCConfig.SERVER.isLoaded() && ((Boolean)LCConfig.SERVER.anarchyMode.get()).booleanValue() && (item = stack.m_41720_()) instanceof BlockItem && (b = (bi = (BlockItem)item).m_40614_()) instanceof IOwnableBlock) {
            TooltipItem.insertTooltip((List<Component>)event.getToolTip(), (Component)LCText.TOOLTIP_ANARCHY_WARNING.get(new Object[0]).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED));
        }
        if ((tag = stack.m_41783_()) != null && tag.m_128441_("StoredTrader")) {
            event.getToolTip().add(LCText.TOOLTIP_TRADER_ITEM_WITH_DATA.getWithStyle(ChatFormatting.GRAY));
            long traderID = tag.m_128454_("StoredTrader");
            TraderData trader = TraderAPI.API.GetTrader(true, traderID);
            if (trader != null) {
                TooltipItem.insertTooltip((List<Component>)event.getToolTip(), (Component)trader.getName().m_130940_(ChatFormatting.GRAY));
            }
            if (event.getFlags().m_7050_()) {
                TooltipItem.insertTooltip((List<Component>)event.getToolTip(), (Component)LCText.TOOLTIP_TRADER_ITEM_WITH_DATA_TRADER_ID.get(tag.m_128454_("StoredTrader")).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        if (stack.m_41720_() instanceof WalletItem) {
            ClientEvents.appendKeyBindTooltip(event, LCText.TOOLTIP_WALLET_KEY_BIND, KEY_WALLET);
        }
        if (LCCurios.isLoaded()) {
            if (stack.m_41720_() instanceof PortableTerminalItem) {
                ClientEvents.appendKeyBindTooltip(event, LCText.TOOLTIP_TERMINAL_KEY_BIND, KEY_PORTABLE_TERMINAL);
            }
            if (stack.m_41720_() instanceof PortableATMItem) {
                ClientEvents.appendKeyBindTooltip(event, LCText.TOOLTIP_ATM_KEY_BIND, KEY_PORTABLE_ATM);
            }
        }
        if (InventoryUtil.ItemHasTag(stack, LCTags.Items.VARIANT_WANDS)) {
            TooltipItem.insertTooltip((List<Component>)event.getToolTip(), LCText.TOOLTIP_VARIANT_WAND);
        }
    }

    private static void appendKeyBindTooltip(@Nonnull ItemTooltipEvent event, @Nonnull TextEntry tooltip, @Nonnull KeyMapping key) {
        event.getToolTip().add(1, tooltip.get(EasyText.makeMutable(key.m_90863_()).m_130940_(ChatFormatting.YELLOW)));
    }
}

