/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.settings.builtin;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.settings.data.LoadContext;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.settings.EasyTraderSettingsNode;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PermissionSettings
extends EasyTraderSettingsNode<TraderData> {
    public PermissionSettings(TraderData trader) {
        super("permissions", trader, 500);
    }

    @Override
    public MutableComponent getName() {
        return LCText.DATA_CATEGORY_TRADER_ALLY_PERMS.get(new Object[0]);
    }

    @Override
    protected String getRequiredPermission() {
        return "editPermissions";
    }

    @Override
    public void saveSettings(SavedSettingData.MutableNodeAccess data) {
        CompoundTag tag = new CompoundTag();
        ListTag permList = new ListTag();
        this.trader.getAllyPermissionMap().forEach((key, level) -> {
            CompoundTag entry = new CompoundTag();
            entry.m_128359_("perm", key);
            entry.m_128405_("level", level.intValue());
            permList.add((Object)entry);
        });
        tag.m_128365_("Perms", (Tag)permList);
        data.setCompoundValue("permissions", tag);
    }

    @Override
    public void loadSettings(SavedSettingData.NodeAccess data, LoadContext context) {
        if (data.hasCompoundValue("permissions")) {
            CompoundTag tag = data.getCompoundValue("permissions");
            ListTag permList = tag.m_128437_("Perms", 10);
            HashMap<String, Integer> temp = new HashMap<String, Integer>();
            for (int i = 0; i < permList.size(); ++i) {
                CompoundTag entry = permList.m_128728_(i);
                String key = entry.m_128461_("perm");
                int level = entry.m_128451_("level");
                temp.put(key, level);
            }
            this.trader.overwriteAllyPermissions(temp);
        }
    }

    @Override
    protected void writeLines(SavedSettingData.NodeAccess data, Consumer<Component> lineWriter) {
        if (data.hasCompoundValue("permissions")) {
            CompoundTag tag = data.getCompoundValue("permissions");
            ListTag permList = tag.m_128437_("Perms", 10);
            int count = 0;
            for (int i = 0; i < permList.size(); ++i) {
                if (permList.m_128728_(i).m_128451_("level") <= 0) continue;
                ++count;
            }
            lineWriter.accept((Component)PermissionSettings.formatEntry((Component)LCText.DATA_ENTRY_PERMISSIONS.get(new Object[0]), (Component)LCText.DATA_ENTRY_PERMISSIONS_COUNT.get(count)));
        }
    }
}

