/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.util.contract;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import net.satisfy.wildernature.util.contract.ContractReloader;
import net.satisfy.wildernature.util.contract.ContractReward;

public record Contract(ResourceLocation tier, ItemStack contractStack, ResourceLocation targetPredicate, ResourceLocation damagePredicate, int count, String name, String description, ContractReward reward) {
    public static final Codec<Contract> CODEC = RecordCodecBuilder.create(contractInstance -> contractInstance.group((App)ResourceLocation.f_135803_.fieldOf("type").forGetter(Contract::tier), (App)ItemStack.f_41582_.fieldOf("contractStack").forGetter(Contract::contractStack), (App)ResourceLocation.f_135803_.fieldOf("targetPredicate").forGetter(Contract::targetPredicate), (App)ResourceLocation.f_135803_.fieldOf("damagePredicate").forGetter(Contract::damagePredicate), (App)Codec.INT.fieldOf("count").forGetter(Contract::count), (App)Codec.STRING.fieldOf("name").forGetter(Contract::name), (App)Codec.STRING.fieldOf("description").forGetter(Contract::description), (App)ContractReward.CODEC.fieldOf("reward").forGetter(Contract::reward)).apply((Applicative)contractInstance, Contract::new));
    public static final Contract ERROR_CONTRACT = new Contract(new WilderNatureIdentifier("tier1"), ItemStack.f_41583_, new WilderNatureIdentifier("damage_any"), new WilderNatureIdentifier("_error"), 0, "Deleted contract", "Error: This contract was deleted from datapack", new ContractReward(0, 0, Optional.empty()));

    public static Contract fromId(ResourceLocation contract) {
        return Objects.requireNonNullElse(ContractReloader.getContract(contract), ERROR_CONTRACT);
    }
}

