/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.util;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class Truffling {
    private static final String TRUFFLED_KEY = "Truffled";

    public static boolean isTruffled(ItemStack itemStack) {
        return itemStack.m_41782_() && Objects.requireNonNull(itemStack.m_41783_()).m_128441_(TRUFFLED_KEY);
    }

    public static ItemStack setTruffled(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128379_(TRUFFLED_KEY, true);
        return itemStack;
    }

    public static FoodValue getAdditionalFoodValue() {
        return new FoodValue(0, 0.0f);
    }

    public static void addTruffledTooltip(ItemStack itemStack, List<Component> tooltip) {
        if (Truffling.isTruffled(itemStack)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.wildernature.truffled").m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.wildernature.truffled.nutrition").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.wildernature.truffled.saturationModifier").m_130940_(ChatFormatting.GREEN));
        }
    }

    public record FoodValue(int nutrition, float saturationModifier) {
        @Override
        public String toString() {
            return "{Nutrition:" + this.nutrition + ",Saturation:" + this.saturationModifier + "}";
        }
    }
}

