/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.registry;

import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.satisfy.wildernature.block.BisonTrophyBlock;
import net.satisfy.wildernature.block.BountyBoardBlock;
import net.satisfy.wildernature.block.CompletionistBannerBlock;
import net.satisfy.wildernature.block.CompletionistWallBannerBlock;
import net.satisfy.wildernature.block.DeerTrophyBlock;
import net.satisfy.wildernature.block.HazelnutBushBlock;
import net.satisfy.wildernature.block.RedWolfTrophyBlock;
import net.satisfy.wildernature.item.AmmunitionItem;
import net.satisfy.wildernature.item.BisonHornItem;
import net.satisfy.wildernature.item.BlunderBussItem;
import net.satisfy.wildernature.item.ContractItem;
import net.satisfy.wildernature.item.FlintAmmunitionItem;
import net.satisfy.wildernature.item.FurCloakItem;
import net.satisfy.wildernature.item.LootBagItem;
import net.satisfy.wildernature.item.StylinPurpleHatItem;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.SoundRegistry;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import net.satisfy.wildernature.util.WilderNatureUtil;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"wildernature", (ResourceKey)Registries.f_256913_);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"wildernature", (ResourceKey)Registries.f_256747_);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Item> BISON_MEAT = ObjectRegistry.registerItem("bison_meat", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38812_)));
    public static final RegistrySupplier<Item> COOKED_BISON_MEAT = ObjectRegistry.registerItem("cooked_bison_meat", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38820_)));
    public static final RegistrySupplier<Item> VENISON = ObjectRegistry.registerItem("venison", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38835_)));
    public static final RegistrySupplier<Item> COOKED_VENISON = ObjectRegistry.registerItem("cooked_venison", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38823_)));
    public static final RegistrySupplier<Item> TURKEY_MEAT = ObjectRegistry.registerItem("turkey_meat", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38817_)));
    public static final RegistrySupplier<Item> COOKED_TURKEY_MEAT = ObjectRegistry.registerItem("cooked_turkey_meat", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38821_)));
    public static final RegistrySupplier<Item> PELICAN_MEAT = ObjectRegistry.registerItem("pelican_meat", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38805_)));
    public static final RegistrySupplier<Item> COOKED_PELICAN_MEAT = ObjectRegistry.registerItem("cooked_pelican_meat", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38826_)));
    public static final RegistrySupplier<Item> CASSOWARY_MEAT = ObjectRegistry.registerItem("cassowary_meat", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38802_)));
    public static final RegistrySupplier<Item> COOKED_CASSOWARY_MEAT = ObjectRegistry.registerItem("cooked_cassowary_meat", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38825_)));
    public static final RegistrySupplier<Item> BLUNDERBUSS = ObjectRegistry.registerItem("blunderbuss", BlunderBussItem::new);
    public static final RegistrySupplier<Item> FLINT_AMMUNITION = ObjectRegistry.registerItem("flint_ammunition", () -> new FlintAmmunitionItem(ObjectRegistry.getSettings().m_41497_(Rarity.UNCOMMON), 4));
    public static final RegistrySupplier<Item> DIAMOND_AMMUNITION = ObjectRegistry.registerItem("diamond_ammunition", () -> new AmmunitionItem(ObjectRegistry.getSettings().m_41497_(Rarity.COMMON), 12));
    public static final RegistrySupplier<Item> FUR_CLOAK = ObjectRegistry.registerItem("fur_cloak", () -> new FurCloakItem((ArmorMaterial)ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
    public static final RegistrySupplier<Item> FISH_OIL = ObjectRegistry.registerItem("fish_oil", () -> new Item(ObjectRegistry.getSettings().m_41487_(16)));
    public static final RegistrySupplier<Item> LOOT_BAG = ObjectRegistry.registerItem("loot_bag", () -> new LootBagItem(ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Item> BISON_HORN = ObjectRegistry.registerItem("bison_horn", () -> new BisonHornItem(new Item.Properties().m_41487_(1), (SoundEvent)SoundRegistry.BISON_HORN.get()));
    public static final RegistrySupplier<Item> UNCOMMON_CONTRACT = ObjectRegistry.registerItem("uncommon_contract", () -> new ContractItem(ObjectRegistry.getSettings().m_41497_(Rarity.UNCOMMON)));
    public static final RegistrySupplier<Item> COMMON_CONTRACT = ObjectRegistry.registerItem("common_contract", () -> new ContractItem(ObjectRegistry.getSettings().m_41497_(Rarity.RARE)));
    public static final RegistrySupplier<Item> RARE_CONTRACT = ObjectRegistry.registerItem("rare_contract", () -> new ContractItem(ObjectRegistry.getSettings().m_41497_(Rarity.EPIC)));
    public static final RegistrySupplier<Item> LEVELING_CONTRACT = ObjectRegistry.registerItem("leveling_contract", () -> new ContractItem(ObjectRegistry.getSettings().m_41497_(Rarity.UNCOMMON)));
    public static final RegistrySupplier<Item> DEER_SPAWN_EGG = ObjectRegistry.registerItem("deer_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.DEER, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> RED_WOLF_SPAWN_EGG = ObjectRegistry.registerItem("red_wolf_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.RED_WOLF, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> RACCOON_SPAWN_EGG = ObjectRegistry.registerItem("raccoon_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.RACCOON, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> SQUIRREL_SPAWN_EGG = ObjectRegistry.registerItem("squirrel_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.SQUIRREL, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> PELICAN_SPAWN_EGG = ObjectRegistry.registerItem("pelican_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.PELICAN, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> OWL_SPAWN_EGG = ObjectRegistry.registerItem("owl_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.OWL, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> BOAR_SPAWN_EGG = ObjectRegistry.registerItem("boar_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.BOAR, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> BISON_SPAWN_EGG = ObjectRegistry.registerItem("bison_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.BISON, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> DOG_SPAWN_EGG = ObjectRegistry.registerItem("dog_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.DOG, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> MINISHEEP_SPAWN_EGG = ObjectRegistry.registerItem("minisheep_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.MINISHEEP, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> TURKEY_SPAWN_EGG = ObjectRegistry.registerItem("turkey_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.TURKEY, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> PENGUIN_SPAWN_EGG = ObjectRegistry.registerItem("penguin_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.PENGUIN, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> CASSOWARY_SPAWN_EGG = ObjectRegistry.registerItem("cassowary_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.CASSOWARY, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> HEDGEHOG_SPAWN_EGG = ObjectRegistry.registerItem("hedgehog_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.HEDGEHOG, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> FLAMINGO_SPAWN_EGG = ObjectRegistry.registerItem("flamingo_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.FLAMINGO, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> TRUFFLE = ObjectRegistry.registerItem("truffle", () -> new Item(ObjectRegistry.getSettings().m_41497_(Rarity.RARE)));
    public static final RegistrySupplier<Block> HAZELNUT_BUSH = ObjectRegistry.registerWithoutItem("hazelnut_bush", () -> new HazelnutBushBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60977_().m_60910_().m_60918_(SoundType.f_56757_).m_278166_(PushReaction.DESTROY)));
    public static final RegistrySupplier<Item> HAZELNUT = ObjectRegistry.registerItem("hazelnut", () -> new ItemNameBlockItem((Block)HAZELNUT_BUSH.get(), ObjectRegistry.getSettings().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38766_().m_38767_())));
    public static final RegistrySupplier<Block> BOUNTY_BOARD = ObjectRegistry.registerWithItem("bounty_board", () -> new BountyBoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> DEER_TROPHY = ObjectRegistry.registerWithItem("deer_trophy", () -> new DeerTrophyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> RED_WOLF_TROPHY = ObjectRegistry.registerWithItem("red_wolf_trophy", () -> new RedWolfTrophyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> BISON_TROPHY = ObjectRegistry.registerWithItem("bison_trophy", () -> new BisonTrophyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> WOLF_TRAPPER_BANNER = ObjectRegistry.registerWithItem("wolf_trapper_banner", () -> new CompletionistBannerBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> WOLF_TRAPPER_WALL_BANNER = ObjectRegistry.registerWithoutItem("wolf_trapper_wall_banner", () -> new CompletionistWallBannerBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> BUNNY_STALKER_BANNER = ObjectRegistry.registerWithItem("bunny_stalker_banner", () -> new CompletionistBannerBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> BUNNY_STALKER_WALL_BANNER = ObjectRegistry.registerWithoutItem("bunny_stalker_wall_banner", () -> new CompletionistWallBannerBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> COD_CATCHER_BANNER = ObjectRegistry.registerWithItem("cod_catcher_banner", () -> new CompletionistBannerBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> COD_CATCHER_WALL_BANNER = ObjectRegistry.registerWithoutItem("cod_catcher_wall_banner", () -> new CompletionistWallBannerBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Item> STYLIN_PURPLE_HAT = ObjectRegistry.registerItem("stylin_purple_hat", () -> new StylinPurpleHatItem((ArmorMaterial)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, ObjectRegistry.getSettings().m_41497_(Rarity.RARE), new WilderNatureIdentifier("textures/models/armor/stylin_purple_hat.png")));

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    public static BlockBehaviour.Properties properties(float strength) {
        return ObjectRegistry.properties(strength, strength);
    }

    public static BlockBehaviour.Properties properties(float breakSpeed, float explosionResist) {
        return BlockBehaviour.Properties.m_284310_().m_60913_(breakSpeed, explosionResist);
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return WilderNatureUtil.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, new WilderNatureIdentifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return WilderNatureUtil.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, new WilderNatureIdentifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return WilderNatureUtil.registerItem(ITEMS, ITEM_REGISTRAR, new WilderNatureIdentifier(path), itemSupplier);
    }
}

