/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.item;

import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.wildernature.entity.BulletEntity;
import net.satisfy.wildernature.item.AmmunitionItem;
import net.satisfy.wildernature.item.FlintAmmunitionItem;
import net.satisfy.wildernature.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;

public class BlunderBussItem
extends ProjectileWeaponItem {
    private static final int DEFAULT_BONUS_DAMAGE = 0;
    private static final double DEFAULT_DAMAGE_MULTIPLIER = 1.0;
    private static final int DEFAULT_FIRE_DELAY = 30;
    private static final double DEFAULT_INACCURACY = 2.25;
    private static final double DEFAULT_PROJECTILE_SPEED = 4.0;
    private static final int DEFAULT_DURABILITY = 128;
    private static final Ingredient DEFAULT_REPAIR_MATERIAL = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_});
    private static final Predicate<ItemStack> BULLETS = stack -> stack.m_41720_() instanceof AmmunitionItem && ((AmmunitionItem)stack.m_41720_()).hasAmmo((ItemStack)stack);
    private final int bonusDamage;
    private final double damageMultiplier;
    private final int fireDelay;
    private final double inaccuracy;
    private final double projectileSpeed;
    private final boolean ignoreInvulnerability;
    private final Ingredient repairMaterial = DEFAULT_REPAIR_MATERIAL;

    public BlunderBussItem() {
        super(new Item.Properties().m_41503_(128));
        this.bonusDamage = 0;
        this.damageMultiplier = 1.0;
        this.fireDelay = 30;
        this.inaccuracy = 2.25;
        this.projectileSpeed = 4.0;
        this.ignoreInvulnerability = false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack gun = player.m_21120_(hand);
        ItemStack ammo = player.m_6298_(gun);
        if (!ammo.m_41619_() || player.m_150110_().f_35937_) {
            Item item;
            if (ammo.m_41619_()) {
                ammo = new ItemStack((ItemLike)Items.f_42416_);
            }
            if ((item = ammo.m_41720_()) instanceof AmmunitionItem) {
                AmmunitionItem bulletItem = (AmmunitionItem)item;
                if (!world.f_46443_) {
                    boolean bulletFree = player.m_150110_().f_35937_ || !this.shouldConsumeAmmo();
                    this.shoot(world, player, ammo, bulletItem);
                    gun.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                    if (!bulletFree) {
                        bulletItem.consume(ammo, player);
                    }
                }
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.BLUNDERBUSS_SHOOT.get(), SoundSource.PLAYERS, 1.0f, world.m_213780_().m_188501_() * 5.0f + 1.0f);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                player.m_36335_().m_41524_((Item)this, this.getFireDelay());
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    double particleX = player.m_20185_() + player.m_20154_().f_82479_ * 2.5;
                    double particleY = player.m_20186_() + (double)player.m_20192_() - 0.3;
                    double particleZ = player.m_20189_() + player.m_20154_().f_82481_ * 1.5;
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_175834_, particleX, particleY, particleZ, 5, 0.1, 0.1, 0.1, 0.01);
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, particleX, particleY, particleZ, 10, 0.1, 0.1, 0.1, 0.01);
                    serverWorld.m_7654_().m_6937_((Runnable)new TickTask(serverWorld.m_7654_().m_129921_() + 40, () -> world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.BLUNDERBUSS_LOAD.get(), SoundSource.PLAYERS, 0.5f, 1.0f)));
                }
                return InteractionResultHolder.m_19096_((Object)gun);
            }
        } else {
            return InteractionResultHolder.m_19100_((Object)gun);
        }
        return InteractionResultHolder.m_19098_((Object)gun);
    }

    protected void shoot(Level world, Player player, ItemStack ammo, AmmunitionItem bulletItem) {
        if (bulletItem instanceof FlintAmmunitionItem) {
            int pelletCount = 4 + world.m_213780_().m_188503_(5);
            for (int i = 0; i < pelletCount; ++i) {
                BulletEntity pellet = bulletItem.createProjectile(world, ammo.m_41777_(), (LivingEntity)player);
                float spread = (float)(this.getInaccuracy() * 3.5);
                pellet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, (float)this.getProjectileSpeed() * 0.6f, spread);
                double distScale = Math.max(0.2, 1.0 - (double)player.m_20270_((Entity)pellet) / 12.0);
                pellet.setDamage((double)(bulletItem.getDamage() + 3) * this.getDamageMultiplier() * distScale);
                pellet.setIgnoreInvulnerability(this.ignoreInvulnerability);
                pellet.setLifeTicks(12 + world.m_213780_().m_188503_(4));
                world.m_7967_((Entity)pellet);
            }
        } else {
            BulletEntity shot = bulletItem.createProjectile(world, ammo, (LivingEntity)player);
            shot.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, (float)this.getProjectileSpeed(), (float)this.getInaccuracy());
            shot.setDamage((shot.getDamage() + this.getBonusDamage()) * this.getDamageMultiplier());
            shot.setIgnoreInvulnerability(this.ignoreInvulnerability);
            world.m_7967_((Entity)shot);
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            double particleX = player.m_20185_() + player.m_20154_().f_82479_ * 0.5;
            double particleY = player.m_20186_() + (double)player.m_20192_() - 0.1;
            double particleZ = player.m_20189_() + player.m_20154_().f_82481_ * 0.5;
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_175834_, particleX, particleY, particleZ, 5, 0.1, 0.1, 0.1, 0.01);
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, particleX, particleY, particleZ, 10, 0.1, 0.1, 0.1, 0.01);
        }
    }

    public boolean shouldConsumeAmmo() {
        return true;
    }

    public double getBonusDamage() {
        return this.bonusDamage;
    }

    public double getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public int getFireDelay() {
        return this.fireDelay;
    }

    public double getInaccuracy() {
        return this.inaccuracy;
    }

    public double getProjectileSpeed() {
        return this.projectileSpeed;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_6473_() {
        return 0;
    }

    @NotNull
    public Predicate<ItemStack> m_6437_() {
        return BULLETS;
    }

    public int m_6615_() {
        return 15;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return this.repairMaterial.test(repair) || super.m_6832_(toRepair, repair);
    }
}

