/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.forge.world;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.satisfy.wildernature.forge.registry.WilderNatureBiomeModifiers;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.TagsRegistry;

public class AddAnimalsBiomeModifier
implements BiomeModifier {
    private static final Set<EntityType<?>> registeredEntities = new HashSet();

    private static <T extends Mob> void registerEntity(EntityType<T> type, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> predicate) {
        if (!registeredEntities.contains(type)) {
            SpawnPlacements.m_21754_(type, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)heightmapType, predicate);
            registeredEntities.add(type);
        }
    }

    public static void registerEntities() {
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.SQUIRREL.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.OWL.get(), Heightmap.Types.MOTION_BLOCKING, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.TURKEY.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.RACCOON.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.PELICAN.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.DEER.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.RED_WOLF.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.BOAR.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.BISON.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.DOG.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.MINISHEEP.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.PENGUIN.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.CASSOWARY.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.HEDGEHOG.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.FLAMINGO.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase.equals((Object)BiomeModifier.Phase.ADD)) {
            AddAnimalsBiomeModifier.registerEntities();
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_DEER, (EntityType)EntityRegistry.DEER.get(), 12, 2, 4);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_RACCOON, (EntityType)EntityRegistry.RACCOON.get(), 8, 2, 3);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_SQUIRREL, (EntityType)EntityRegistry.SQUIRREL.get(), 8, 2, 2);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_RED_WOLF, (EntityType)EntityRegistry.RED_WOLF.get(), 10, 3, 4);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_OWL, (EntityType)EntityRegistry.OWL.get(), 12, 3, 3);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_BOAR, (EntityType)EntityRegistry.BOAR.get(), 14, 5, 5);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_BISON, (EntityType)EntityRegistry.BISON.get(), 10, 3, 5);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_TURKEY, (EntityType)EntityRegistry.TURKEY.get(), 12, 3, 5);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_PELICAN, (EntityType)EntityRegistry.PELICAN.get(), 5, 3, 4);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_DOG, (EntityType)EntityRegistry.DOG.get(), 4, 1, 1);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_MINISHEEP, (EntityType)EntityRegistry.MINISHEEP.get(), 8, 2, 4);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_PENGUIN, (EntityType)EntityRegistry.PENGUIN.get(), 10, 2, 5);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_CASSOWARY, (EntityType)EntityRegistry.CASSOWARY.get(), 12, 3, 4);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_HEDGEHOG, (EntityType)EntityRegistry.HEDGEHOG.get(), 9, 2, 3);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_FLAMINGO, (EntityType)EntityRegistry.FLAMINGO.get(), 10, 4, 6);
            this.addMobSpawn(builder, biome, (TagKey<Biome>)BiomeTags.f_207610_, EntityType.f_217012_, 8, 3, 4);
        }
    }

    void addMobSpawn(ModifiableBiomeInfo.BiomeInfo.Builder builder, Holder<Biome> biome, TagKey<Biome> tag, EntityType<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        if (biome.m_203656_(tag)) {
            builder.getMobSpawnSettings().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(entityType, weight, minGroupSize, maxGroupSize));
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)WilderNatureBiomeModifiers.ADD_ANIMALS_CODEC.get();
    }
}

